/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.image;

import games.strategy.triplea.ResourceLoader;
import games.strategy.triplea.delegate.Die;
import games.strategy.triplea.image.ImageFactory;
import games.strategy.ui.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class DiceImageFactory {
    public int DIE_WIDTH = 32;
    public int DIE_HEIGHT = 32;
    private final int m_diceSides;
    private final ResourceLoader m_resourceLoader;
    private static final Color s_ignored = new Color(100, 100, 100, 200);
    private final Map<Integer, Image> m_images = new HashMap<Integer, Image>();
    private final Map<Integer, Image> m_imagesHit = new HashMap<Integer, Image>();
    private final Map<Integer, Image> m_imagesIgnored = new HashMap<Integer, Image>();

    public DiceImageFactory(ResourceLoader loader, int diceSides) {
        int PIP_SIZE = 6;
        this.m_diceSides = Math.max(6, diceSides);
        this.m_resourceLoader = loader;
        this.generateDice(6, Color.black, this.m_images);
        this.generateDice(6, Color.red, this.m_imagesHit);
        this.generateDice(6, s_ignored, this.m_imagesIgnored);
    }

    private void generateDice(int PIP_SIZE, Color color, Map<Integer, Image> images) {
        ImageFactory iFactory = new ImageFactory();
        iFactory.setResourceLoader(this.m_resourceLoader);
        for (int i = 1; i <= this.m_diceSides; ++i) {
            Image img = null;
            if (this.m_resourceLoader != null) {
                if (color == Color.black) {
                    img = iFactory.getImage("dice/" + i + ".png", false);
                } else if (color == Color.red) {
                    img = iFactory.getImage("dice/" + i + "_hit.png", false);
                } else if (color == s_ignored) {
                    img = iFactory.getImage("dice/" + i + "_ignored.png", false);
                }
            }
            if (img != null) {
                images.put(i, img);
                continue;
            }
            BufferedImage canvas = Util.createImage(this.DIE_WIDTH, this.DIE_HEIGHT, true);
            Graphics graphics = ((Image)canvas).getGraphics();
            graphics.setColor(color);
            graphics.drawRoundRect(1, 1, this.DIE_WIDTH - 3, this.DIE_HEIGHT - 3, 5, 5);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (i == 1 || i == 3 || i == 5) {
                graphics.fillOval(this.DIE_WIDTH / 2 - PIP_SIZE / 2, this.DIE_HEIGHT / 2 - PIP_SIZE / 2, PIP_SIZE, PIP_SIZE);
            }
            if (i == 3 || i == 5 || i == 4) {
                graphics.fillOval(this.DIE_WIDTH / 4 - PIP_SIZE / 2, this.DIE_HEIGHT / 4 - PIP_SIZE / 2, PIP_SIZE, PIP_SIZE);
                graphics.fillOval(3 * this.DIE_WIDTH / 4 - PIP_SIZE / 2, 3 * this.DIE_HEIGHT / 4 - PIP_SIZE / 2, PIP_SIZE, PIP_SIZE);
            }
            if (i == 5 || i == 4) {
                graphics.fillOval(3 * this.DIE_WIDTH / 4 - PIP_SIZE / 2, this.DIE_HEIGHT / 4 - PIP_SIZE / 2, PIP_SIZE, PIP_SIZE);
                graphics.fillOval(this.DIE_WIDTH / 4 - PIP_SIZE / 2, 3 * this.DIE_HEIGHT / 4 - PIP_SIZE / 2, PIP_SIZE, PIP_SIZE);
            }
            if (i == 2 || i == 6) {
                graphics.fillOval(this.DIE_WIDTH / 3 - PIP_SIZE / 2, this.DIE_HEIGHT / 2 - PIP_SIZE / 2, PIP_SIZE, PIP_SIZE);
                graphics.fillOval(2 * this.DIE_WIDTH / 3 - PIP_SIZE / 2, this.DIE_HEIGHT / 2 - PIP_SIZE / 2, PIP_SIZE, PIP_SIZE);
            }
            if (i == 6) {
                graphics.fillOval(this.DIE_WIDTH / 3 - PIP_SIZE / 2, this.DIE_HEIGHT / 4 - PIP_SIZE / 2, PIP_SIZE, PIP_SIZE);
                graphics.fillOval(2 * this.DIE_WIDTH / 3 - PIP_SIZE / 2, this.DIE_HEIGHT / 4 - PIP_SIZE / 2, PIP_SIZE, PIP_SIZE);
                graphics.fillOval(this.DIE_WIDTH / 3 - PIP_SIZE / 2, 3 * this.DIE_HEIGHT / 4 - PIP_SIZE / 2, PIP_SIZE, PIP_SIZE);
                graphics.fillOval(2 * this.DIE_WIDTH / 3 - PIP_SIZE / 2, 3 * this.DIE_HEIGHT / 4 - PIP_SIZE / 2, PIP_SIZE, PIP_SIZE);
            }
            if (i > 6) {
                graphics.setFont(new Font("Arial", 1, 16));
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                String number = Integer.toString(i);
                int widthOffset = graphics.getFontMetrics().charsWidth(number.toCharArray(), 0, number.length());
                int heightOffset = graphics.getFontMetrics().getHeight();
                graphics.drawString(number, (this.DIE_WIDTH - widthOffset) / 2, (this.DIE_HEIGHT + heightOffset) / 2 - 2);
            }
            images.put(i, canvas);
            graphics.dispose();
        }
    }

    public Image getDieImage(int i, Die.DieType type) {
        if (i <= 0) {
            throw new IllegalArgumentException("die must be greater than 0, not:" + i);
        }
        if (i > this.m_diceSides) {
            BufferedImage canvas = Util.createImage(this.DIE_WIDTH, this.DIE_HEIGHT, true);
            Graphics graphics = ((Image)canvas).getGraphics();
            graphics.setFont(new Font("Arial", 1, 16));
            switch (type) {
                case HIT: {
                    graphics.setColor(Color.RED);
                    break;
                }
                case MISS: {
                    graphics.setColor(Color.BLACK);
                    break;
                }
                case IGNORED: {
                    graphics.setColor(s_ignored);
                    break;
                }
                default: {
                    throw new IllegalStateException("??");
                }
            }
            graphics.drawRoundRect(1, 1, this.DIE_WIDTH - 3, this.DIE_HEIGHT - 3, 5, 5);
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            String number = Integer.toString(i);
            int widthOffset = graphics.getFontMetrics().charsWidth(number.toCharArray(), 0, number.length());
            int heightOffset = graphics.getFontMetrics().getHeight();
            graphics.drawString(number, (this.DIE_WIDTH - widthOffset) / 2, (this.DIE_HEIGHT + heightOffset) / 2 - 2);
            return canvas;
        }
        switch (type) {
            case HIT: {
                return this.m_imagesHit.get(i);
            }
            case MISS: {
                return this.m_images.get(i);
            }
            case IGNORED: {
                return this.m_imagesIgnored.get(i);
            }
        }
        throw new IllegalStateException("??");
    }

    public Icon getDieIcon(int i, Die.DieType type) {
        return new ImageIcon(this.getDieImage(i, type));
    }

    public static void main(String[] args) {
        int i;
        DiceImageFactory instance = new DiceImageFactory(null, 6);
        JFrame frame = new JFrame();
        for (i = 1; i <= 6; ++i) {
            frame.getContentPane().setLayout(new BoxLayout(frame.getContentPane(), 1));
            frame.getContentPane().add(new JLabel(instance.getDieIcon(i, Die.DieType.HIT)));
            frame.getContentPane().add(Box.createVerticalStrut(4));
        }
        for (i = 1; i <= 6; ++i) {
            frame.getContentPane().setLayout(new BoxLayout(frame.getContentPane(), 1));
            frame.getContentPane().add(new JLabel(instance.getDieIcon(i, Die.DieType.MISS)));
            frame.getContentPane().add(Box.createVerticalStrut(4));
        }
        for (i = 1; i <= 6; ++i) {
            frame.getContentPane().setLayout(new BoxLayout(frame.getContentPane(), 1));
            frame.getContentPane().add(new JLabel(instance.getDieIcon(i, Die.DieType.IGNORED)));
            frame.getContentPane().add(Box.createVerticalStrut(4));
        }
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

