/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.image;

import java.awt.Image;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

class ImageRef {
    public static final ReferenceQueue<Image> s_referenceQueue = new ReferenceQueue();
    public static final Logger s_logger = Logger.getLogger(ImageRef.class.getName());
    private static final AtomicInteger s_imageCount = new AtomicInteger();
    private final Reference<Image> m_image;

    public ImageRef(Image image) {
        this.m_image = new SoftReference<Image>(image, s_referenceQueue);
        s_logger.finer("Added soft reference image. Image count:" + s_imageCount.incrementAndGet());
    }

    public Image getImage() {
        return this.m_image.get();
    }

    public void clear() {
        this.m_image.enqueue();
        this.m_image.clear();
    }

    static {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            s_referenceQueue.remove();
                            s_logger.finer("Removed soft reference image. Image count:" + s_imageCount.decrementAndGet());
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        Thread t = new Thread(r, "Tile Image Factory Soft Reference Reclaimer");
        t.setDaemon(true);
        t.start();
    }
}

