/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.image;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Resource;
import games.strategy.triplea.ResourceLoader;
import games.strategy.ui.Util;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class ResourceImageFactory {
    public static final int DEFAULT_RESOURCE_ICON_SIZE = 12;
    public static final int LARGE_RESOURCE_ICON_SIZE = 24;
    private static final String FILE_NAME_BASE = "resources/";
    private final Map<String, Image> m_images = new HashMap<String, Image>();
    private final Map<String, ImageIcon> m_icons = new HashMap<String, ImageIcon>();
    private double m_scaleFactor;
    private ResourceLoader m_resourceLoader;

    public void setResourceLoader(ResourceLoader loader, double scaleFactor) {
        this.m_scaleFactor = scaleFactor;
        this.m_resourceLoader = loader;
        this.clearImageCache();
    }

    public void setScaleFactor(double scaleFactor) {
        if (this.m_scaleFactor != scaleFactor) {
            this.m_scaleFactor = scaleFactor;
            this.clearImageCache();
        }
    }

    public double getScaleFactor() {
        return this.m_scaleFactor;
    }

    public int getUnitImageWidth(boolean large) {
        return (int)(this.m_scaleFactor * (double)(large ? 24 : 12));
    }

    public int getUnitImageHeight(boolean large) {
        return (int)(this.m_scaleFactor * (double)(large ? 24 : 12));
    }

    private void clearImageCache() {
        this.m_images.clear();
        this.m_icons.clear();
    }

    public Image getImage(Resource type, GameData data, boolean large) {
        String fullName = type.getName() + (large ? "_large" : "");
        if (this.m_images.containsKey(fullName)) {
            return this.m_images.get(fullName);
        }
        Image baseImage = this.getBaseImage(fullName);
        int width = (int)((double)baseImage.getWidth(null) * this.m_scaleFactor);
        int height = (int)((double)baseImage.getHeight(null) * this.m_scaleFactor);
        Image scaledImage = baseImage.getScaledInstance(width, height, 4);
        try {
            Util.ensureImageLoaded(scaledImage);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.m_images.put(fullName, scaledImage);
        return scaledImage;
    }

    private Image getBaseImage(String baseImageName) {
        String fileName = FILE_NAME_BASE + baseImageName + ".png";
        URL url = this.m_resourceLoader.getResource(fileName);
        if (url == null) {
            throw new IllegalStateException("Cant load: " + baseImageName + "  looking in: " + fileName);
        }
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        try {
            Util.ensureImageLoaded(image);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return image;
    }

    public ImageIcon getIcon(Resource type, GameData data, boolean large) {
        String fullName = type.getName() + (large ? "_large" : "");
        if (this.m_icons.containsKey(fullName)) {
            return this.m_icons.get(fullName);
        }
        Image img = this.getBaseImage(fullName);
        ImageIcon icon = new ImageIcon(img);
        this.m_icons.put(fullName, icon);
        return icon;
    }
}

