/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import games.strategy.util.IntegerMap;
import games.strategy.util.Tuple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AggregateResults
implements Serializable {
    private static final long serialVersionUID = -556699626060414738L;
    private final List<BattleResults> m_results;
    private long m_time;

    public AggregateResults(int expectedCount) {
        this.m_results = new ArrayList<BattleResults>(expectedCount);
    }

    public void addResult(BattleResults result) {
        this.m_results.add(result);
    }

    public void addResults(Collection<BattleResults> results) {
        this.m_results.addAll(results);
    }

    public List<BattleResults> getResults() {
        return this.m_results;
    }

    public BattleResults GetBattleResultsClosestToAverage() {
        double closestBattleDif = 2.147483647E9;
        BattleResults closestBattle = null;
        for (BattleResults results : this.m_results) {
            double dif = Math.abs((double)results.getAttackingCombatUnitsLeft() - this.getAverageAttackingUnitsLeft());
            if (!((dif += Math.abs((double)results.getDefendingCombatUnitsLeft() - this.getAverageDefendingUnitsLeft())) < closestBattleDif)) continue;
            closestBattleDif = dif;
            closestBattle = results;
        }
        return closestBattle;
    }

    public List<Unit> GetAverageAttackingUnitsRemaining() {
        BattleResults results = this.GetBattleResultsClosestToAverage();
        return results == null ? new ArrayList() : results.getRemainingAttackingUnits();
    }

    public List<Unit> GetAverageDefendingUnitsRemaining() {
        BattleResults results = this.GetBattleResultsClosestToAverage();
        return results == null ? new ArrayList() : results.getRemainingDefendingUnits();
    }

    public double getAverageAttackingUnitsLeft() {
        if (this.m_results.isEmpty()) {
            return 0.0;
        }
        double count = 0.0;
        for (BattleResults result : this.m_results) {
            count += (double)result.getAttackingCombatUnitsLeft();
        }
        return count / (double)this.m_results.size();
    }

    public Tuple<Double, Double> getAverageTUVofUnitsLeftOver(IntegerMap<UnitType> attackerCostsForTUV, IntegerMap<UnitType> defenderCostsForTUV) {
        if (this.m_results.isEmpty()) {
            return new Tuple<Double, Double>(0.0, 0.0);
        }
        double attackerTUV = 0.0;
        double defenderTUV = 0.0;
        for (BattleResults result : this.m_results) {
            attackerTUV += (double)BattleCalculator.getTUV(result.getRemainingAttackingUnits(), attackerCostsForTUV);
            defenderTUV += (double)BattleCalculator.getTUV(result.getRemainingDefendingUnits(), defenderCostsForTUV);
        }
        return new Tuple<Double, Double>(attackerTUV / (double)this.m_results.size(), defenderTUV / (double)this.m_results.size());
    }

    public double getAverageTUVswing(PlayerID attacker, Collection<Unit> attackers, PlayerID defender, Collection<Unit> defenders, GameData data) {
        if (this.m_results.isEmpty()) {
            return 0.0;
        }
        IntegerMap<UnitType> attackerCostsForTUV = BattleCalculator.getCostsForTUV(attacker, data);
        IntegerMap<UnitType> defenderCostsForTUV = BattleCalculator.getCostsForTUV(defender, data);
        int attackerTotalTUV = BattleCalculator.getTUV(attackers, attackerCostsForTUV);
        int defenderTotalTUV = BattleCalculator.getTUV(defenders, defenderCostsForTUV);
        Tuple<Double, Double> average = this.getAverageTUVofUnitsLeftOver(attackerCostsForTUV, defenderCostsForTUV);
        double attackerLost = (double)attackerTotalTUV - average.getFirst();
        double defenderLost = (double)defenderTotalTUV - average.getSecond();
        return defenderLost - attackerLost;
    }

    public double getAverageAttackingUnitsLeftWhenAttackerWon() {
        if (this.m_results.isEmpty()) {
            return 0.0;
        }
        double count = 0.0;
        double total = 0.0;
        for (BattleResults result : this.m_results) {
            if (!result.attackerWon()) continue;
            count += (double)result.getAttackingCombatUnitsLeft();
            total += 1.0;
        }
        if (total <= 0.0) {
            return 0.0;
        }
        return count / total;
    }

    public double getAverageDefendingUnitsLeft() {
        if (this.m_results.isEmpty()) {
            return 0.0;
        }
        double count = 0.0;
        for (BattleResults result : this.m_results) {
            count += (double)result.getDefendingCombatUnitsLeft();
        }
        return count / (double)this.m_results.size();
    }

    public double getAverageDefendingUnitsLeftWhenDefenderWon() {
        if (this.m_results.isEmpty()) {
            return 0.0;
        }
        double count = 0.0;
        double total = 0.0;
        for (BattleResults result : this.m_results) {
            if (!result.defenderWon()) continue;
            count += (double)result.getDefendingCombatUnitsLeft();
            total += 1.0;
        }
        if (total <= 0.0) {
            return 0.0;
        }
        return count / total;
    }

    public double getAttackerWinPercent() {
        if (this.m_results.isEmpty()) {
            return 0.0;
        }
        double count = 0.0;
        for (BattleResults result : this.m_results) {
            if (!result.attackerWon()) continue;
            count += 1.0;
        }
        return count / (double)this.m_results.size();
    }

    public double getDefenderWinPercent() {
        if (this.m_results.isEmpty()) {
            return 0.0;
        }
        double count = 0.0;
        for (BattleResults result : this.m_results) {
            if (!result.defenderWon()) continue;
            count += 1.0;
        }
        return count / (double)this.m_results.size();
    }

    public double getAverageBattleRoundsFought() {
        if (this.m_results.isEmpty()) {
            return 0.0;
        }
        double count = 0.0;
        for (BattleResults result : this.m_results) {
            count += (double)result.getBattleRoundsFought();
        }
        if (count == 0.0) {
            return 1.0;
        }
        return count / (double)this.m_results.size();
    }

    public double getDrawPercent() {
        if (this.m_results.isEmpty()) {
            return 0.0;
        }
        double count = 0.0;
        for (BattleResults result : this.m_results) {
            if (!result.draw()) continue;
            count += 1.0;
        }
        return count / (double)this.m_results.size();
    }

    public int getRollCount() {
        return this.m_results.size();
    }

    public long getTime() {
        return this.m_time;
    }

    public void setTime(long time) {
        this.m_time = time;
    }
}

