/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.Match;
import java.io.Serializable;
import java.util.List;

public class BattleResults
extends GameDataComponent
implements Serializable {
    private static final long serialVersionUID = 1381361441940258702L;
    private final int m_battleRoundsFought;
    final List<Unit> m_remainingAttackingUnits;
    final List<Unit> m_remainingDefendingUnits;
    private IBattle.WhoWon m_whoWon;

    public BattleResults(IBattle battle, GameData data) {
        super(data);
        this.m_battleRoundsFought = battle.getBattleRound();
        this.m_remainingAttackingUnits = battle.getRemainingAttackingUnits();
        this.m_remainingDefendingUnits = battle.getRemainingDefendingUnits();
        this.m_whoWon = battle.getWhoWon();
        if (this.m_whoWon == IBattle.WhoWon.NOTFINISHED) {
            throw new IllegalStateException("Battle not finished yet: " + battle);
        }
    }

    public BattleResults(IBattle battle, IBattle.WhoWon scriptedWhoWon, GameData data) {
        super(data);
        this.m_battleRoundsFought = battle.getBattleRound();
        this.m_remainingAttackingUnits = battle.getRemainingAttackingUnits();
        this.m_remainingDefendingUnits = battle.getRemainingDefendingUnits();
        this.m_whoWon = scriptedWhoWon;
    }

    public void setWhoWon(IBattle.WhoWon whoWon) {
        this.m_whoWon = whoWon;
    }

    public List<Unit> getRemainingAttackingUnits() {
        return this.m_remainingAttackingUnits;
    }

    public List<Unit> getRemainingDefendingUnits() {
        return this.m_remainingDefendingUnits;
    }

    public List<Unit> getRemainingAttackingCombatUnits() {
        return Match.getMatches(this.m_remainingAttackingUnits, Matches.UnitIsNotInfrastructure);
    }

    public List<Unit> getRemainingDefendingCombatUnits() {
        return Match.getMatches(this.m_remainingDefendingUnits, Matches.UnitIsNotInfrastructure);
    }

    public int getAttackingCombatUnitsLeft() {
        return Match.countMatches(this.m_remainingAttackingUnits, Matches.UnitIsNotInfrastructure);
    }

    public int getDefendingCombatUnitsLeft() {
        return Match.countMatches(this.m_remainingDefendingUnits, Matches.UnitIsNotInfrastructure);
    }

    public int getBattleRoundsFought() {
        return this.m_battleRoundsFought;
    }

    public boolean attackerWon() {
        return !this.draw() && this.m_whoWon == IBattle.WhoWon.ATTACKER;
    }

    public boolean defenderWon() {
        return !this.draw() && this.m_whoWon == IBattle.WhoWon.DEFENDER;
    }

    public boolean draw() {
        return this.m_whoWon != IBattle.WhoWon.ATTACKER && this.m_whoWon != IBattle.WhoWon.DEFENDER || this.getAttackingCombatUnitsLeft() == 0 && this.getDefendingCombatUnitsLeft() == 0;
    }
}

