/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.framework.GameDataUtils;
import games.strategy.triplea.oddsCalculator.ta.AggregateResults;
import games.strategy.triplea.oddsCalculator.ta.DaemonThreadFactory;
import games.strategy.triplea.oddsCalculator.ta.IOddsCalculator;
import games.strategy.triplea.oddsCalculator.ta.OddsCalculator;
import games.strategy.triplea.oddsCalculator.ta.OddsCalculatorListener;
import games.strategy.util.CountUpAndDownLatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConcurrentOddsCalculator
implements IOddsCalculator {
    private static final Logger s_logger = Logger.getLogger(ConcurrentOddsCalculator.class.getName());
    private static final int MAX_THREADS = Math.max(1, Runtime.getRuntime().availableProcessors());
    private int m_currentThreads = MAX_THREADS;
    private final ExecutorService m_executor;
    private final CopyOnWriteArrayList<OddsCalculator> m_workers = new CopyOnWriteArrayList();
    private volatile boolean m_isDataSet = false;
    private volatile boolean m_isCalcSet = false;
    private volatile boolean m_isShutDown = false;
    private volatile int m_cancelCurrentOperation = 0;
    private final CountUpAndDownLatch m_latchSetData = new CountUpAndDownLatch();
    private final CountUpAndDownLatch m_latchWorkerThreadsCreation = new CountUpAndDownLatch();
    private final Object m_mutexSetGameData = new Object();
    private final Object m_mutexCalcIsRunning = new Object();
    private final List<OddsCalculatorListener> m_listeners = new ArrayList<OddsCalculatorListener>();

    public ConcurrentOddsCalculator(String threadNamePrefix) {
        this.m_executor = Executors.newFixedThreadPool(MAX_THREADS, new DaemonThreadFactory(true, threadNamePrefix + " ConcurrentOddsCalculator Worker"));
        s_logger.fine("Initialized executor thread pool with size: " + MAX_THREADS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGameData(final GameData data) {
        this.m_latchSetData.increment();
        --this.m_cancelCurrentOperation;
        this.cancel();
        Object object = this.m_mutexSetGameData;
        synchronized (object) {
            try {
                this.m_latchWorkerThreadsCreation.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.cancel();
            this.m_isDataSet = false;
            this.m_isCalcSet = false;
            if (data == null || this.m_isShutDown) {
                this.m_workers.clear();
                ++this.m_cancelCurrentOperation;
                this.m_latchSetData.countDown();
            } else {
                ++this.m_cancelCurrentOperation;
                this.m_latchWorkerThreadsCreation.increment();
                this.m_executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        ConcurrentOddsCalculator.this.createWorkers(data);
                    }
                });
            }
        }
    }

    @Override
    public int getThreadCount() {
        return this.m_currentThreads;
    }

    private static int getThreadsToUse(long timeToCopyInMillis, long memoryUsedBeforeCopy) {
        if (timeToCopyInMillis > 20000L || MAX_THREADS == 1) {
            return 1;
        }
        Runtime runtime = Runtime.getRuntime();
        long usedMemoryAfterCopy = runtime.totalMemory() - runtime.freeMemory();
        long memoryLeftBeforeMax = runtime.maxMemory() - Math.max(usedMemoryAfterCopy, memoryUsedBeforeCopy);
        long memoryUsedByCopy = Math.max(100000L, usedMemoryAfterCopy - memoryUsedBeforeCopy);
        int numberOfTimesWeCanCopyMax = Math.max(1, (int)Math.min(Integer.MAX_VALUE, memoryLeftBeforeMax / memoryUsedByCopy));
        if (timeToCopyInMillis > 3000L) {
            return Math.min(numberOfTimesWeCanCopyMax, Math.max(1, MAX_THREADS / 2));
        }
        return Math.min(numberOfTimesWeCanCopyMax, MAX_THREADS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWorkers(GameData data) {
        block15: {
            this.m_workers.clear();
            if (data != null && this.m_cancelCurrentOperation >= 0) {
                GameData newData;
                long startTime = System.currentTimeMillis();
                long startMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
                try {
                    data.acquireReadLock();
                    newData = GameDataUtils.cloneGameData(data, false);
                }
                finally {
                    data.releaseReadLock();
                }
                this.m_currentThreads = ConcurrentOddsCalculator.getThreadsToUse(System.currentTimeMillis() - startTime, startMemory);
                try {
                    int i;
                    newData.acquireReadLock();
                    if (this.m_currentThreads <= 2 || MAX_THREADS <= 2) {
                        while (this.m_cancelCurrentOperation >= 0 && i < this.m_currentThreads) {
                            this.m_workers.add(new OddsCalculator(newData, this.m_currentThreads == ++i));
                        }
                        break block15;
                    }
                    final CountDownLatch workerLatch = new CountDownLatch(this.m_currentThreads - 1);
                    for (i = 0; i < this.m_currentThreads - 1; ++i) {
                        this.m_executor.submit(new Runnable(){

                            @Override
                            public void run() {
                                if (ConcurrentOddsCalculator.this.m_cancelCurrentOperation >= 0) {
                                    ConcurrentOddsCalculator.this.m_workers.add(new OddsCalculator(newData, false));
                                }
                                workerLatch.countDown();
                            }
                        });
                    }
                    this.m_workers.add(new OddsCalculator(newData, true));
                    try {
                        workerLatch.await();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                finally {
                    newData.releaseReadLock();
                }
            }
        }
        if (this.m_cancelCurrentOperation < 0 || data == null) {
            this.m_workers.clear();
            this.m_isDataSet = false;
        } else {
            this.m_isDataSet = true;
            this.notifyListenersGameDataIsSet();
        }
        this.m_latchWorkerThreadsCreation.countDown();
        this.m_latchSetData.countDown();
        s_logger.fine("Initialized worker thread pool with size: " + this.m_workers.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.m_isShutDown = true;
        this.m_cancelCurrentOperation = -1073741824;
        this.cancel();
        this.m_executor.shutdown();
        List<OddsCalculatorListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.clear();
        }
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    private void awaitLatch() {
        try {
            this.m_latchSetData.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCalculateData(PlayerID attacker, PlayerID defender, Territory location, Collection<Unit> attacking, Collection<Unit> defending, Collection<Unit> bombarding, Collection<TerritoryEffect> territoryEffects, int runCount) {
        Object object = this.m_mutexCalcIsRunning;
        synchronized (object) {
            this.awaitLatch();
            this.m_isCalcSet = false;
            int workerNum = this.m_workers.size();
            int workerRunCount = Math.max(1, runCount / Math.max(1, workerNum));
            for (OddsCalculator worker : this.m_workers) {
                if (!this.m_isDataSet || this.m_isShutDown) {
                    return;
                }
                worker.setCalculateData(attacker, defender, location, attacking, defending, bombarding, territoryEffects, runCount <= 0 ? 0 : workerRunCount);
                runCount -= workerRunCount;
            }
            if (!this.m_isDataSet || this.m_isShutDown || workerNum <= 0) {
                return;
            }
            this.m_isCalcSet = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AggregateResults calculate() throws IllegalStateException {
        Object object = this.m_mutexCalcIsRunning;
        synchronized (object) {
            this.awaitLatch();
            long start = System.currentTimeMillis();
            int totalRunCount = 0;
            ArrayList<Future<AggregateResults>> list = new ArrayList<Future<AggregateResults>>();
            for (OddsCalculator worker : this.m_workers) {
                if (!this.getIsReady()) {
                    return new AggregateResults(0);
                }
                if (!worker.getIsReady()) {
                    throw new IllegalStateException("Called calculate before setting calculate data!");
                }
                if (worker.getRunCount() <= 0) continue;
                totalRunCount += worker.getRunCount();
                Future<AggregateResults> workerResult = this.m_executor.submit(worker);
                list.add(workerResult);
            }
            AggregateResults results = new AggregateResults(totalRunCount);
            HashSet<InterruptedException> interruptExceptions = new HashSet<InterruptedException>();
            HashMap<String, HashSet<ExecutionException>> executionExceptions = new HashMap<String, HashSet<ExecutionException>>();
            for (Future future : list) {
                try {
                    AggregateResults result = (AggregateResults)future.get();
                    results.addResults(result.getResults());
                }
                catch (InterruptedException e) {
                    interruptExceptions.add(e);
                }
                catch (ExecutionException e) {
                    String cause = e.getCause().getLocalizedMessage();
                    HashSet<ExecutionException> exceptions = (HashSet<ExecutionException>)executionExceptions.get(cause);
                    if (exceptions == null) {
                        exceptions = new HashSet<ExecutionException>();
                    }
                    exceptions.add(e);
                    executionExceptions.put(cause, exceptions);
                }
            }
            if (!interruptExceptions.isEmpty()) {
                s_logger.log(Level.SEVERE, interruptExceptions.size() + " Battle results workers interrupted", (Throwable)interruptExceptions.iterator().next());
            }
            if (!executionExceptions.isEmpty()) {
                Throwable e = null;
                for (Set entry : executionExceptions.values()) {
                    if (entry.isEmpty()) continue;
                    e = (Exception)entry.iterator().next();
                    s_logger.log(Level.SEVERE, entry.size() + " Battle results workers aborted by exception", e.getCause());
                }
                if (e != null) {
                    throw new IllegalStateException(e.getCause());
                }
            }
            results.setTime(System.currentTimeMillis() - start);
            return results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AggregateResults setCalculateDataAndCalculate(PlayerID attacker, PlayerID defender, Territory location, Collection<Unit> attacking, Collection<Unit> defending, Collection<Unit> bombarding, Collection<TerritoryEffect> territoryEffects, int runCount) {
        Object object = this.m_mutexCalcIsRunning;
        synchronized (object) {
            this.setCalculateData(attacker, defender, location, attacking, defending, bombarding, territoryEffects, runCount);
            return this.calculate();
        }
    }

    @Override
    public boolean getIsReady() {
        return this.m_isDataSet && this.m_isCalcSet && !this.m_isShutDown;
    }

    @Override
    public int getRunCount() {
        int totalRunCount = 0;
        for (OddsCalculator worker : this.m_workers) {
            totalRunCount += worker.getRunCount();
        }
        return totalRunCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKeepOneAttackingLandUnit(boolean bool) {
        Object object = this.m_mutexCalcIsRunning;
        synchronized (object) {
            this.awaitLatch();
            for (OddsCalculator worker : this.m_workers) {
                worker.setKeepOneAttackingLandUnit(bool);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAmphibious(boolean bool) {
        Object object = this.m_mutexCalcIsRunning;
        synchronized (object) {
            this.awaitLatch();
            for (OddsCalculator worker : this.m_workers) {
                worker.setAmphibious(bool);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRetreatAfterRound(int value) {
        Object object = this.m_mutexCalcIsRunning;
        synchronized (object) {
            this.awaitLatch();
            for (OddsCalculator worker : this.m_workers) {
                worker.setRetreatAfterRound(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRetreatAfterXUnitsLeft(int value) {
        Object object = this.m_mutexCalcIsRunning;
        synchronized (object) {
            this.awaitLatch();
            for (OddsCalculator worker : this.m_workers) {
                worker.setRetreatAfterXUnitsLeft(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRetreatWhenOnlyAirLeft(boolean value) {
        Object object = this.m_mutexCalcIsRunning;
        synchronized (object) {
            this.awaitLatch();
            for (OddsCalculator worker : this.m_workers) {
                worker.setRetreatWhenOnlyAirLeft(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRetreatWhenMetaPowerIsLower(boolean value) {
        Object object = this.m_mutexCalcIsRunning;
        synchronized (object) {
            this.awaitLatch();
            for (OddsCalculator worker : this.m_workers) {
                worker.setRetreatWhenMetaPowerIsLower(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttackerOrderOfLosses(String attackerOrderOfLosses) {
        Object object = this.m_mutexCalcIsRunning;
        synchronized (object) {
            this.awaitLatch();
            for (OddsCalculator worker : this.m_workers) {
                worker.setAttackerOrderOfLosses(attackerOrderOfLosses);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefenderOrderOfLosses(String defenderOrderOfLosses) {
        Object object = this.m_mutexCalcIsRunning;
        synchronized (object) {
            this.awaitLatch();
            for (OddsCalculator worker : this.m_workers) {
                worker.setDefenderOrderOfLosses(defenderOrderOfLosses);
            }
        }
    }

    @Override
    public void cancel() {
        for (OddsCalculator worker : this.m_workers) {
            worker.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOddsCalculatorListener(OddsCalculatorListener listener) {
        List<OddsCalculatorListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOddsCalculatorListener(OddsCalculatorListener listener) {
        List<OddsCalculatorListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersGameDataIsSet() {
        List<OddsCalculatorListener> list = this.m_listeners;
        synchronized (list) {
            for (OddsCalculatorListener listener : this.m_listeners) {
                listener.dataReady();
            }
        }
    }
}

