/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangePerformer;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitHitsChange;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.display.IDisplay;
import games.strategy.engine.gamePlayer.IRemotePlayer;
import games.strategy.engine.history.DelegateHistoryWriter;
import games.strategy.engine.history.IDelegateHistoryWriter;
import games.strategy.engine.random.IRandomStats;
import games.strategy.engine.random.PlainRandomSource;
import games.strategy.sound.DummySoundChannel;
import games.strategy.sound.ISound;
import games.strategy.triplea.delegate.MustFightBattle;
import games.strategy.triplea.oddsCalculator.ta.DummyGameModifiedChannel;
import games.strategy.triplea.oddsCalculator.ta.DummyPlayer;
import games.strategy.triplea.ui.display.DummyTripleaDisplay;
import java.util.List;
import java.util.Properties;

class DummyDelegateBridge
implements IDelegateBridge {
    private final PlainRandomSource m_randomSource = new PlainRandomSource();
    private final DummyTripleaDisplay m_display = new DummyTripleaDisplay();
    private final DummySoundChannel m_soundChannel = new DummySoundChannel();
    private final DummyPlayer m_attackingPlayer;
    private final DummyPlayer m_defendingPlayer;
    private final PlayerID m_attacker;
    private final DelegateHistoryWriter m_writer = new DelegateHistoryWriter(new DummyGameModifiedChannel());
    private final CompositeChange m_allChanges;
    private final GameData m_data;
    private final ChangePerformer m_changePerformer;
    private MustFightBattle m_battle = null;

    public DummyDelegateBridge(PlayerID attacker, GameData data, CompositeChange allChanges, List<Unit> attackerOrderOfLosses, List<Unit> defenderOrderOfLosses, boolean attackerKeepOneLandUnit, int retreatAfterRound, int retreatAfterXUnitsLeft, boolean retreatWhenOnlyAirLeft, boolean retreatWhenMetaPowerIsLower) {
        this.m_attackingPlayer = new DummyPlayer(this, true, "battle calc dummy", "None (AI)", attackerOrderOfLosses, attackerKeepOneLandUnit, retreatAfterRound, retreatAfterXUnitsLeft, retreatWhenOnlyAirLeft, retreatWhenMetaPowerIsLower);
        this.m_defendingPlayer = new DummyPlayer(this, false, "battle calc dummy", "None (AI)", defenderOrderOfLosses, false, retreatAfterRound, -1, false, false);
        this.m_data = data;
        this.m_attacker = attacker;
        this.m_allChanges = allChanges;
        this.m_changePerformer = new ChangePerformer(this.m_data);
    }

    @Override
    public GameData getData() {
        return this.m_data;
    }

    @Override
    public void leaveDelegateExecution() {
    }

    @Override
    public Properties getStepProperties() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStepName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IRemotePlayer getRemotePlayer(PlayerID id) {
        if (id.equals(this.m_attacker)) {
            return this.m_attackingPlayer;
        }
        return this.m_defendingPlayer;
    }

    @Override
    public IRemotePlayer getRemotePlayer() {
        return this.m_attackingPlayer;
    }

    @Override
    public int[] getRandom(int max, int count, PlayerID player, IRandomStats.DiceType diceType, String annotation) {
        return this.m_randomSource.getRandom(max, count, annotation);
    }

    @Override
    public int getRandom(int max, PlayerID player, IRandomStats.DiceType diceType, String annotation) {
        return this.m_randomSource.getRandom(max, annotation);
    }

    @Override
    public PlayerID getPlayerID() {
        return this.m_attacker;
    }

    @Override
    public IDelegateHistoryWriter getHistoryWriter() {
        return this.m_writer;
    }

    @Override
    public IDisplay getDisplayChannelBroadcaster() {
        return this.m_display;
    }

    @Override
    public ISound getSoundChannelBroadcaster() {
        return this.m_soundChannel;
    }

    @Override
    public void enterDelegateExecution() {
    }

    @Override
    public void addChange(Change aChange) {
        if (!(aChange instanceof UnitHitsChange)) {
            return;
        }
        this.m_allChanges.add(aChange);
        this.m_changePerformer.perform(aChange);
    }

    @Override
    public void stopGameSequence() {
    }

    public MustFightBattle getBattle() {
        return this.m_battle;
    }

    public void setBattle(MustFightBattle battle) {
        this.m_battle = battle;
    }
}

