/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.net.GUID;
import games.strategy.triplea.ai.AIUtils;
import games.strategy.triplea.ai.AbstractAI;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MustFightBattle;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.delegate.dataObjects.CasualtyList;
import games.strategy.triplea.delegate.remote.IAbstractPlaceDelegate;
import games.strategy.triplea.delegate.remote.IMoveDelegate;
import games.strategy.triplea.delegate.remote.IPurchaseDelegate;
import games.strategy.triplea.delegate.remote.ITechDelegate;
import games.strategy.triplea.oddsCalculator.ta.DummyDelegateBridge;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DummyPlayer
extends AbstractAI {
    private final boolean m_keepAtLeastOneLand;
    private final int m_retreatAfterRound;
    private final int m_retreatAfterXUnitsLeft;
    private final boolean m_retreatWhenOnlyAirLeft;
    private final boolean m_retreatWhenMetaPowerIsLower;
    private final DummyDelegateBridge m_bridge;
    private final boolean m_isAttacker;
    private final List<Unit> m_orderOfLosses;

    public DummyPlayer(DummyDelegateBridge dummyDelegateBridge, boolean attacker, String name, String type, List<Unit> orderOfLosses, boolean keepAtLeastOneLand, int retreatAfterRound, int retreatAfterXUnitsLeft, boolean retreatWhenOnlyAirLeft, boolean retreatWhenMetaPowerIsLower) {
        super(name, type);
        this.m_keepAtLeastOneLand = keepAtLeastOneLand;
        this.m_retreatAfterRound = retreatAfterRound;
        this.m_retreatAfterXUnitsLeft = retreatAfterXUnitsLeft;
        this.m_retreatWhenOnlyAirLeft = retreatWhenOnlyAirLeft;
        this.m_retreatWhenMetaPowerIsLower = retreatWhenMetaPowerIsLower;
        this.m_bridge = dummyDelegateBridge;
        this.m_isAttacker = attacker;
        this.m_orderOfLosses = orderOfLosses;
    }

    private MustFightBattle getBattle() {
        return this.m_bridge.getBattle();
    }

    private List<Unit> getOurUnits() {
        MustFightBattle battle = this.getBattle();
        if (battle == null) {
            return null;
        }
        return new ArrayList<Unit>(this.m_isAttacker ? battle.getAttackingUnits() : battle.getDefendingUnits());
    }

    private List<Unit> getEnemyUnits() {
        MustFightBattle battle = this.getBattle();
        if (battle == null) {
            return null;
        }
        return new ArrayList<Unit>(this.m_isAttacker ? battle.getDefendingUnits() : battle.getAttackingUnits());
    }

    @Override
    protected void move(boolean nonCombat, IMoveDelegate moveDel, GameData data, PlayerID player) {
    }

    @Override
    protected void place(boolean placeForBid, IAbstractPlaceDelegate placeDelegate, GameData data, PlayerID player) {
    }

    @Override
    protected void purchase(boolean purcahseForBid, int PUsToSpend, IPurchaseDelegate purchaseDelegate, GameData data, PlayerID player) {
    }

    @Override
    protected void tech(ITechDelegate techDelegate, GameData data, PlayerID player) {
    }

    @Override
    public boolean confirmMoveInFaceOfAA(Collection<Territory> aaFiringTerritories) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Unit> getNumberOfFightersToMoveToNewCarrier(Collection<Unit> fightersThatCanBeMoved, Territory from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Territory retreatQuery(GUID battleID, boolean submerge, Territory battleSite, Collection<Territory> possibleTerritories, String message) {
        if (possibleTerritories.isEmpty()) {
            return null;
        }
        if (submerge) {
            CompositeMatchAnd seaSub = new CompositeMatchAnd(Matches.UnitIsSea, Matches.UnitIsSub);
            CompositeMatchAnd planeNotDestroyer = new CompositeMatchAnd(Matches.UnitIsAir, Matches.UnitIsDestroyer.invert());
            List<Unit> ourUnits = this.getOurUnits();
            List<Unit> enemyUnits = this.getEnemyUnits();
            if (ourUnits == null || enemyUnits == null) {
                return null;
            }
            if (enemyUnits.size() > 0 && Match.allMatch(ourUnits, seaSub) && Match.allMatch(enemyUnits, planeNotDestroyer)) {
                return possibleTerritories.iterator().next();
            }
            return null;
        }
        MustFightBattle battle = this.getBattle();
        if (battle == null) {
            return null;
        }
        if (this.m_retreatAfterRound > -1 && battle.getBattleRound() >= this.m_retreatAfterRound) {
            return possibleTerritories.iterator().next();
        }
        if (!this.m_retreatWhenOnlyAirLeft && this.m_retreatAfterXUnitsLeft <= -1 && !this.m_retreatWhenMetaPowerIsLower) {
            return null;
        }
        Collection<Unit> unitsLeft = this.m_isAttacker ? battle.getAttackingUnits() : battle.getDefendingUnits();
        List<Unit> airLeft = Match.getMatches(unitsLeft, Matches.UnitIsAir);
        if (this.m_retreatWhenOnlyAirLeft) {
            int retreatNum = airLeft.size();
            if (this.m_retreatAfterXUnitsLeft > 0) {
                retreatNum += this.m_retreatAfterXUnitsLeft;
            }
            if (retreatNum >= unitsLeft.size()) {
                return possibleTerritories.iterator().next();
            }
        }
        if (this.m_retreatAfterXUnitsLeft > -1 && this.m_retreatAfterXUnitsLeft >= unitsLeft.size()) {
            return possibleTerritories.iterator().next();
        }
        if (this.m_retreatWhenMetaPowerIsLower) {
            List<Unit> ourUnits = this.getOurUnits();
            List<Unit> enemyUnits = this.getEnemyUnits();
            if (ourUnits != null && enemyUnits != null) {
                int enemyMetaPower;
                int ourHP = BattleCalculator.getTotalHitpointsLeft(ourUnits);
                int enemyHP = BattleCalculator.getTotalHitpointsLeft(enemyUnits);
                int ourPower = DiceRoll.getTotalPowerAndRolls(DiceRoll.getUnitPowerAndRollsForNormalBattles(ourUnits, ourUnits, enemyUnits, !this.m_isAttacker, false, this.m_isAttacker ? battle.getAttacker() : battle.getDefender(), this.m_bridge.getData(), battle.getTerritory(), battle.getTerritoryEffects(), battle.isAmphibious(), battle.isAmphibious() && this.m_isAttacker ? ourUnits : new ArrayList()), this.m_bridge.getData()).getFirst();
                int enemyPower = DiceRoll.getTotalPowerAndRolls(DiceRoll.getUnitPowerAndRollsForNormalBattles(enemyUnits, enemyUnits, ourUnits, this.m_isAttacker, false, this.m_isAttacker ? battle.getDefender() : battle.getAttacker(), this.m_bridge.getData(), battle.getTerritory(), battle.getTerritoryEffects(), battle.isAmphibious(), battle.isAmphibious() && !this.m_isAttacker ? enemyUnits : new ArrayList()), this.m_bridge.getData()).getFirst();
                int diceSides = this.m_bridge.getData().getDiceSides();
                int ourMetaPower = BattleCalculator.getNormalizedMetaPower(ourPower, ourHP, diceSides);
                if (ourMetaPower < (enemyMetaPower = BattleCalculator.getNormalizedMetaPower(enemyPower, enemyHP, diceSides))) {
                    return possibleTerritories.iterator().next();
                }
            }
        }
        return null;
    }

    @Override
    public HashMap<Territory, Collection<Unit>> scrambleUnitsQuery(Territory scrambleTo, Map<Territory, Tuple<Collection<Unit>, Collection<Unit>>> possibleScramblers) {
        return null;
    }

    @Override
    public Collection<Unit> selectUnitsQuery(Territory current, Collection<Unit> possible, String message) {
        return null;
    }

    @Override
    public CasualtyDetails selectCasualties(Collection<Unit> selectFrom, Map<Unit, Collection<Unit>> dependents, int count, String message, DiceRoll dice, PlayerID hit, Collection<Unit> friendlyUnits, PlayerID enemyPlayer, Collection<Unit> enemyUnits, boolean amphibious, Collection<Unit> amphibiousLandAttackers, CasualtyList defaultCasualties, GUID battleID, Territory battlesite, boolean allowMultipleHitsPerUnit) {
        ArrayList<Unit> rDamaged = new ArrayList<Unit>(defaultCasualties.getDamaged());
        ArrayList<Unit> rKilled = new ArrayList<Unit>(defaultCasualties.getKilled());
        if (this.m_keepAtLeastOneLand) {
            ArrayList<Unit> notKilled = new ArrayList<Unit>(selectFrom);
            notKilled.removeAll(rKilled);
            if (!Match.someMatch(notKilled, Matches.UnitIsLand) && Match.someMatch(notKilled, Matches.UnitIsNotLand) && Match.someMatch(rKilled, Matches.UnitIsLand)) {
                List<Unit> notKilledAndNotLand = Match.getMatches(notKilled, Matches.UnitIsNotLand);
                Collections.sort(notKilledAndNotLand, AIUtils.getCostComparator());
                rKilled.remove(rKilled.size() - 1);
                rKilled.add(notKilledAndNotLand.get(0));
            }
        }
        if (this.m_orderOfLosses != null && !this.m_orderOfLosses.isEmpty() && !rKilled.isEmpty()) {
            ArrayList<Unit> orderOfLosses = new ArrayList<Unit>(this.m_orderOfLosses);
            orderOfLosses.retainAll(selectFrom);
            if (!orderOfLosses.isEmpty()) {
                int killedSize;
                rKilled.clear();
                for (killedSize = rKilled.size(); killedSize > 0 && !orderOfLosses.isEmpty(); --killedSize) {
                    rKilled.add((Unit)orderOfLosses.get(0));
                    orderOfLosses.remove(0);
                }
                if (killedSize > 0) {
                    ArrayList<Unit> defaultKilled = new ArrayList<Unit>(defaultCasualties.getKilled());
                    defaultKilled.removeAll(rKilled);
                    while (killedSize > 0) {
                        rKilled.add((Unit)defaultKilled.get(0));
                        defaultKilled.remove(0);
                        --killedSize;
                    }
                }
            }
        }
        CasualtyDetails casualtyDetails = new CasualtyDetails(rKilled, rDamaged, false);
        return casualtyDetails;
    }

    @Override
    public Territory selectTerritoryForAirToLand(Collection<Territory> candidates, Territory currentTerritory, String unitMessage) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean shouldBomberBomb(Territory territory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Unit whatShouldBomberBomb(Territory territory, Collection<Unit> potentialTargets, Collection<Unit> bombers) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] selectFixedDice(int numRolls, int hitAt, boolean hitOnlyIfEquals, String message, int diceSides) {
        int[] dice = new int[numRolls];
        for (int i = 0; i < numRolls; ++i) {
            dice[i] = (int)Math.ceil(Math.random() * (double)diceSides);
        }
        return dice;
    }
}

