/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.common.delegate.GameDelegateBridge;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.ChangePerformer;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.UnitTypeList;
import games.strategy.engine.framework.GameDataUtils;
import games.strategy.triplea.delegate.BattleTracker;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MustFightBattle;
import games.strategy.triplea.oddsCalculator.ta.AggregateResults;
import games.strategy.triplea.oddsCalculator.ta.BattleResults;
import games.strategy.triplea.oddsCalculator.ta.DummyDelegateBridge;
import games.strategy.triplea.oddsCalculator.ta.IOddsCalculator;
import games.strategy.triplea.oddsCalculator.ta.OddsCalculatorListener;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;

public class OddsCalculator
implements IOddsCalculator,
Callable<AggregateResults> {
    public static final String OOL_ALL = "*";
    public static final String OOL_ALL_REGEX = "\\*";
    public static final String OOL_SEPARATOR = ";";
    public static final String OOL_SEPARATOR_REGEX = ";";
    public static final String OOL_AMOUNT_DESCRIPTOR = "^";
    public static final String OOL_AMOUNT_DESCRIPTOR_REGEX = "\\^";
    private GameData m_data = null;
    private PlayerID m_attacker = null;
    private PlayerID m_defender = null;
    private Territory m_location = null;
    private Collection<Unit> m_attackingUnits = new ArrayList<Unit>();
    private Collection<Unit> m_defendingUnits = new ArrayList<Unit>();
    private Collection<Unit> m_bombardingUnits = new ArrayList<Unit>();
    private Collection<TerritoryEffect> m_territoryEffects = new ArrayList<TerritoryEffect>();
    private boolean m_keepOneAttackingLandUnit = false;
    private boolean m_amphibious = false;
    private int m_retreatAfterRound = -1;
    private int m_retreatAfterXUnitsLeft = -1;
    private boolean m_retreatWhenOnlyAirLeft = false;
    private boolean m_retreatWhenMetaPowerIsLower = false;
    private String m_attackerOrderOfLosses = null;
    private String m_defenderOrderOfLosses = null;
    private int m_runCount = 0;
    private volatile boolean m_cancelled = false;
    private volatile boolean m_isDataSet = false;
    private volatile boolean m_isCalcSet = false;
    private volatile boolean m_isRunning = false;
    private final List<OddsCalculatorListener> m_listeners = new ArrayList<OddsCalculatorListener>();

    public OddsCalculator(GameData data) {
        this(data, false);
    }

    public OddsCalculator(GameData data, boolean dataHasAlreadyBeenCloned) {
        GameData gameData = data == null ? null : (this.m_data = dataHasAlreadyBeenCloned ? data : GameDataUtils.cloneGameData(data, false));
        if (data != null) {
            this.m_isDataSet = true;
            this.notifyListenersGameDataIsSet();
        }
    }

    @Override
    public void setGameData(GameData data) {
        if (this.m_isRunning) {
            return;
        }
        this.m_isDataSet = false;
        this.m_isCalcSet = false;
        this.m_data = data == null ? null : GameDataUtils.cloneGameData(data, false);
        this.m_attacker = null;
        this.m_defender = null;
        this.m_location = null;
        this.m_attackingUnits = new ArrayList<Unit>();
        this.m_defendingUnits = new ArrayList<Unit>();
        this.m_bombardingUnits = new ArrayList<Unit>();
        this.m_territoryEffects = new ArrayList<TerritoryEffect>();
        this.m_runCount = 0;
        if (data != null) {
            this.m_isDataSet = true;
            this.notifyListenersGameDataIsSet();
        }
    }

    @Override
    public void setCalculateData(PlayerID attacker, PlayerID defender, Territory location, Collection<Unit> attacking, Collection<Unit> defending, Collection<Unit> bombarding, Collection<TerritoryEffect> territoryEffects, int runCount) throws IllegalStateException {
        if (this.m_isRunning) {
            return;
        }
        this.m_isCalcSet = false;
        if (!this.m_isDataSet) {
            throw new IllegalStateException("Called set calculation before setting game data!");
        }
        this.m_attacker = this.m_data.getPlayerList().getPlayerID(attacker == null ? PlayerID.NULL_PLAYERID.getName() : attacker.getName());
        this.m_defender = this.m_data.getPlayerList().getPlayerID(defender == null ? PlayerID.NULL_PLAYERID.getName() : defender.getName());
        this.m_location = this.m_data.getMap().getTerritory(location.getName());
        this.m_attackingUnits = (Collection)GameDataUtils.translateIntoOtherGameData(attacking, this.m_data);
        this.m_defendingUnits = (Collection)GameDataUtils.translateIntoOtherGameData(defending, this.m_data);
        this.m_bombardingUnits = (Collection)GameDataUtils.translateIntoOtherGameData(bombarding, this.m_data);
        this.m_territoryEffects = (Collection)GameDataUtils.translateIntoOtherGameData(territoryEffects, this.m_data);
        ChangePerformer changePerformer = new ChangePerformer(this.m_data);
        changePerformer.perform(ChangeFactory.removeUnits(this.m_location, this.m_location.getUnits().getUnits()));
        changePerformer.perform(ChangeFactory.addUnits(this.m_location, this.m_attackingUnits));
        changePerformer.perform(ChangeFactory.addUnits(this.m_location, this.m_defendingUnits));
        this.m_runCount = runCount;
        this.m_isCalcSet = true;
    }

    @Override
    public AggregateResults setCalculateDataAndCalculate(PlayerID attacker, PlayerID defender, Territory location, Collection<Unit> attacking, Collection<Unit> defending, Collection<Unit> bombarding, Collection<TerritoryEffect> territoryEffects, int runCount) {
        this.setCalculateData(attacker, defender, location, attacking, defending, bombarding, territoryEffects, runCount);
        return this.calculate();
    }

    @Override
    public AggregateResults calculate() {
        if (!this.getIsReady()) {
            throw new IllegalStateException("Called calculate before setting calculate data!");
        }
        return this.calculate(this.m_runCount);
    }

    @Override
    public AggregateResults call() throws Exception {
        return this.calculate();
    }

    @Override
    public boolean getIsReady() {
        return this.m_isDataSet && this.m_isCalcSet;
    }

    @Override
    public int getRunCount() {
        return this.m_runCount;
    }

    @Override
    public void setKeepOneAttackingLandUnit(boolean bool) {
        this.m_keepOneAttackingLandUnit = bool;
    }

    @Override
    public void setAmphibious(boolean bool) {
        this.m_amphibious = bool;
    }

    @Override
    public void setRetreatAfterRound(int value) {
        this.m_retreatAfterRound = value;
    }

    @Override
    public void setRetreatAfterXUnitsLeft(int value) {
        this.m_retreatAfterXUnitsLeft = value;
    }

    @Override
    public void setRetreatWhenOnlyAirLeft(boolean value) {
        this.m_retreatWhenOnlyAirLeft = value;
    }

    @Override
    public void setRetreatWhenMetaPowerIsLower(boolean value) {
        this.m_retreatWhenMetaPowerIsLower = value;
    }

    @Override
    public void setAttackerOrderOfLosses(String attackerOrderOfLosses) {
        this.m_attackerOrderOfLosses = attackerOrderOfLosses;
    }

    @Override
    public void setDefenderOrderOfLosses(String defenderOrderOfLosses) {
        this.m_defenderOrderOfLosses = defenderOrderOfLosses;
    }

    @Override
    public void cancel() {
        this.m_cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.cancel();
        List<OddsCalculatorListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.clear();
        }
    }

    @Override
    public int getThreadCount() {
        return 1;
    }

    private AggregateResults calculate(int count) {
        this.m_isRunning = true;
        long start = System.currentTimeMillis();
        AggregateResults rVal = new AggregateResults(count);
        BattleTracker battleTracker = new BattleTracker();
        List<Unit> attackerOrderOfLosses = OddsCalculator.getUnitListByOOL(this.m_attackerOrderOfLosses, this.m_attackingUnits, this.m_data);
        List<Unit> defenderOrderOfLosses = OddsCalculator.getUnitListByOOL(this.m_defenderOrderOfLosses, this.m_defendingUnits, this.m_data);
        for (int i = 0; i < count && !this.m_cancelled; ++i) {
            CompositeChange allChanges = new CompositeChange();
            DummyDelegateBridge bridge1 = new DummyDelegateBridge(this.m_attacker, this.m_data, allChanges, attackerOrderOfLosses, defenderOrderOfLosses, this.m_keepOneAttackingLandUnit, this.m_retreatAfterRound, this.m_retreatAfterXUnitsLeft, this.m_retreatWhenOnlyAirLeft, this.m_retreatWhenMetaPowerIsLower);
            GameDelegateBridge bridge = new GameDelegateBridge(bridge1);
            MustFightBattle battle = new MustFightBattle(this.m_location, this.m_attacker, this.m_data, battleTracker);
            battle.setHeadless(true);
            battle.isAmphibious();
            battle.setUnits(this.m_defendingUnits, this.m_attackingUnits, this.m_bombardingUnits, this.m_amphibious ? this.m_attackingUnits : new ArrayList<Unit>(), this.m_defender, this.m_territoryEffects);
            bridge1.setBattle(battle);
            battle.fight(bridge);
            rVal.addResult(new BattleResults(battle, this.m_data));
            new ChangePerformer(this.m_data).perform(allChanges.invert());
            battleTracker.clear();
            battleTracker.clearBattleRecords();
        }
        rVal.setTime(System.currentTimeMillis() - start);
        this.m_isRunning = false;
        this.m_cancelled = false;
        return rVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidOOL(String ool, GameData data) {
        if (ool == null || ool.trim().length() == 0) {
            return true;
        }
        try {
            UnitTypeList unitTypes;
            String[] sections = ool.indexOf(";") != -1 ? ool.trim().split(";") : new String[]{ool.trim()};
            try {
                data.acquireReadLock();
                unitTypes = data.getUnitTypeList();
            }
            finally {
                data.releaseReadLock();
            }
            for (String section : sections) {
                int amount;
                if (section.length() == 0) continue;
                String[] amountThenType = section.split(OOL_AMOUNT_DESCRIPTOR_REGEX);
                if (amountThenType.length != 2) {
                    return false;
                }
                if (!amountThenType[0].equals(OOL_ALL) && (amount = Integer.parseInt(amountThenType[0])) <= 0) {
                    return false;
                }
                UnitType type = unitTypes.getUnitType(amountThenType[1]);
                if (type != null) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static List<Unit> getUnitListByOOL(String ool, Collection<Unit> units, GameData data) {
        if (ool == null || ool.trim().length() == 0) {
            return null;
        }
        ArrayList<Tuple<Integer, UnitType>> map = new ArrayList<Tuple<Integer, UnitType>>();
        String[] sections = ool.indexOf(";") != -1 ? ool.trim().split(";") : new String[]{ool.trim()};
        for (String string : sections) {
            if (string.length() == 0) continue;
            String[] amountThenType = string.split(OOL_AMOUNT_DESCRIPTOR_REGEX);
            int amount = amountThenType[0].equals(OOL_ALL) ? Integer.MAX_VALUE : Integer.parseInt(amountThenType[0]);
            UnitType type = data.getUnitTypeList().getUnitType(amountThenType[1]);
            map.add(new Tuple<Integer, UnitType>(amount, type));
        }
        Collections.reverse(map);
        HashSet<Unit> unitsLeft = new HashSet<Unit>(units);
        ArrayList<Unit> order = new ArrayList<Unit>();
        for (Tuple tuple : map) {
            List<Unit> unitsOfType = Match.getNMatches(unitsLeft, (Integer)tuple.getFirst(), Matches.unitIsOfType((UnitType)tuple.getSecond()));
            order.addAll(unitsOfType);
            unitsLeft.removeAll(unitsOfType);
        }
        Collections.reverse(order);
        return order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOddsCalculatorListener(OddsCalculatorListener listener) {
        List<OddsCalculatorListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOddsCalculatorListener(OddsCalculatorListener listener) {
        List<OddsCalculatorListener> list = this.m_listeners;
        synchronized (list) {
            this.m_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersGameDataIsSet() {
        List<OddsCalculatorListener> list = this.m_listeners;
        synchronized (list) {
            for (OddsCalculatorListener listener : this.m_listeners) {
                listener.dataReady();
            }
        }
    }
}

