/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.oddsCalculator.ta.OddsCalculatorPanel;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.ui.TripleAFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class OddsCalculatorDialog
extends JDialog {
    private static final long serialVersionUID = -7625420355087851930L;
    private static final int MAX_HEIGHT = 640;
    private static Point lastPosition;
    private static Dimension lastShape;
    private final OddsCalculatorPanel panel;

    public static void show(final TripleAFrame taFrame, Territory t) {
        final OddsCalculatorDialog dialog = new OddsCalculatorDialog(taFrame.getGame().getData(), taFrame.getUIContext(), taFrame, t);
        dialog.pack();
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (taFrame != null && taFrame.getUIContext() != null && !taFrame.getUIContext().isShutDown()) {
                    taFrame.getUIContext().removeShutdownWindow(dialog);
                }
            }
        });
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        AbstractAction closeAction = new AbstractAction(){
            private static final long serialVersionUID = 8426179963957717432L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        };
        String key = "odds.calc.invoke.close";
        dialog.getRootPane().getActionMap().put("odds.calc.invoke.close", closeAction);
        dialog.getRootPane().getInputMap(2).put(stroke, "odds.calc.invoke.close");
        dialog.setDefaultCloseOperation(2);
        if (lastPosition == null) {
            dialog.setLocationRelativeTo(taFrame);
            if (dialog.getHeight() > 640) {
                dialog.setSize(new Dimension(dialog.getWidth(), 640));
            }
        } else {
            dialog.setLocation(lastPosition);
            dialog.setSize(lastShape);
        }
        dialog.setVisible(true);
        taFrame.getUIContext().addShutdownWindow(dialog);
    }

    OddsCalculatorDialog(GameData data, IUIContext context, JFrame parent, Territory location) {
        super((Frame)parent, "Odds Calculator");
        this.panel = new OddsCalculatorPanel(data, context, location, this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panel, "Center");
        this.pack();
    }

    @Override
    public void dispose() {
        lastPosition = new Point(this.getLocation());
        lastShape = new Dimension(this.getSize());
        this.panel.shutdown();
        super.dispose();
    }

    @Override
    public void show() {
        super.show();
        this.panel.selectCalculateButton();
    }
}

