/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.oddsCalculator.ta;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.framework.ui.background.WaitDialog;
import games.strategy.triplea.Properties;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TerritoryEffectHelper;
import games.strategy.triplea.delegate.UnitBattleComparator;
import games.strategy.triplea.oddsCalculator.ta.AggregateResults;
import games.strategy.triplea.oddsCalculator.ta.ConcurrentOddsCalculator;
import games.strategy.triplea.oddsCalculator.ta.IOddsCalculator;
import games.strategy.triplea.oddsCalculator.ta.OddsCalculator;
import games.strategy.triplea.oddsCalculator.ta.OddsCalculatorListener;
import games.strategy.triplea.oddsCalculator.ta.OrderOfLossesInputPanel;
import games.strategy.triplea.oddsCalculator.ta.PlayerUnitsPanel;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.ui.IntTextField;
import games.strategy.ui.WidgetChangedListener;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OddsCalculatorPanel
extends JPanel {
    private static final long serialVersionUID = -3559687618320469183L;
    private static final String NO_EFFECTS = "*None*";
    private final Window m_parent;
    private final JLabel m_attackerWin = new JLabel();
    private final JLabel m_defenderWin = new JLabel();
    private final JLabel m_draw = new JLabel();
    private final JLabel m_defenderLeft = new JLabel();
    private final JLabel m_attackerLeft = new JLabel();
    private final JLabel m_defenderLeftWhenDefenderWon = new JLabel();
    private final JLabel m_attackerLeftWhenAttackerWon = new JLabel();
    private final JLabel m_averageChangeInTUV = new JLabel();
    private final JLabel m_roundsAverage = new JLabel();
    private final JLabel m_count = new JLabel();
    private final JLabel m_time = new JLabel();
    private final IntTextField m_numRuns = new IntTextField();
    private final IntTextField m_retreatAfterXRounds = new IntTextField();
    private final IntTextField m_retreatAfterXUnitsLeft = new IntTextField();
    private final JPanel m_resultsPanel = new JPanel();
    private final JButton m_calculateButton = new JButton("Pls Wait, Copying Data...");
    private final JButton m_clearButton = new JButton("Clear");
    private final JButton m_closeButton = new JButton("Close");
    private final JButton m_SwapSidesButton = new JButton("Swap Sides");
    private final JButton m_orderOfLossesButton = new JButton("Order Of Losses");
    private final JCheckBox m_keepOneAttackingLandUnitCheckBox = new JCheckBox("One attacking land must live");
    private final JCheckBox m_amphibiousCheckBox = new JCheckBox("Battle is Amphibious");
    private final JCheckBox m_landBattleCheckBox = new JCheckBox("Land Battle");
    private final JCheckBox m_retreatWhenOnlyAirLeftCheckBox = new JCheckBox("Retreat when only air left");
    private final JCheckBox m_retreatWhenMetaPowerIsLower = new JCheckBox("Retreat when meta-power is lower");
    private final IUIContext m_context;
    private final GameData m_data;
    private final IOddsCalculator m_calculator;
    private PlayerUnitsPanel m_attackingUnitsPanel;
    private PlayerUnitsPanel m_defendingUnitsPanel;
    private JComboBox m_attackerCombo;
    private JComboBox m_defenderCombo;
    private JComboBox m_SwapSidesCombo;
    private final JLabel m_attackerUnitsTotalNumber = new JLabel();
    private final JLabel m_defenderUnitsTotalNumber = new JLabel();
    private final JLabel m_attackerUnitsTotalTUV = new JLabel();
    private final JLabel m_defenderUnitsTotalTUV = new JLabel();
    private final JLabel m_attackerUnitsTotalHitpoints = new JLabel();
    private final JLabel m_defenderUnitsTotalHitpoints = new JLabel();
    private final JLabel m_attackerUnitsTotalPower = new JLabel();
    private final JLabel m_defenderUnitsTotalPower = new JLabel();
    private String m_attackerOrderOfLosses = null;
    private String m_defenderOrderOfLosses = null;
    private Territory m_location = null;
    private JList m_territoryEffectsJList;
    private final WidgetChangedListener m_listenerPlayerUnitsPanel = new WidgetChangedListener(){

        @Override
        public void widgetChanged() {
            OddsCalculatorPanel.this.setWidgetActivation();
        }
    };
    private final OddsCalculatorListener m_listenerOddsCalculator = new OddsCalculatorListener(){

        @Override
        public void dataReady() {
            OddsCalculatorPanel.this.m_calculateButton.setText("Calculate Odds");
            OddsCalculatorPanel.this.m_calculateButton.setEnabled(true);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OddsCalculatorPanel(GameData data, IUIContext context, Territory location, Window parent) {
        this.m_data = data;
        this.m_context = context;
        this.m_location = location;
        this.m_parent = parent;
        this.m_calculateButton.setEnabled(false);
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        if (location != null) {
            this.m_data.acquireReadLock();
            try {
                this.m_landBattleCheckBox.setSelected(!location.isWater());
                if (this.m_data.getSequence().getStep().getPlayerID() != null && !this.m_data.getSequence().getStep().getPlayerID().isNull()) {
                    this.m_attackerCombo.setSelectedItem(this.m_data.getSequence().getStep().getPlayerID());
                }
                if (!location.isWater()) {
                    this.m_defenderCombo.setSelectedItem(location.getOwner());
                } else {
                    for (PlayerID player : location.getUnits().getPlayersWithUnits()) {
                        if (player == this.getAttacker() || this.m_data.getRelationshipTracker().isAllied(player, this.getAttacker())) continue;
                        this.m_defenderCombo.setSelectedItem(player);
                        break;
                    }
                }
                this.updateDefender(location.getUnits().getMatches(Matches.alliedUnit(this.getDefender(), data)));
                this.updateAttacker(location.getUnits().getMatches(Matches.alliedUnit(this.getAttacker(), data)));
            }
            finally {
                this.m_data.releaseReadLock();
            }
        } else {
            this.m_landBattleCheckBox.setSelected(true);
            this.m_defenderCombo.setSelectedItem(data.getPlayerList().getPlayers().iterator().next());
            this.updateDefender(null);
            this.updateAttacker(null);
        }
        if (OddsCalculatorPanel.percentageOfFreeMemoryAvailable() < 0.4) {
            System.gc();
            System.runFinalization();
            System.gc();
        }
        this.m_calculator = new ConcurrentOddsCalculator("BtlCalc Panel");
        this.m_calculator.addOddsCalculatorListener(this.m_listenerOddsCalculator);
        this.m_calculator.setGameData(this.m_data);
        this.setWidgetActivation();
        this.revalidate();
    }

    public void shutdown() {
        try {
            this.m_calculator.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    public static double percentageOfFreeMemoryAvailable() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long memoryAvailable = Math.min(maxMemory, maxMemory - (runtime.totalMemory() - runtime.freeMemory()));
        return (double)memoryAvailable / (double)maxMemory;
    }

    public static long freeMemoryAvailable() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        return Math.min(maxMemory, maxMemory - (runtime.totalMemory() - runtime.freeMemory()));
    }

    private PlayerID getDefender() {
        return (PlayerID)this.m_defenderCombo.getSelectedItem();
    }

    private PlayerID getAttacker() {
        return (PlayerID)this.m_attackerCombo.getSelectedItem();
    }

    private PlayerID getSwapSides() {
        return (PlayerID)this.m_SwapSidesCombo.getSelectedItem();
    }

    private void setupListeners() {
        this.m_defenderCombo.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                OddsCalculatorPanel.this.m_data.acquireReadLock();
                try {
                    if (OddsCalculatorPanel.this.m_data.getRelationshipTracker().isAllied(OddsCalculatorPanel.this.getDefender(), OddsCalculatorPanel.this.getAttacker())) {
                        OddsCalculatorPanel.this.m_attackerCombo.setSelectedItem(OddsCalculatorPanel.this.getEnemy(OddsCalculatorPanel.this.getDefender()));
                    }
                }
                finally {
                    OddsCalculatorPanel.this.m_data.releaseReadLock();
                }
                OddsCalculatorPanel.this.updateDefender(null);
                OddsCalculatorPanel.this.setWidgetActivation();
            }
        });
        this.m_attackerCombo.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                OddsCalculatorPanel.this.m_data.acquireReadLock();
                try {
                    if (OddsCalculatorPanel.this.m_data.getRelationshipTracker().isAllied(OddsCalculatorPanel.this.getDefender(), OddsCalculatorPanel.this.getAttacker())) {
                        OddsCalculatorPanel.this.m_defenderCombo.setSelectedItem(OddsCalculatorPanel.this.getEnemy(OddsCalculatorPanel.this.getAttacker()));
                    }
                }
                finally {
                    OddsCalculatorPanel.this.m_data.releaseReadLock();
                }
                OddsCalculatorPanel.this.updateAttacker(null);
                OddsCalculatorPanel.this.setWidgetActivation();
            }
        });
        this.m_amphibiousCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OddsCalculatorPanel.this.setWidgetActivation();
            }
        });
        this.m_landBattleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OddsCalculatorPanel.this.m_attackerOrderOfLosses = null;
                OddsCalculatorPanel.this.m_defenderOrderOfLosses = null;
                OddsCalculatorPanel.this.updateDefender(null);
                OddsCalculatorPanel.this.updateAttacker(null);
                OddsCalculatorPanel.this.setWidgetActivation();
            }
        });
        this.m_calculateButton.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                String memoryAvailable = "<br/>Percentage of memory available: " + String.format("%.2f", OddsCalculatorPanel.percentageOfFreeMemoryAvailable() * 100.0) + "% <br/>Free memory available: " + OddsCalculatorPanel.freeMemoryAvailable() / 0x100000L + "MB <br/>Maximum allowed memory: " + Runtime.getRuntime().maxMemory() / 0x100000L + "MB </html>";
                if (OddsCalculatorPanel.this.m_calculateButton.isEnabled()) {
                    OddsCalculatorPanel.this.m_calculateButton.setToolTipText("<html>Data copying finished. " + memoryAvailable);
                } else {
                    OddsCalculatorPanel.this.m_calculateButton.setToolTipText("<html>If this is taking forever to enable, it means <br/>you do not have enough memory to copy the data quickly! <br/>Consider increasing the max memory for TripleA. " + memoryAvailable);
                }
            }
        });
        this.m_calculateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OddsCalculatorPanel.this.updateStats();
            }
        });
        this.m_closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OddsCalculatorPanel.this.m_attackerOrderOfLosses = null;
                OddsCalculatorPanel.this.m_defenderOrderOfLosses = null;
                OddsCalculatorPanel.this.m_parent.setVisible(false);
                OddsCalculatorPanel.this.shutdown();
                OddsCalculatorPanel.this.m_parent.dispatchEvent(new WindowEvent(OddsCalculatorPanel.this.m_parent, 201));
            }
        });
        this.m_clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OddsCalculatorPanel.this.m_defendingUnitsPanel.clear();
                OddsCalculatorPanel.this.m_attackingUnitsPanel.clear();
                OddsCalculatorPanel.this.setWidgetActivation();
            }
        });
        this.m_SwapSidesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OddsCalculatorPanel.this.m_attackerOrderOfLosses = null;
                OddsCalculatorPanel.this.m_defenderOrderOfLosses = null;
                ArrayList<Unit> getdefenders = new ArrayList();
                ArrayList<Unit> getattackers = new ArrayList();
                getdefenders = OddsCalculatorPanel.this.m_defendingUnitsPanel.getUnits();
                getattackers = OddsCalculatorPanel.this.m_attackingUnitsPanel.getUnits();
                OddsCalculatorPanel.this.m_SwapSidesCombo.setSelectedItem(OddsCalculatorPanel.this.getAttacker());
                OddsCalculatorPanel.this.m_attackerCombo.setSelectedItem(OddsCalculatorPanel.this.getDefender());
                OddsCalculatorPanel.this.m_defenderCombo.setSelectedItem(OddsCalculatorPanel.this.getSwapSides());
                OddsCalculatorPanel.this.m_attackingUnitsPanel.init(OddsCalculatorPanel.this.getAttacker(), getdefenders, OddsCalculatorPanel.this.isLand());
                OddsCalculatorPanel.this.m_defendingUnitsPanel.init(OddsCalculatorPanel.this.getDefender(), getattackers, OddsCalculatorPanel.this.isLand());
                OddsCalculatorPanel.this.setWidgetActivation();
            }
        });
        this.m_orderOfLossesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderOfLossesInputPanel oolPanel = new OrderOfLossesInputPanel(OddsCalculatorPanel.this.m_attackerOrderOfLosses, OddsCalculatorPanel.this.m_defenderOrderOfLosses, OddsCalculatorPanel.this.m_attackingUnitsPanel.getCategories(), OddsCalculatorPanel.this.m_defendingUnitsPanel.getCategories(), OddsCalculatorPanel.this.m_landBattleCheckBox.isSelected(), OddsCalculatorPanel.this.m_context, OddsCalculatorPanel.this.m_data);
                if (0 == JOptionPane.showConfirmDialog(OddsCalculatorPanel.this, oolPanel, "Create Order Of Losses for each side", 2, -1)) {
                    if (OddsCalculator.isValidOOL(oolPanel.getAttackerOrder(), OddsCalculatorPanel.this.m_data)) {
                        OddsCalculatorPanel.this.m_attackerOrderOfLosses = oolPanel.getAttackerOrder();
                    }
                    if (OddsCalculator.isValidOOL(oolPanel.getDefenderOrder(), OddsCalculatorPanel.this.m_data)) {
                        OddsCalculatorPanel.this.m_defenderOrderOfLosses = oolPanel.getDefenderOrder();
                    }
                }
            }
        });
        if (this.m_territoryEffectsJList != null) {
            this.m_territoryEffectsJList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    OddsCalculatorPanel.this.setWidgetActivation();
                }
            });
        }
        this.m_attackingUnitsPanel.addChangeListener(this.m_listenerPlayerUnitsPanel);
        this.m_defendingUnitsPanel.addChangeListener(this.m_listenerPlayerUnitsPanel);
    }

    private boolean isAmphibiousBattle() {
        return this.m_landBattleCheckBox.isSelected() && this.m_amphibiousCheckBox.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<TerritoryEffect> getTerritoryEffects() {
        ArrayList<TerritoryEffect> territoryEffects = new ArrayList<TerritoryEffect>();
        if (this.m_territoryEffectsJList != null) {
            List<Object> selectedObjects = Arrays.asList(this.m_territoryEffectsJList.getSelectedValues());
            ArrayList<String> selected = new ArrayList<String>();
            for (Object obj : selectedObjects) {
                selected.add((String)obj);
            }
            this.m_data.acquireReadLock();
            try {
                Hashtable<String, TerritoryEffect> allTerritoryEffects = this.m_data.getTerritoryEffectList();
                for (String selection : selected) {
                    if (selection.equals(NO_EFFECTS)) {
                        territoryEffects.clear();
                        break;
                    }
                    territoryEffects.add(allTerritoryEffects.get(selection));
                }
            }
            finally {
                this.m_data.releaseReadLock();
            }
        }
        return territoryEffects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStats() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Wrong thread");
        }
        final AtomicReference results = new AtomicReference();
        final WaitDialog dialog = new WaitDialog(this, "Calculating Odds (" + this.m_calculator.getThreadCount() + " threads)", new AbstractAction(){
            private static final long serialVersionUID = -2148507015083214974L;

            @Override
            public void actionPerformed(ActionEvent e) {
                OddsCalculatorPanel.this.m_calculator.cancel();
            }
        });
        final AtomicReference defenders = new AtomicReference();
        final AtomicReference attackers = new AtomicReference();
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        Thread calcThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Territory location = null;
                    if (OddsCalculatorPanel.this.m_location == null || OddsCalculatorPanel.this.m_location.isWater() == OddsCalculatorPanel.this.isLand()) {
                        for (Territory t : OddsCalculatorPanel.this.m_data.getMap()) {
                            if (t.isWater() != !OddsCalculatorPanel.this.isLand()) continue;
                            location = t;
                            break;
                        }
                    } else {
                        location = OddsCalculatorPanel.this.m_location;
                    }
                    if (location == null) {
                        throw new IllegalStateException("No territory found that is land:" + OddsCalculatorPanel.this.isLand());
                    }
                    List<Unit> defending = OddsCalculatorPanel.this.m_defendingUnitsPanel.getUnits();
                    List<Unit> attacking = OddsCalculatorPanel.this.m_attackingUnitsPanel.getUnits();
                    ArrayList<Unit> bombarding = new ArrayList();
                    if (OddsCalculatorPanel.this.isLand()) {
                        bombarding = Match.getMatches(attacking, Matches.unitCanBombard(OddsCalculatorPanel.this.getAttacker()));
                        attacking.removeAll(bombarding);
                    }
                    OddsCalculatorPanel.this.m_calculator.setRetreatAfterRound(OddsCalculatorPanel.this.m_retreatAfterXRounds.getValue());
                    OddsCalculatorPanel.this.m_calculator.setRetreatAfterXUnitsLeft(OddsCalculatorPanel.this.m_retreatAfterXUnitsLeft.getValue());
                    if (OddsCalculatorPanel.this.m_retreatWhenOnlyAirLeftCheckBox.isSelected()) {
                        OddsCalculatorPanel.this.m_calculator.setRetreatWhenOnlyAirLeft(true);
                    } else {
                        OddsCalculatorPanel.this.m_calculator.setRetreatWhenOnlyAirLeft(false);
                    }
                    if (OddsCalculatorPanel.this.m_landBattleCheckBox.isSelected() && OddsCalculatorPanel.this.m_keepOneAttackingLandUnitCheckBox.isSelected()) {
                        OddsCalculatorPanel.this.m_calculator.setKeepOneAttackingLandUnit(true);
                    } else {
                        OddsCalculatorPanel.this.m_calculator.setKeepOneAttackingLandUnit(false);
                    }
                    if (OddsCalculatorPanel.this.isAmphibiousBattle()) {
                        OddsCalculatorPanel.this.m_calculator.setAmphibious(true);
                    } else {
                        OddsCalculatorPanel.this.m_calculator.setAmphibious(false);
                    }
                    if (OddsCalculatorPanel.this.m_retreatWhenMetaPowerIsLower.isSelected()) {
                        OddsCalculatorPanel.this.m_calculator.setRetreatWhenMetaPowerIsLower(true);
                    } else {
                        OddsCalculatorPanel.this.m_calculator.setRetreatWhenMetaPowerIsLower(false);
                    }
                    OddsCalculatorPanel.this.m_calculator.setAttackerOrderOfLosses(OddsCalculatorPanel.this.m_attackerOrderOfLosses);
                    OddsCalculatorPanel.this.m_calculator.setDefenderOrderOfLosses(OddsCalculatorPanel.this.m_defenderOrderOfLosses);
                    Collection territoryEffects = OddsCalculatorPanel.this.getTerritoryEffects();
                    defenders.set(defending);
                    attackers.set(attacking);
                    results.set(OddsCalculatorPanel.this.m_calculator.setCalculateDataAndCalculate(OddsCalculatorPanel.this.getAttacker(), OddsCalculatorPanel.this.getDefender(), location, attacking, defending, bombarding, territoryEffects, OddsCalculatorPanel.this.m_numRuns.getValue()));
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            dialog.setVisible(false);
                            dialog.dispose();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }, "Odds calc thread");
        calcThread.start();
        dialog.setVisible(true);
        if (results == null || results.get() == null) {
            this.setResultsToBlank();
        } else {
            this.m_attackerWin.setText(this.formatPercentage(((AggregateResults)results.get()).getAttackerWinPercent()));
            this.m_defenderWin.setText(this.formatPercentage(((AggregateResults)results.get()).getDefenderWinPercent()));
            this.m_draw.setText(this.formatPercentage(((AggregateResults)results.get()).getDrawPercent()));
            boolean isLand = this.isLand();
            List<Unit> mainCombatAttackers = Match.getMatches((Collection)attackers.get(), Matches.UnitCanBeInBattle(true, isLand, this.m_data, 1, false, true, true));
            List<Unit> mainCombatDefenders = Match.getMatches((Collection)defenders.get(), Matches.UnitCanBeInBattle(false, isLand, this.m_data, 1, false, true, true));
            int attackersTotal = mainCombatAttackers.size();
            int defendersTotal = mainCombatDefenders.size();
            this.m_defenderLeft.setText(this.formatValue(((AggregateResults)results.get()).getAverageDefendingUnitsLeft()) + " /" + defendersTotal);
            this.m_attackerLeft.setText(this.formatValue(((AggregateResults)results.get()).getAverageAttackingUnitsLeft()) + " /" + attackersTotal);
            this.m_defenderLeftWhenDefenderWon.setText(this.formatValue(((AggregateResults)results.get()).getAverageDefendingUnitsLeftWhenDefenderWon()) + " /" + defendersTotal);
            this.m_attackerLeftWhenAttackerWon.setText(this.formatValue(((AggregateResults)results.get()).getAverageAttackingUnitsLeftWhenAttackerWon()) + " /" + attackersTotal);
            this.m_roundsAverage.setText("" + this.formatValue(((AggregateResults)results.get()).getAverageBattleRoundsFought()));
            try {
                this.m_data.acquireReadLock();
                this.m_averageChangeInTUV.setText("" + this.formatValue(((AggregateResults)results.get()).getAverageTUVswing(this.getAttacker(), mainCombatAttackers, this.getDefender(), mainCombatDefenders, this.m_data)));
            }
            finally {
                this.m_data.releaseReadLock();
            }
            this.m_count.setText(((AggregateResults)results.get()).getRollCount() + "");
            this.m_time.setText(this.formatValue((double)((AggregateResults)results.get()).getTime() / 1000.0) + "s");
        }
    }

    public String formatPercentage(double percentage) {
        DecimalFormat format = new DecimalFormat("%");
        return format.format(percentage);
    }

    public String formatValue(double value) {
        DecimalFormat format = new DecimalFormat("#0.##");
        return format.format(value);
    }

    private void updateDefender(List<Unit> units) {
        if (units == null) {
            units = Collections.emptyList();
        }
        boolean isLand = this.isLand();
        units = Match.getMatches(units, Matches.UnitCanBeInBattle(false, isLand, this.m_data, 1, false, false, false));
        this.m_defendingUnitsPanel.init(this.getDefender(), units, isLand);
    }

    private void updateAttacker(List<Unit> units) {
        if (units == null) {
            units = Collections.emptyList();
        }
        boolean isLand = this.isLand();
        units = Match.getMatches(units, Matches.UnitCanBeInBattle(true, isLand, this.m_data, 1, false, false, false));
        this.m_attackingUnitsPanel.init(this.getAttacker(), units, isLand);
    }

    private boolean isLand() {
        return this.m_landBattleCheckBox.isSelected();
    }

    private PlayerID getEnemy(PlayerID player) {
        for (PlayerID id : this.m_data.getPlayerList()) {
            if (!this.m_data.getRelationshipTracker().isAtWar(player, id)) continue;
            return id;
        }
        for (PlayerID id : this.m_data.getPlayerList()) {
            if (this.m_data.getRelationshipTracker().isAllied(player, id)) continue;
            return id;
        }
        throw new IllegalStateException("No enemies or non-allies for :" + player);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        JPanel main = new JPanel();
        main.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.add((Component)main, "Center");
        main.setLayout(new BorderLayout());
        JPanel attackAndDefend = new JPanel();
        attackAndDefend.setLayout(new GridBagLayout());
        int gap = 20;
        int row0 = 0;
        attackAndDefend.add((Component)new JLabel("Attacker: "), new GridBagConstraints(0, row0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 20, 0), 0, 0));
        attackAndDefend.add((Component)this.m_attackerCombo, new GridBagConstraints(1, row0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 20), 0, 0));
        attackAndDefend.add((Component)new JLabel("Defender: "), new GridBagConstraints(2, row0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 20, 0), 0, 0));
        attackAndDefend.add((Component)this.m_defenderCombo, new GridBagConstraints(3, row0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 10, 20), 0, 0));
        attackAndDefend.add((Component)this.m_attackerUnitsTotalNumber, new GridBagConstraints(0, ++row0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 0, 0), 0, 0));
        attackAndDefend.add((Component)this.m_attackerUnitsTotalTUV, new GridBagConstraints(1, row0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 40), 0, 0));
        attackAndDefend.add((Component)this.m_defenderUnitsTotalNumber, new GridBagConstraints(2, row0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 0, 0), 0, 0));
        attackAndDefend.add((Component)this.m_defenderUnitsTotalTUV, new GridBagConstraints(3, row0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 40), 0, 0));
        attackAndDefend.add((Component)this.m_attackerUnitsTotalHitpoints, new GridBagConstraints(0, ++row0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 10, 0), 0, 0));
        attackAndDefend.add((Component)this.m_attackerUnitsTotalPower, new GridBagConstraints(1, row0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 10, 40), 0, 0));
        attackAndDefend.add((Component)this.m_defenderUnitsTotalHitpoints, new GridBagConstraints(2, row0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 20, 10, 0), 0, 0));
        attackAndDefend.add((Component)this.m_defenderUnitsTotalPower, new GridBagConstraints(3, row0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 10, 40), 0, 0));
        ++row0;
        JScrollPane attackerScroll = new JScrollPane(this.m_attackingUnitsPanel);
        attackerScroll.setBorder(null);
        attackerScroll.getViewport().setBorder(null);
        JScrollPane defenderScroll = new JScrollPane(this.m_defendingUnitsPanel);
        defenderScroll.setBorder(null);
        defenderScroll.getViewport().setBorder(null);
        attackAndDefend.add((Component)attackerScroll, new GridBagConstraints(0, row0, 2, 1, 1.0, 1.0, 11, 1, new Insets(10, 20, 20, 20), 0, 0));
        attackAndDefend.add((Component)defenderScroll, new GridBagConstraints(2, row0, 2, 1, 1.0, 1.0, 11, 1, new Insets(10, 20, 20, 20), 0, 0));
        main.add((Component)attackAndDefend, "Center");
        JPanel resultsText = new JPanel();
        resultsText.setLayout(new GridBagLayout());
        int row1 = 0;
        resultsText.add((Component)new JLabel("Attacker Wins:"), new GridBagConstraints(0, row1++, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Draw:"), new GridBagConstraints(0, row1++, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Defender Wins:"), new GridBagConstraints(0, row1++, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Ave. Defender Units Left:"), new GridBagConstraints(0, row1++, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Units Left If Def Won:"), new GridBagConstraints(0, row1++, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Ave. Attacker Units Left:"), new GridBagConstraints(0, row1++, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Units Left If Att Won:"), new GridBagConstraints(0, row1++, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Average TUV Swing:"), new GridBagConstraints(0, row1++, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Average Rounds:"), new GridBagConstraints(0, row1++, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Simulation Count:"), new GridBagConstraints(0, row1++, 1, 1, 0.0, 0.0, 13, 0, new Insets(15, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Time:"), new GridBagConstraints(0, row1++, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        resultsText.add((Component)this.m_calculateButton, new GridBagConstraints(0, row1++, 2, 1, 0.0, 0.0, 17, 1, new Insets(20, 60, 0, 100), 0, 0));
        resultsText.add((Component)this.m_clearButton, new GridBagConstraints(0, row1++, 1, 1, 0.0, 0.0, 17, 1, new Insets(6, 60, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Run Count:"), new GridBagConstraints(0, row1++, 1, 1, 0.0, 0.0, 13, 0, new Insets(20, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Retreat After Round:"), new GridBagConstraints(0, row1++, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
        resultsText.add((Component)new JLabel("Retreat When X Units Left:"), new GridBagConstraints(0, row1++, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
        int row2 = 0;
        resultsText.add((Component)this.m_attackerWin, new GridBagConstraints(1, row2++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        resultsText.add((Component)this.m_draw, new GridBagConstraints(1, row2++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        resultsText.add((Component)this.m_defenderWin, new GridBagConstraints(1, row2++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        resultsText.add((Component)this.m_defenderLeft, new GridBagConstraints(1, row2++, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 10, 0, 0), 0, 0));
        resultsText.add((Component)this.m_defenderLeftWhenDefenderWon, new GridBagConstraints(1, row2++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        resultsText.add((Component)this.m_attackerLeft, new GridBagConstraints(1, row2++, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 10, 0, 0), 0, 0));
        resultsText.add((Component)this.m_attackerLeftWhenAttackerWon, new GridBagConstraints(1, row2++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        resultsText.add((Component)this.m_averageChangeInTUV, new GridBagConstraints(1, row2++, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 10, 0, 0), 0, 0));
        resultsText.add((Component)this.m_roundsAverage, new GridBagConstraints(1, row2++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        resultsText.add((Component)this.m_count, new GridBagConstraints(1, row2++, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 10, 0, 0), 0, 0));
        resultsText.add((Component)this.m_time, new GridBagConstraints(1, row2++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        int n = ++row2;
        resultsText.add((Component)this.m_SwapSidesButton, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 1, new Insets(6, 10, 0, 100), 0, 0));
        int n2 = ++row2;
        resultsText.add((Component)this.m_numRuns, new GridBagConstraints(1, n2, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 10, 0, 0), 0, 0));
        int n3 = ++row2;
        resultsText.add((Component)this.m_retreatAfterXRounds, new GridBagConstraints(1, n3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        int n4 = ++row2;
        resultsText.add((Component)this.m_retreatAfterXUnitsLeft, new GridBagConstraints(1, n4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        row1 = ++row2;
        resultsText.add((Component)this.m_orderOfLossesButton, new GridBagConstraints(0, row1++, 1, 1, 0.0, 0.0, 13, 1, new Insets(10, 15, 0, 0), 0, 0));
        if (this.m_territoryEffectsJList != null) {
            resultsText.add((Component)new JScrollPane(this.m_territoryEffectsJList), new GridBagConstraints(0, row1, 1, this.m_territoryEffectsJList.getVisibleRowCount(), 0.0, 0.0, 13, 1, new Insets(10, 15, 0, 0), 0, 0));
            row1 += this.m_territoryEffectsJList.getVisibleRowCount();
        }
        resultsText.add((Component)this.m_retreatWhenOnlyAirLeftCheckBox, new GridBagConstraints(1, row2++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 5), 0, 0));
        resultsText.add((Component)this.m_retreatWhenMetaPowerIsLower, new GridBagConstraints(1, row2++, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 0, 5), 0, 0));
        resultsText.add((Component)this.m_keepOneAttackingLandUnitCheckBox, new GridBagConstraints(1, row2++, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 0, 5), 0, 0));
        resultsText.add((Component)this.m_amphibiousCheckBox, new GridBagConstraints(1, row2++, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 0, 5), 0, 0));
        resultsText.add((Component)this.m_landBattleCheckBox, new GridBagConstraints(1, row2++, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 10, 0, 5), 0, 0));
        this.m_resultsPanel.add(resultsText);
        this.m_resultsPanel.setBorder(BorderFactory.createEmptyBorder());
        JScrollPane resultsScroll = new JScrollPane(this.m_resultsPanel);
        resultsScroll.setBorder(BorderFactory.createEmptyBorder());
        Dimension resultsScrollDimensions = resultsScroll.getPreferredSize();
        resultsScrollDimensions.width += 22;
        resultsScroll.setPreferredSize(resultsScrollDimensions);
        main.add((Component)resultsScroll, "East");
        JPanel south = new JPanel();
        south.setLayout(new BorderLayout());
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(1));
        buttons.add(this.m_closeButton);
        south.add((Component)buttons, "South");
        this.add((Component)south, "South");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createComponents() {
        this.m_data.acquireReadLock();
        try {
            ArrayList<PlayerID> playerList = new ArrayList<PlayerID>(this.m_data.getPlayerList().getPlayers());
            if (OddsCalculatorPanel.doesPlayerHaveUnitsOnMap(PlayerID.NULL_PLAYERID, this.m_data)) {
                playerList.add(PlayerID.NULL_PLAYERID);
            }
            this.m_attackerCombo = new JComboBox<PlayerID>(new Vector<PlayerID>(playerList));
            this.m_defenderCombo = new JComboBox<PlayerID>(new Vector<PlayerID>(playerList));
            this.m_SwapSidesCombo = new JComboBox<PlayerID>(new Vector<PlayerID>(playerList));
            Hashtable<String, TerritoryEffect> allTerritoryEffects = this.m_data.getTerritoryEffectList();
            if (allTerritoryEffects == null || allTerritoryEffects.isEmpty()) {
                this.m_territoryEffectsJList = null;
            } else {
                Collection<TerritoryEffect> currentEffects;
                Vector<String> effectNames = new Vector<String>();
                effectNames.add(NO_EFFECTS);
                effectNames.addAll(allTerritoryEffects.keySet());
                this.m_territoryEffectsJList = new JList(effectNames);
                this.m_territoryEffectsJList.setSelectionMode(2);
                this.m_territoryEffectsJList.setLayoutOrientation(0);
                this.m_territoryEffectsJList.setVisibleRowCount(4);
                if (this.m_location != null && !(currentEffects = TerritoryEffectHelper.getEffects(this.m_location)).isEmpty()) {
                    int[] selectedIndexes = new int[currentEffects.size()];
                    int currentIndex = 0;
                    for (TerritoryEffect te : currentEffects) {
                        selectedIndexes[currentIndex] = effectNames.indexOf(te.getName());
                        ++currentIndex;
                    }
                    this.m_territoryEffectsJList.setSelectedIndices(selectedIndexes);
                }
            }
        }
        finally {
            this.m_data.releaseReadLock();
        }
        this.m_defenderCombo.setRenderer(new PlayerRenderer());
        this.m_attackerCombo.setRenderer(new PlayerRenderer());
        this.m_SwapSidesCombo.setRenderer(new PlayerRenderer());
        this.m_defendingUnitsPanel = new PlayerUnitsPanel(this.m_data, this.m_context, true);
        this.m_attackingUnitsPanel = new PlayerUnitsPanel(this.m_data, this.m_context, false);
        this.m_numRuns.setColumns(4);
        this.m_numRuns.setMin(1);
        this.m_numRuns.setMax(20000);
        this.m_numRuns.setValue(Properties.getLow_Luck(this.m_data) ? 500 : 2000);
        this.m_retreatAfterXRounds.setColumns(4);
        this.m_retreatAfterXRounds.setMin(-1);
        this.m_retreatAfterXRounds.setMax(1000);
        this.m_retreatAfterXRounds.setValue(-1);
        this.m_retreatAfterXRounds.setToolTipText("-1 means never.");
        this.m_retreatAfterXUnitsLeft.setColumns(4);
        this.m_retreatAfterXUnitsLeft.setMin(-1);
        this.m_retreatAfterXUnitsLeft.setMax(1000);
        this.m_retreatAfterXUnitsLeft.setValue(-1);
        this.m_retreatAfterXUnitsLeft.setToolTipText("-1 means never. If positive and 'retreat when only air left' is also selected, then we will retreat when X of non-air units is left.");
        this.setResultsToBlank();
        this.m_defenderLeft.setToolTipText("Units Left does not include AA guns and other infrastructure, and does not include Bombarding sea units for land battles.");
        this.m_attackerLeft.setToolTipText("Units Left does not include AA guns and other infrastructure, and does not include Bombarding sea units for land battles.");
        this.m_defenderLeftWhenDefenderWon.setToolTipText("Units Left does not include AA guns and other infrastructure, and does not include Bombarding sea units for land battles.");
        this.m_attackerLeftWhenAttackerWon.setToolTipText("Units Left does not include AA guns and other infrastructure, and does not include Bombarding sea units for land battles.");
        this.m_averageChangeInTUV.setToolTipText("TUV Swing does not include captured AA guns and other infrastructure, and does not include Bombarding sea units for land battles.");
        this.m_retreatWhenOnlyAirLeftCheckBox.setToolTipText("We retreat if only air is left, and if 'retreat when x units left' is positive we will retreat when x of non-air is left too.");
        this.m_retreatWhenMetaPowerIsLower.setToolTipText("We retreat if our 'meta power' is lower than the opponent. Meta Power is equal to:  Power  +  (2 * HitPoints * DiceSides / 6)");
        this.m_attackerUnitsTotalNumber.setToolTipText("Totals do not include AA guns and other infrastructure, and does not include Bombarding sea units for land battles.");
        this.m_defenderUnitsTotalNumber.setToolTipText("Totals do not include AA guns and other infrastructure, and does not include Bombarding sea units for land battles.");
    }

    private void setResultsToBlank() {
        String blank = "------";
        this.m_attackerWin.setText("------");
        this.m_defenderWin.setText("------");
        this.m_draw.setText("------");
        this.m_defenderLeft.setText("------");
        this.m_attackerLeft.setText("------");
        this.m_defenderLeftWhenDefenderWon.setText("------");
        this.m_attackerLeftWhenAttackerWon.setText("------");
        this.m_roundsAverage.setText("------");
        this.m_averageChangeInTUV.setText("------");
        this.m_count.setText("------");
        this.m_time.setText("------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWidgetActivation() {
        this.m_keepOneAttackingLandUnitCheckBox.setEnabled(this.m_landBattleCheckBox.isSelected());
        this.m_amphibiousCheckBox.setEnabled(this.m_landBattleCheckBox.isSelected());
        boolean isLand = this.isLand();
        try {
            this.m_data.acquireReadLock();
            ArrayList<Unit> attackers = Match.getMatches(this.m_attackingUnitsPanel.getUnits(), Matches.UnitCanBeInBattle(true, isLand, this.m_data, 1, false, true, true));
            List<Unit> defenders = Match.getMatches(this.m_defendingUnitsPanel.getUnits(), Matches.UnitCanBeInBattle(false, isLand, this.m_data, 1, false, true, true));
            this.m_attackerUnitsTotalNumber.setText("Units: " + attackers.size());
            this.m_defenderUnitsTotalNumber.setText("Units: " + defenders.size());
            this.m_attackerUnitsTotalTUV.setText("TUV: " + BattleCalculator.getTUV(attackers, this.getAttacker(), BattleCalculator.getCostsForTUV(this.getAttacker(), this.m_data), this.m_data));
            this.m_defenderUnitsTotalTUV.setText("TUV: " + BattleCalculator.getTUV(defenders, this.getDefender(), BattleCalculator.getCostsForTUV(this.getDefender(), this.m_data), this.m_data));
            int attackHP = BattleCalculator.getTotalHitpointsLeft(attackers);
            int defenseHP = BattleCalculator.getTotalHitpointsLeft(defenders);
            this.m_attackerUnitsTotalHitpoints.setText("HP: " + attackHP);
            this.m_defenderUnitsTotalHitpoints.setText("HP: " + defenseHP);
            boolean isAmphibiousBattle = this.isAmphibiousBattle();
            Collection<TerritoryEffect> territoryEffects = this.getTerritoryEffects();
            IntegerMap<UnitType> costs = BattleCalculator.getCostsForTUV(this.getAttacker(), this.m_data);
            Collections.sort(attackers, new UnitBattleComparator(false, costs, territoryEffects, this.m_data, false, false));
            Collections.reverse(attackers);
            int attackPower = DiceRoll.getTotalPowerAndRolls(DiceRoll.getUnitPowerAndRollsForNormalBattles((List<Unit>)attackers, (List<Unit>)attackers, defenders, false, false, this.getAttacker(), this.m_data, this.m_location, territoryEffects, isAmphibiousBattle, (Collection<Unit>)(isAmphibiousBattle ? attackers : new ArrayList<Unit>())), this.m_data).getFirst();
            int defensePower = DiceRoll.getTotalPowerAndRolls(DiceRoll.getUnitPowerAndRollsForNormalBattles(defenders, defenders, attackers, true, false, this.getDefender(), this.m_data, this.m_location, territoryEffects, isAmphibiousBattle, new ArrayList<Unit>()), this.m_data).getFirst();
            this.m_attackerUnitsTotalPower.setText("Power: " + attackPower);
            this.m_defenderUnitsTotalPower.setText("Power: " + defensePower);
            this.m_attackerUnitsTotalPower.setToolTipText("<html>Meta Power: " + BattleCalculator.getNormalizedMetaPower(attackPower, attackHP, this.m_data.getDiceSides()) + "<br /> (is equal to  (2 * Hitpoints) + (Power * 6 / DiceSides))</html>");
            this.m_defenderUnitsTotalPower.setToolTipText("<html>Meta Power: " + BattleCalculator.getNormalizedMetaPower(defensePower, defenseHP, this.m_data.getDiceSides()) + "<br /> (is equal to  (2 * Hitpoints) + (Power * 6 / DiceSides))</html>");
        }
        finally {
            this.m_data.releaseReadLock();
        }
    }

    public void selectCalculateButton() {
        this.m_calculateButton.requestFocus();
    }

    private static boolean doesPlayerHaveUnitsOnMap(PlayerID player, GameData data) {
        for (Territory t : data.getMap()) {
            for (Unit u : t.getUnits()) {
                if (!u.getOwner().equals(player)) continue;
                return true;
            }
        }
        return false;
    }

    class PlayerRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -7639128794342607309L;

        PlayerRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            PlayerID id = (PlayerID)value;
            this.setText(id.getName());
            this.setIcon(new ImageIcon(OddsCalculatorPanel.this.m_context.getFlagImageFactory().getSmallFlag(id)));
            return this;
        }
    }
}

