/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.printgenerator;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameStep;
import games.strategy.engine.data.PlayerID;
import games.strategy.triplea.printgenerator.PrintGenerationData;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class PlayerOrder {
    private Iterator<GameStep> m_gameStepIterator;
    private GameData m_data;
    private final List<PlayerID> m_playerSet = new ArrayList<PlayerID>();
    private PrintGenerationData m_printData;

    private <E> Set<E> removeDups(Collection<E> c) {
        return new LinkedHashSet<E>(c);
    }

    protected void saveToFile(PrintGenerationData printData) throws IOException {
        this.m_data = printData.getData();
        this.m_printData = printData;
        for (GameStep currentStep : this.m_data.getSequence()) {
            String delegateClassName;
            if (currentStep.getDelegate() == null || currentStep.getDelegate().getClass() == null ? currentStep.getName() != null && (currentStep.getName().endsWith("Bid") || currentStep.getName().endsWith("BidPlace")) : (delegateClassName = currentStep.getDelegate().getClass().getName()).equals("games.strategy.triplea.delegate.InitializationDelegate") || delegateClassName.equals("games.strategy.triplea.delegate.BidPurchaseDelegate") || delegateClassName.equals("games.strategy.triplea.delegate.BidPlaceDelegate") || delegateClassName.equals("games.strategy.triplea.delegate.EndRoundDelegate")) continue;
            PlayerID currentPlayerID = currentStep.getPlayerID();
            if (currentPlayerID == null || currentPlayerID.isNull()) continue;
            this.m_playerSet.add(currentPlayerID);
        }
        FileWriter turnWriter = null;
        this.m_printData.getOutDir().mkdir();
        File outFile = new File(this.m_printData.getOutDir(), "General Information.csv");
        turnWriter = new FileWriter(outFile, true);
        turnWriter.write("Turn Order\r\n");
        Set<PlayerID> noDuplicates = this.removeDups(this.m_playerSet);
        Iterator<PlayerID> playerIterator = noDuplicates.iterator();
        int count = 1;
        while (playerIterator.hasNext()) {
            PlayerID currentPlayerID = playerIterator.next();
            turnWriter.write(count + ". " + currentPlayerID.getName() + "\r\n");
            ++count;
        }
        turnWriter.close();
    }
}

