/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.Round;
import games.strategy.engine.pbem.ForumPosterComponent;
import games.strategy.engine.pbem.PBEMMessagePoster;
import games.strategy.triplea.delegate.GameStepPropertiesHelper;
import games.strategy.triplea.delegate.remote.IAbstractForumPosterDelegate;
import games.strategy.triplea.ui.ActionPanel;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.TripleAFrame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

public abstract class AbstractForumPosterPanel
extends ActionPanel {
    private static final long serialVersionUID = -5084680807785728744L;
    protected JLabel m_actionLabel = new JLabel();
    protected IPlayerBridge m_bridge;
    protected PBEMMessagePoster m_poster;
    protected TripleAFrame m_frame;
    protected Action m_doneAction = new AbstractAction("Done"){
        private static final long serialVersionUID = -3658752576117043053L;

        @Override
        public void actionPerformed(ActionEvent event) {
            AbstractForumPosterPanel.this.release();
        }
    };
    protected ForumPosterComponent m_forumPosterComponent = new ForumPosterComponent(this.getData(), this.m_doneAction, this.getTitle());

    public AbstractForumPosterPanel(GameData data, MapPanel map) {
        super(data, map);
    }

    private int getRound() {
        TreeNode[] pathFromRoot;
        int round = 0;
        for (TreeNode pathNode : pathFromRoot = this.getData().getHistory().getLastNode().getPath()) {
            HistoryNode curNode = (HistoryNode)pathNode;
            if (!(curNode instanceof Round)) continue;
            round = ((Round)curNode).getRoundNo();
            break;
        }
        return round;
    }

    @Override
    public void display(final PlayerID id) {
        super.display(id);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractForumPosterPanel.this.m_actionLabel.setText(id.getName() + " " + AbstractForumPosterPanel.this.getTitle());
            }
        });
    }

    protected abstract boolean allowIncludeTerritorySummary();

    protected abstract boolean allowIncludeTerritoryAllPlayersSummary();

    protected abstract boolean allowIncludeProductionSummary();

    protected abstract boolean allowDiceBattleDetails();

    protected abstract boolean allowDiceStatistics();

    protected abstract IAbstractForumPosterDelegate getForumPosterDelegate();

    protected abstract boolean postTurnSummary(PBEMMessagePoster var1, boolean var2);

    protected abstract boolean getHasPostedTurnSummary();

    protected abstract void setHasPostedTurnSummary(boolean var1);

    protected abstract boolean skipPosting();

    protected abstract String getTitle();

    @Override
    public abstract String toString();

    protected void waitForDone(TripleAFrame frame, IPlayerBridge bridge) {
        this.m_frame = frame;
        this.m_bridge = bridge;
        this.m_poster = new PBEMMessagePoster(this.getData(), this.getCurrentPlayer(), this.getRound(), this.getTitle());
        if (!this.m_poster.hasMessengers()) {
            return;
        }
        if (this.skipPosting() || GameStepPropertiesHelper.isSkipPosting(this.getData())) {
            return;
        }
        final boolean hasPosted = this.getHasPostedTurnSummary();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractForumPosterPanel.this.removeAll();
                AbstractForumPosterPanel.this.add(AbstractForumPosterPanel.this.m_actionLabel);
                AbstractForumPosterPanel.this.add(AbstractForumPosterPanel.this.m_forumPosterComponent.layoutComponents(AbstractForumPosterPanel.this.m_poster, AbstractForumPosterPanel.this.getForumPosterDelegate(), AbstractForumPosterPanel.this.m_bridge, AbstractForumPosterPanel.this.m_frame, hasPosted, AbstractForumPosterPanel.this.allowIncludeTerritorySummary(), AbstractForumPosterPanel.this.allowIncludeTerritoryAllPlayersSummary(), AbstractForumPosterPanel.this.allowIncludeProductionSummary(), AbstractForumPosterPanel.this.allowDiceBattleDetails(), AbstractForumPosterPanel.this.allowDiceStatistics()));
                AbstractForumPosterPanel.this.validate();
            }
        });
        this.waitForRelease();
    }
}

