/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Resource;
import games.strategy.engine.stats.AbstractStat;
import games.strategy.triplea.util.PlayerOrderComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JPanel;

public abstract class AbstractStatPanel
extends JPanel {
    private static final long serialVersionUID = 1906611524937548809L;
    protected GameData m_data;

    public AbstractStatPanel(GameData data) {
        this.m_data = data;
    }

    protected abstract void initLayout();

    public abstract void setGameData(GameData var1);

    public Collection<String> getAlliances() {
        TreeSet<String> rVal = new TreeSet<String>();
        for (String alliance : this.m_data.getAllianceTracker().getAlliances()) {
            if (this.m_data.getAllianceTracker().getPlayersInAlliance(alliance).size() <= 1) continue;
            rVal.add(alliance);
        }
        return rVal;
    }

    public List<PlayerID> getPlayers() {
        ArrayList<PlayerID> players = new ArrayList<PlayerID>(this.m_data.getPlayerList().getPlayers());
        Collections.sort(players, new PlayerOrderComparator(this.m_data));
        return players;
    }

    class ResourceStat
    extends AbstractStat {
        final Resource m_resource;

        public ResourceStat(Resource resource) {
            this.m_resource = resource;
        }

        @Override
        public String getName() {
            return this.m_resource.getName();
        }

        @Override
        public double getValue(PlayerID player, GameData data) {
            return player.getResources().getQuantity(this.m_resource);
        }
    }
}

