/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.LocalPlayers;
import games.strategy.triplea.ResourceLoader;
import games.strategy.triplea.ui.Active;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.util.CountDownLatchHandler;
import java.awt.BorderLayout;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class AbstractUIContext
implements IUIContext {
    protected static final String UNIT_SCALE_PREF = "UnitScale";
    protected static final String MAP_SKIN_PREF = "MapSkin";
    protected static final String MAP_SCALE_PREF = "MapScale";
    protected static final Logger s_logger = Logger.getLogger(AbstractUIContext.class.getName());
    protected static String m_mapDir;
    protected static final String LOCK_MAP = "LockMap";
    protected static final String SHOW_END_OF_TURN_REPORT = "ShowEndOfTurnReport";
    protected static final String SHOW_TRIGGERED_NOTIFICATIONS = "ShowTriggeredNotifications";
    protected static final String SHOW_TRIGGERED_CHANCE_SUCCESSFUL = "ShowTriggeredChanceSuccessful";
    protected static final String SHOW_TRIGGERED_CHANCE_FAILURE = "ShowTriggeredChanceFailure";
    protected static final String SHOW_BATTLES_BETWEEN_AIS = "ShowBattlesBetweenAIs";
    protected static final String AI_PAUSE_DURATION = "AIPauseDuration";
    protected static ResourceLoader m_resourceLoader;
    protected boolean m_isShutDown = false;
    protected final List<Window> m_windowsToCloseOnShutdown = new ArrayList<Window>();
    protected final List<Active> m_activeToDeactivate = new ArrayList<Active>();
    protected final CountDownLatchHandler m_latchesToCloseOnShutdown = new CountDownLatchHandler(false);
    protected LocalPlayers m_localPlayers;
    protected double m_scale = 1.0;

    public static ResourceLoader getResourceLoader() {
        return m_resourceLoader;
    }

    public static int getAIPauseDuration() {
        Preferences prefs = Preferences.userNodeForPackage(AbstractUIContext.class);
        return prefs.getInt(AI_PAUSE_DURATION, 400);
    }

    public static void setAIPauseDuration(int value) {
        Preferences prefs = Preferences.userNodeForPackage(AbstractUIContext.class);
        prefs.putInt(AI_PAUSE_DURATION, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public double getScale() {
        return this.m_scale;
    }

    @Override
    public void setScale(double scale) {
        this.m_scale = scale;
        Preferences prefs = AbstractUIContext.getPreferencesMapOrSkin(AbstractUIContext.getMapDir());
        prefs.putDouble(MAP_SCALE_PREF, scale);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    protected static Preferences getPreferencesForMap(String mapName) {
        return Preferences.userNodeForPackage(AbstractUIContext.class).node(mapName);
    }

    protected static Preferences getPreferencesMapOrSkin(String mapDir) {
        return Preferences.userNodeForPackage(AbstractUIContext.class).node(mapDir);
    }

    protected static String getDefaultMapDir(GameData data) {
        String mapName = (String)data.getProperties().get("mapName");
        if (mapName == null || mapName.trim().length() == 0) {
            throw new IllegalStateException("Map name property not set on game");
        }
        Preferences prefs = AbstractUIContext.getPreferencesForMap(mapName);
        String mapDir = prefs.get(MAP_SKIN_PREF, mapName);
        try {
            ResourceLoader.getMapResourceLoader(mapDir, false).close();
        }
        catch (RuntimeException re) {
            prefs.remove(MAP_SKIN_PREF);
            return mapName;
        }
        return mapDir;
    }

    @Override
    public void setDefaultMapDir(GameData data) {
        this.internalSetMapDir(AbstractUIContext.getDefaultMapDir(data), data);
    }

    @Override
    public void setMapDir(GameData data, String mapDir) {
        this.internalSetMapDir(mapDir, data);
        this.getMapData().verify(data);
        String mapName = (String)data.getProperties().get("mapName");
        Preferences prefs = AbstractUIContext.getPreferencesForMap(mapName);
        prefs.put(MAP_SKIN_PREF, mapDir);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    protected abstract void internalSetMapDir(String var1, GameData var2);

    public static String getMapDir() {
        return m_mapDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActive(Active actor) {
        if (this.m_isShutDown) {
            return;
        }
        AbstractUIContext abstractUIContext = this;
        synchronized (abstractUIContext) {
            this.m_activeToDeactivate.remove(actor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActive(Active actor) {
        if (this.m_isShutDown) {
            this.closeActor(actor);
            return;
        }
        AbstractUIContext abstractUIContext = this;
        synchronized (abstractUIContext) {
            if (this.m_isShutDown) {
                this.closeActor(actor);
                return;
            }
            this.m_activeToDeactivate.add(actor);
        }
    }

    @Override
    public void addShutdownLatch(CountDownLatch latch) {
        this.m_latchesToCloseOnShutdown.addShutdownLatch(latch);
    }

    @Override
    public void removeShutdownLatch(CountDownLatch latch) {
        this.m_latchesToCloseOnShutdown.removeShutdownLatch(latch);
    }

    @Override
    public CountDownLatchHandler getCountDownLatchHandler() {
        return this.m_latchesToCloseOnShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addShutdownWindow(Window window) {
        if (this.m_isShutDown) {
            AbstractUIContext.closeWindow(window);
            return;
        }
        AbstractUIContext abstractUIContext = this;
        synchronized (abstractUIContext) {
            if (this.m_isShutDown) {
                AbstractUIContext.closeWindow(window);
                return;
            }
            this.m_windowsToCloseOnShutdown.add(window);
        }
    }

    protected static void closeWindow(final Window window) {
        window.setVisible(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                window.dispose();
                if (window instanceof JFrame) {
                    JFrame frame = (JFrame)window;
                    JMenuBar menu = frame.getJMenuBar();
                    if (menu != null) {
                        while (menu.getMenuCount() > 0) {
                            menu.remove(0);
                        }
                    }
                    frame.setMenuBar(null);
                    frame.setJMenuBar(null);
                    frame.getRootPane().removeAll();
                    frame.getRootPane().setJMenuBar(null);
                    frame.getContentPane().removeAll();
                    frame.getContentPane().setLayout(new BorderLayout());
                    frame.setContentPane(new JPanel());
                    frame.setIconImage(null);
                    AbstractUIContext.clearInputMap(frame.getRootPane());
                }
            }
        });
    }

    protected static void clearInputMap(JComponent c) {
        c.getInputMap(2).clear();
        c.getInputMap(0).clear();
        c.getInputMap(1).clear();
        c.getActionMap().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeShutdownWindow(Window window) {
        if (this.m_isShutDown) {
            return;
        }
        AbstractUIContext abstractUIContext = this;
        synchronized (abstractUIContext) {
            this.m_windowsToCloseOnShutdown.remove(window);
        }
    }

    @Override
    public boolean isShutDown() {
        return this.m_isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDown() {
        AbstractUIContext abstractUIContext = this;
        synchronized (abstractUIContext) {
            if (this.m_isShutDown) {
                return;
            }
            this.m_isShutDown = true;
            this.m_latchesToCloseOnShutdown.shutDown();
            for (Window window : this.m_windowsToCloseOnShutdown) {
                AbstractUIContext.closeWindow(window);
            }
            for (Active actor : this.m_activeToDeactivate) {
                this.closeActor(actor);
            }
            this.m_activeToDeactivate.clear();
            this.m_windowsToCloseOnShutdown.clear();
        }
    }

    public static Map<String, String> getSkins(GameData data) {
        String mapName = data.getProperties().get("mapName").toString();
        LinkedHashMap<String, String> rVal = new LinkedHashMap<String, String>();
        rVal.put("Original", mapName);
        AbstractUIContext.getSkins(mapName, rVal, new File(GameRunner2.getRootFolder(), "maps"));
        AbstractUIContext.getSkins(mapName, rVal, GameRunner2.getUserMapsFolder());
        return rVal;
    }

    protected static void getSkins(String mapName, Map<String, String> rVal, File root) {
        File[] files = root.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (!f.isDirectory()) {
                if (!f.getName().endsWith(".zip") || !f.getName().startsWith(mapName + "-")) continue;
                String nameWithExtension = f.getName().substring(f.getName().indexOf(45) + 1);
                rVal.put(nameWithExtension.substring(0, nameWithExtension.length() - 4), f.getName().substring(0, f.getName().length() - 4));
                continue;
            }
            if (!f.getName().startsWith(mapName + "-")) continue;
            rVal.put(f.getName().substring(f.getName().indexOf(45) + 1), f.getName());
        }
    }

    protected void closeActor(Active actor) {
        try {
            actor.deactivate();
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
    }

    @Override
    public boolean getLockMap() {
        Preferences prefs = Preferences.userNodeForPackage(AbstractUIContext.class);
        return prefs.getBoolean(LOCK_MAP, false);
    }

    @Override
    public void setLockMap(boolean aBool) {
        Preferences prefs = Preferences.userNodeForPackage(AbstractUIContext.class);
        prefs.putBoolean(LOCK_MAP, aBool);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean getShowEndOfTurnReport() {
        Preferences prefs = Preferences.userNodeForPackage(AbstractUIContext.class);
        return prefs.getBoolean(SHOW_END_OF_TURN_REPORT, true);
    }

    @Override
    public void setShowEndOfTurnReport(boolean value) {
        Preferences prefs = Preferences.userNodeForPackage(AbstractUIContext.class);
        prefs.putBoolean(SHOW_END_OF_TURN_REPORT, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean getShowTriggeredNotifications() {
        Preferences prefs = Preferences.userNodeForPackage(AbstractUIContext.class);
        return prefs.getBoolean(SHOW_TRIGGERED_NOTIFICATIONS, true);
    }

    @Override
    public void setShowTriggeredNotifications(boolean value) {
        Preferences prefs = Preferences.userNodeForPackage(AbstractUIContext.class);
        prefs.putBoolean(SHOW_TRIGGERED_NOTIFICATIONS, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean getShowTriggerChanceSuccessful() {
        Preferences prefs = Preferences.userNodeForPackage(AbstractUIContext.class);
        return prefs.getBoolean(SHOW_TRIGGERED_CHANCE_SUCCESSFUL, true);
    }

    @Override
    public void setShowTriggerChanceSuccessful(boolean value) {
        Preferences prefs = Preferences.userNodeForPackage(AbstractUIContext.class);
        prefs.putBoolean(SHOW_TRIGGERED_CHANCE_SUCCESSFUL, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean getShowTriggerChanceFailure() {
        Preferences prefs = Preferences.userNodeForPackage(AbstractUIContext.class);
        return prefs.getBoolean(SHOW_TRIGGERED_CHANCE_FAILURE, true);
    }

    @Override
    public void setShowTriggerChanceFailure(boolean value) {
        Preferences prefs = Preferences.userNodeForPackage(AbstractUIContext.class);
        prefs.putBoolean(SHOW_TRIGGERED_CHANCE_FAILURE, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean getShowBattlesBetweenAIs() {
        Preferences prefs = Preferences.userNodeForPackage(AbstractUIContext.class);
        return prefs.getBoolean(SHOW_BATTLES_BETWEEN_AIS, true);
    }

    @Override
    public void setShowBattlesBetweenAIs(boolean aBool) {
        Preferences prefs = Preferences.userNodeForPackage(AbstractUIContext.class);
        prefs.putBoolean(SHOW_BATTLES_BETWEEN_AIS, aBool);
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public LocalPlayers getLocalPlayers() {
        return this.m_localPlayers;
    }

    @Override
    public void setLocalPlayers(LocalPlayers players) {
        this.m_localPlayers = players;
    }
}

