/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.triplea.delegate.AbstractUndoableMove;
import games.strategy.triplea.ui.AbstractMovePanel;
import games.strategy.triplea.ui.UndoablePlacementsPanel;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public abstract class AbstractUndoableMovesPanel
extends JPanel {
    private static final long serialVersionUID = 1910945925958952416L;
    protected List<AbstractUndoableMove> m_moves;
    protected final GameData m_data;
    protected final AbstractMovePanel m_movePanel;
    protected JScrollPane scroll;
    protected Integer scrollBarPreviousValue = null;
    protected Integer previousVisibleIndex = null;

    public AbstractUndoableMovesPanel(GameData data, AbstractMovePanel movePanel) {
        this.m_data = data;
        this.m_movePanel = movePanel;
        this.m_moves = Collections.emptyList();
    }

    public void setMoves(List moves) {
        this.m_moves = moves;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractUndoableMovesPanel.this.initLayout();
            }
        });
    }

    private void initLayout() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        final JPanel items = new JPanel();
        items.setLayout(new BoxLayout(items, 1));
        this.m_moves = new ArrayList<AbstractUndoableMove>(this.m_moves);
        Collections.reverse(this.m_moves);
        Iterator<AbstractUndoableMove> iter = this.m_moves.iterator();
        if (iter.hasNext()) {
            this.add((Component)new JLabel(this instanceof UndoablePlacementsPanel ? "Placements:" : "Moves:"), "North");
        }
        int scrollIncrement = 10;
        Dimension seperatorSize = new Dimension(150, 20);
        while (iter.hasNext()) {
            AbstractUndoableMove item = iter.next();
            JComponent moveComponent = this.createComponentForMove(item);
            scrollIncrement = moveComponent.getPreferredSize().height;
            items.add(moveComponent);
            if (!iter.hasNext()) continue;
            JSeparator seperator = new JSeparator(0);
            seperator.setPreferredSize(seperatorSize);
            seperator.setMaximumSize(seperatorSize);
            items.add(seperator);
        }
        if (this.m_movePanel.getUndoableMoves() != null && this.m_movePanel.getUndoableMoves().size() > 1) {
            JButton undoAllButton = new JButton("Undo All");
            undoAllButton.addActionListener(new UndoAllMovesActionListener());
            items.add(undoAllButton);
        }
        final int scrollIncrementFinal = scrollIncrement + seperatorSize.height;
        this.scroll = new JScrollPane(items){
            private static final long serialVersionUID = -1064967105431785533L;

            @Override
            public void paint(Graphics g) {
                if (AbstractUndoableMovesPanel.this.previousVisibleIndex != null) {
                    items.scrollRectToVisible(new Rectangle(0, scrollIncrementFinal * (AbstractUndoableMovesPanel.this.m_moves.size() - AbstractUndoableMovesPanel.this.previousVisibleIndex), 1, scrollIncrementFinal));
                    AbstractUndoableMovesPanel.this.previousVisibleIndex = null;
                }
                super.paint(g);
            }
        };
        this.scroll.setBorder(null);
        this.scroll.getVerticalScrollBar().setUnitIncrement(scrollIncrementFinal);
        if (this.scrollBarPreviousValue != null) {
            this.scroll.getVerticalScrollBar().setValue(this.scrollBarPreviousValue);
            this.scrollBarPreviousValue = null;
        }
        this.add((Component)this.scroll, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AbstractUndoableMovesPanel.this.validate();
            }
        });
    }

    private JComponent createComponentForMove(AbstractUndoableMove move) {
        Box unitsBox = new Box(0);
        unitsBox.add(new JLabel(move.getIndex() + 1 + ") "));
        Set<UnitCategory> unitCategories = UnitSeperator.categorize(move.getUnits());
        Iterator iter = unitCategories.iterator();
        Dimension buttonSize = new Dimension(80, 22);
        while (iter.hasNext()) {
            UnitCategory category = (UnitCategory)iter.next();
            ImageIcon icon = this.m_movePanel.getMap().getUIContext().getUnitImageFactory().getIcon(category.getType(), category.getOwner(), this.m_data, category.hasDamageOrBombingUnitDamage(), category.getDisabled());
            JLabel label = new JLabel("x" + category.getUnits().size() + " ", icon, 2);
            unitsBox.add(label);
        }
        unitsBox.add(Box.createHorizontalGlue());
        JLabel text = new JLabel(move.getMoveLabel());
        Box textBox = new Box(0);
        textBox.add(text);
        textBox.add(Box.createHorizontalGlue());
        JButton cancelButton = new JButton(new UndoMoveActionListener(move.getIndex()));
        this.setSize(buttonSize, cancelButton);
        JButton viewbutton = new JButton(new ViewAction(move));
        this.setSize(buttonSize, viewbutton);
        Box buttonsBox = new Box(0);
        buttonsBox.add(viewbutton);
        buttonsBox.add(cancelButton);
        buttonsBox.add(Box.createHorizontalGlue());
        Box rVal = new Box(1);
        rVal.add(unitsBox);
        rVal.add(textBox);
        rVal.add(buttonsBox);
        rVal.add(new JLabel(" "));
        return rVal;
    }

    public int getCountOfMovesMade() {
        return this.m_moves.size();
    }

    protected void setSize(Dimension buttonSize, JButton cancelButton) {
        cancelButton.setMinimumSize(buttonSize);
        cancelButton.setPreferredSize(buttonSize);
        cancelButton.setMaximumSize(buttonSize);
    }

    protected void specificViewAction(AbstractUndoableMove move) {
    }

    class ViewAction
    extends AbstractAction {
        private static final long serialVersionUID = -6999284663802575467L;
        private final AbstractUndoableMove m_move;

        public ViewAction(AbstractUndoableMove move) {
            super("Show");
            this.m_move = move;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractUndoableMovesPanel.this.m_movePanel.cancelMove();
            if (!AbstractUndoableMovesPanel.this.m_movePanel.getMap().isShowing(this.m_move.getEnd())) {
                AbstractUndoableMovesPanel.this.m_movePanel.getMap().centerOn(this.m_move.getEnd());
            }
            AbstractUndoableMovesPanel.this.specificViewAction(this.m_move);
        }
    }

    class UndoAllMovesActionListener
    extends AbstractAction {
        private static final long serialVersionUID = 7908136093303143896L;

        public UndoAllMovesActionListener() {
            super("UndoAllMoves");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int moveCount = AbstractUndoableMovesPanel.this.m_movePanel.getUndoableMoves().size();
            boolean suppressErrorMsgToUser = true;
            for (int i = moveCount - 1; i >= 0; --i) {
                AbstractUndoableMovesPanel.this.m_movePanel.undoMove(i, suppressErrorMsgToUser);
            }
        }
    }

    class UndoMoveActionListener
    extends AbstractAction {
        private static final long serialVersionUID = -397312652244693138L;
        private final int m_moveIndex;

        public UndoMoveActionListener(int index) {
            super("Undo");
            this.m_moveIndex = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractUndoableMovesPanel.this.scrollBarPreviousValue = AbstractUndoableMovesPanel.this.scroll.getVerticalScrollBar().getValue();
            String error = AbstractUndoableMovesPanel.this.m_movePanel.undoMove(this.m_moveIndex);
            AbstractUndoableMovesPanel.this.previousVisibleIndex = error == null ? Integer.valueOf(Math.max(0, this.m_moveIndex - 1)) : null;
        }
    }
}

