/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.gamePlayer.IPlayerBridge;
import games.strategy.triplea.attatchments.PoliticalActionAttachment;
import games.strategy.triplea.attatchments.UserActionAttachment;
import games.strategy.triplea.delegate.AbstractMoveDelegate;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.dataObjects.FightBattleDetails;
import games.strategy.triplea.delegate.dataObjects.MoveDescription;
import games.strategy.triplea.delegate.dataObjects.TechRoll;
import games.strategy.triplea.delegate.remote.IPoliticsDelegate;
import games.strategy.triplea.delegate.remote.IUserActionDelegate;
import games.strategy.triplea.ui.AbstractMovePanel;
import games.strategy.triplea.ui.ActionPanel;
import games.strategy.triplea.ui.Active;
import games.strategy.triplea.ui.BattlePanel;
import games.strategy.triplea.ui.EndTurnPanel;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.MoveForumPosterPanel;
import games.strategy.triplea.ui.MovePanel;
import games.strategy.triplea.ui.PickTerritoryAndUnitsPanel;
import games.strategy.triplea.ui.PlaceData;
import games.strategy.triplea.ui.PlacePanel;
import games.strategy.triplea.ui.PoliticsPanel;
import games.strategy.triplea.ui.PurchasePanel;
import games.strategy.triplea.ui.RepairPanel;
import games.strategy.triplea.ui.TechPanel;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.triplea.ui.UserActionPanel;
import games.strategy.util.IntegerMap;
import games.strategy.util.Tuple;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ActionButtons
extends JPanel {
    private static final long serialVersionUID = 2175685892863042399L;
    private final CardLayout m_layout = new CardLayout();
    private BattlePanel m_battlePanel;
    private MovePanel m_movePanel;
    private PurchasePanel m_purchasePanel;
    private RepairPanel m_repairPanel;
    private PlacePanel m_placePanel;
    private TechPanel m_techPanel;
    private EndTurnPanel m_endTurnPanel;
    private MoveForumPosterPanel m_moveForumPosterPanel;
    private ActionPanel m_current;
    private PoliticsPanel m_politicsPanel;
    private UserActionPanel m_userActionPanel;
    private PickTerritoryAndUnitsPanel m_pickTerritoryAndUnitsPanel;

    public ActionButtons(GameData data, MapPanel map, TripleAFrame parent) {
        this.m_battlePanel = new BattlePanel(data, map);
        this.m_movePanel = new MovePanel(data, map, parent);
        this.m_purchasePanel = new PurchasePanel(data, map);
        this.m_repairPanel = new RepairPanel(data, map);
        this.m_placePanel = new PlacePanel(data, map, parent);
        this.m_techPanel = new TechPanel(data, map);
        this.m_endTurnPanel = new EndTurnPanel(data, map);
        this.m_moveForumPosterPanel = new MoveForumPosterPanel(data, map);
        this.m_politicsPanel = new PoliticsPanel(data, map, parent);
        this.m_userActionPanel = new UserActionPanel(data, map, parent);
        this.m_pickTerritoryAndUnitsPanel = new PickTerritoryAndUnitsPanel(data, map, parent);
        this.m_current = this.m_techPanel;
        this.setLayout(this.m_layout);
        this.add((Component)new JLabel(""), "");
        this.add((Component)this.m_battlePanel, this.m_battlePanel.toString());
        this.add((Component)this.m_movePanel, this.m_movePanel.toString());
        this.add((Component)this.m_repairPanel, this.m_repairPanel.toString());
        this.add((Component)this.m_purchasePanel, this.m_purchasePanel.toString());
        this.add((Component)this.m_placePanel, this.m_placePanel.toString());
        this.add((Component)this.m_techPanel, this.m_techPanel.toString());
        this.add((Component)this.m_endTurnPanel, this.m_endTurnPanel.toString());
        this.add((Component)this.m_moveForumPosterPanel, this.m_moveForumPosterPanel.toString());
        this.add((Component)this.m_politicsPanel, this.m_politicsPanel.toString());
        this.add((Component)this.m_userActionPanel, this.m_userActionPanel.toString());
        this.add((Component)this.m_pickTerritoryAndUnitsPanel, this.m_pickTerritoryAndUnitsPanel.toString());
        map.getUIContext().addActive(new Active(){

            @Override
            public void deactivate() {
                ActionButtons.this.removeAll();
                ActionButtons.this.m_current = null;
                ActionButtons.this.m_battlePanel.removeAll();
                ActionButtons.this.m_movePanel.removeAll();
                ActionButtons.this.m_repairPanel.removeAll();
                ActionButtons.this.m_purchasePanel.removeAll();
                ActionButtons.this.m_placePanel.removeAll();
                ActionButtons.this.m_techPanel.removeAll();
                ActionButtons.this.m_endTurnPanel.removeAll();
                ActionButtons.this.m_moveForumPosterPanel.removeAll();
                ActionButtons.this.m_politicsPanel.removeAll();
                ActionButtons.this.m_userActionPanel.removeAll();
                ActionButtons.this.m_pickTerritoryAndUnitsPanel.removeAll();
                ActionButtons.this.m_battlePanel = null;
                ActionButtons.this.m_movePanel = null;
                ActionButtons.this.m_repairPanel = null;
                ActionButtons.this.m_purchasePanel = null;
                ActionButtons.this.m_placePanel = null;
                ActionButtons.this.m_techPanel = null;
                ActionButtons.this.m_endTurnPanel = null;
                ActionButtons.this.m_moveForumPosterPanel = null;
                ActionButtons.this.m_politicsPanel = null;
                ActionButtons.this.m_userActionPanel = null;
                ActionButtons.this.m_pickTerritoryAndUnitsPanel = null;
            }
        });
    }

    public void keyPressed(KeyEvent e) {
        this.m_current.keyPressed(e);
    }

    public void changeToMove(PlayerID id, boolean nonCombat, String stepName) {
        this.m_movePanel.setNonCombat(nonCombat);
        boolean airBorne = stepName.endsWith("AirborneCombatMove");
        String displayText = airBorne ? " Airborne" : (nonCombat ? " Non" : "");
        this.m_movePanel.setDisplayText(displayText + " Combat Move");
        this.m_movePanel.setMoveType(airBorne ? AbstractMoveDelegate.MoveType.SPECIAL : AbstractMoveDelegate.MoveType.DEFAULT);
        this.changeTo(id, this.m_movePanel);
    }

    public void changeToRepair(PlayerID id) {
        this.changeTo(id, this.m_repairPanel);
    }

    public void changeToProduce(PlayerID id) {
        this.changeTo(id, this.m_purchasePanel);
    }

    public void changeToPlace(PlayerID id) {
        this.changeTo(id, this.m_placePanel);
    }

    public void changeToBattle(PlayerID id, Map<IBattle.BattleType, Collection<Territory>> battles) {
        this.m_battlePanel.setBattlesAndBombing(battles);
        this.changeTo(id, this.m_battlePanel);
    }

    public void changeToPolitics(PlayerID id) {
        this.changeTo(id, this.m_politicsPanel);
    }

    public void changeToUserActions(PlayerID id) {
        this.changeTo(id, this.m_userActionPanel);
    }

    public void changeToTech(PlayerID id) {
        this.changeTo(id, this.m_techPanel);
    }

    public void changeToEndTurn(PlayerID id) {
        this.changeTo(id, this.m_endTurnPanel);
    }

    public void changeToMoveForumPosterPanel(PlayerID id) {
        this.changeTo(id, this.m_moveForumPosterPanel);
    }

    private void changeTo(PlayerID id, ActionPanel newCurrent) {
        this.m_current.setActive(false);
        this.m_current = newCurrent;
        if (this.m_current == null) {
            return;
        }
        this.m_current.display(id);
        final String currentName = this.m_current.toString();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ActionButtons.this.m_layout != null) {
                    ActionButtons.this.m_layout.show(ActionButtons.this, currentName);
                }
            }
        });
    }

    public void changeToPickTerritoryAndUnits(PlayerID id) {
        this.changeTo(id, this.m_pickTerritoryAndUnitsPanel);
    }

    public IntegerMap<ProductionRule> waitForPurchase(boolean bid) {
        return this.m_purchasePanel.waitForPurchase(bid);
    }

    public HashMap<Unit, IntegerMap<RepairRule>> waitForRepair(boolean bid, Collection<PlayerID> allowedPlayersToRepair) {
        return this.m_repairPanel.waitForRepair(bid, allowedPlayersToRepair);
    }

    public MoveDescription waitForMove(IPlayerBridge bridge) {
        return this.m_movePanel.waitForMove(bridge);
    }

    public TechRoll waitForTech() {
        return this.m_techPanel.waitForTech();
    }

    public PoliticalActionAttachment waitForPoliticalAction(boolean firstRun, IPoliticsDelegate iPoliticsDelegate) {
        return this.m_politicsPanel.waitForPoliticalAction(firstRun, iPoliticsDelegate);
    }

    public UserActionAttachment waitForUserActionAction(boolean firstRun, IUserActionDelegate iUserActionDelegate) {
        return this.m_userActionPanel.waitForUserActionAction(firstRun, iUserActionDelegate);
    }

    public PlaceData waitForPlace(boolean bid, IPlayerBridge bridge) {
        return this.m_placePanel.waitForPlace(bid, bridge);
    }

    public void waitForEndTurn(TripleAFrame frame, IPlayerBridge bridge) {
        this.m_endTurnPanel.waitForEndTurn(frame, bridge);
    }

    public void waitForMoveForumPosterPanel(TripleAFrame frame, IPlayerBridge bridge) {
        this.m_moveForumPosterPanel.waitForDone(frame, bridge);
    }

    public FightBattleDetails waitForBattleSelection() {
        return this.m_battlePanel.waitForBattleSelection();
    }

    public Tuple<Territory, Set<Unit>> waitForPickTerritoryAndUnits(List<Territory> territoryChoices, List<Unit> unitChoices, int unitsPerPick) {
        return this.m_pickTerritoryAndUnitsPanel.waitForPickTerritoryAndUnits(territoryChoices, unitChoices, unitsPerPick);
    }

    public ActionPanel getCurrent() {
        return this.m_current;
    }

    public BattlePanel getBattlePanel() {
        return this.m_battlePanel;
    }

    public AbstractMovePanel getMovePanel() {
        return this.m_movePanel;
    }

    public PlacePanel getPlacePanel() {
        return this.m_placePanel;
    }

    public PurchasePanel getPurchasePanel() {
        return this.m_purchasePanel;
    }

    public TechPanel getTechPanel() {
        return this.m_techPanel;
    }

    public EndTurnPanel getEndTurnPanel() {
        return this.m_endTurnPanel;
    }

    public MoveForumPosterPanel getMoveForumPosterPanel() {
        return this.m_moveForumPosterPanel;
    }
}

