/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.engine.framework.GameRunner;
import games.strategy.net.GUID;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.DiceRoll;
import games.strategy.triplea.delegate.Die;
import games.strategy.triplea.delegate.IBattle;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TerritoryEffectHelper;
import games.strategy.triplea.delegate.dataObjects.CasualtyDetails;
import games.strategy.triplea.delegate.dataObjects.CasualtyList;
import games.strategy.triplea.ui.BattleModel;
import games.strategy.triplea.ui.BattleStepsPanel;
import games.strategy.triplea.ui.BattleTable;
import games.strategy.triplea.ui.CasualtyNotificationPanel;
import games.strategy.triplea.ui.DicePanel;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.TableData;
import games.strategy.triplea.ui.UnitChooser;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitOwner;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.ui.Util;
import games.strategy.util.Match;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BattleDisplay
extends JPanel {
    private static final long serialVersionUID = -7939993104972562765L;
    private static final String DICE_KEY = "D";
    private static final String CASUALTIES_KEY = "C";
    private static final String MESSAGE_KEY = "M";
    private final GUID m_battleID;
    private final PlayerID m_defender;
    private final PlayerID m_attacker;
    private final Territory m_location;
    private final GameData m_data;
    private final JButton m_actionButton = new JButton("");
    private final BattleModel m_defenderModel;
    private final BattleModel m_attackerModel;
    private BattleStepsPanel m_steps;
    private DicePanel m_dicePanel;
    private final CasualtyNotificationPanel m_casualties;
    private JPanel m_actionPanel;
    private final CardLayout m_actionLayout = new CardLayout();
    private final JPanel m_messagePanel = new JPanel();
    private final MapPanel m_mapPanel;
    private final JPanel m_casualtiesInstantPanelDefender = new JPanel();
    private final JPanel m_casualtiesInstantPanelAttacker = new JPanel();
    private final JLabel LABEL_NONE_ATTACKER = new JLabel("None");
    private final JLabel LABEL_NONE_DEFENDER = new JLabel("None");
    private final IUIContext m_uiContext;
    private final JLabel m_messageLabel = new JLabel();
    private final Action m_nullAction = new AbstractAction(" "){
        private static final long serialVersionUID = 3308067665313935111L;

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    private static final int MY_WIDTH = 100;
    private static final int MY_HEIGHT = 100;

    public BattleDisplay(GameData data, Territory territory, PlayerID attacker, PlayerID defender, Collection<Unit> attackingUnits, Collection<Unit> defendingUnits, Collection<Unit> killedUnits, Collection<Unit> attackingWaitingToDie, Collection<Unit> defendingWaitingToDie, GUID battleID, MapPanel mapPanel, boolean isAmphibious, IBattle.BattleType battleType, Collection<Unit> amphibiousLandAttackers) {
        this.m_battleID = battleID;
        this.m_defender = defender;
        this.m_attacker = attacker;
        this.m_location = territory;
        this.m_mapPanel = mapPanel;
        this.m_data = data;
        Collection<TerritoryEffect> territoryEffects = TerritoryEffectHelper.getEffects(territory);
        this.m_defenderModel = new BattleModel(defendingUnits, false, battleType, defender, this.m_data, this.m_location, territoryEffects, isAmphibious, Collections.<Unit>emptySet(), this.m_mapPanel.getUIContext());
        this.m_attackerModel = new BattleModel(attackingUnits, true, battleType, attacker, this.m_data, this.m_location, territoryEffects, isAmphibious, amphibiousLandAttackers, this.m_mapPanel.getUIContext());
        this.m_defenderModel.setEnemyBattleModel(this.m_attackerModel);
        this.m_attackerModel.setEnemyBattleModel(this.m_defenderModel);
        this.m_defenderModel.refresh();
        this.m_attackerModel.refresh();
        this.m_uiContext = mapPanel.getUIContext();
        this.m_casualties = new CasualtyNotificationPanel(data, this.m_mapPanel.getUIContext());
        if (killedUnits != null && attackingWaitingToDie != null && defendingWaitingToDie != null) {
            List<Unit> attackerUnitsKilled = Match.getMatches(killedUnits, Matches.unitIsOwnedBy(attacker));
            attackerUnitsKilled.addAll(attackingWaitingToDie);
            if (!attackerUnitsKilled.isEmpty()) {
                this.updateKilledUnits(attackerUnitsKilled, attacker);
            }
            List<Unit> defenderUnitsKilled = Match.getMatches(killedUnits, Matches.unitIsOwnedBy(defender));
            defenderUnitsKilled.addAll(defendingWaitingToDie);
            if (!defenderUnitsKilled.isEmpty()) {
                this.updateKilledUnits(defenderUnitsKilled, defender);
            }
        }
        this.initLayout();
    }

    public void cleanUp() {
        this.m_actionButton.setAction(this.m_nullAction);
        this.m_steps.deactivate();
        this.m_mapPanel.getUIContext().removeActive(this.m_steps);
        this.m_steps = null;
    }

    void takeFocus() {
        this.m_actionButton.requestFocus();
    }

    public Territory getBattleLocation() {
        return this.m_location;
    }

    public GUID getBattleID() {
        return this.m_battleID;
    }

    public void bombingResults(List<Die> dice, int cost) {
        this.m_dicePanel.setDiceRollForBombing(dice, cost);
        this.m_actionLayout.show(this.m_actionPanel, DICE_KEY);
    }

    public static boolean getShowEnemyCasualtyNotification() {
        Preferences prefs = Preferences.userNodeForPackage(BattleDisplay.class);
        return prefs.getBoolean("ShowEnemyCasualties", true);
    }

    public static void setShowEnemyCasualtyNotification(boolean aVal) {
        Preferences prefs = Preferences.userNodeForPackage(BattleDisplay.class);
        prefs.putBoolean("ShowEnemyCasualties", aVal);
    }

    public static boolean getFocusOnOwnCasualtiesNotification() {
        Preferences prefs = Preferences.userNodeForPackage(BattleDisplay.class);
        return prefs.getBoolean("FocusOnOwnCasualties", false);
    }

    public static void setFocusOnOwnCasualtiesNotification(boolean aVal) {
        Preferences prefs = Preferences.userNodeForPackage(BattleDisplay.class);
        prefs.putBoolean("FocusOnOwnCasualties", aVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Unit> updateKilledUnits(Collection<Unit> aKilledUnits, PlayerID aPlayerID) {
        Map<Unit, Collection<Unit>> dependentsMap;
        JPanel lCausalityPanel = aPlayerID.equals(this.m_defender) ? this.m_casualtiesInstantPanelDefender : this.m_casualtiesInstantPanelAttacker;
        this.m_data.acquireReadLock();
        try {
            dependentsMap = BattleCalculator.getDependents(aKilledUnits, this.m_data);
        }
        finally {
            this.m_data.releaseReadLock();
        }
        ArrayList<Unit> dependentUnitsReturned = new ArrayList<Unit>();
        for (Collection<Unit> dependentCollection : dependentsMap.values()) {
            dependentUnitsReturned.addAll(dependentCollection);
        }
        for (UnitCategory category : UnitSeperator.categorize(aKilledUnits, dependentsMap, false, false)) {
            JPanel panel = new JPanel();
            JLabel unit = new JLabel(this.m_uiContext.getUnitImageFactory().getIcon(category.getType(), category.getOwner(), this.m_data, false, false));
            panel.add(unit);
            panel.add(new JLabel("x " + category.getUnits().size()));
            for (UnitOwner owner : category.getDependents()) {
                unit = new JLabel(this.m_uiContext.getUnitImageFactory().getIcon(owner.getType(), owner.getOwner(), this.m_data, false, false));
                panel.add(unit);
                panel.add(new JLabel("x " + category.getUnits().size()));
            }
            lCausalityPanel.add(panel);
        }
        return dependentUnitsReturned;
    }

    public void casualtyNotification(String step, DiceRoll dice, PlayerID player, Collection<Unit> killed, Collection<Unit> damaged, Map<Unit, Collection<Unit>> dependents) {
        this.setStep(step);
        this.m_casualties.setNotication(dice, player, killed, damaged, dependents);
        this.m_actionLayout.show(this.m_actionPanel, CASUALTIES_KEY);
        killed.addAll(this.updateKilledUnits(killed, player));
        if (player.equals(this.m_defender)) {
            this.m_defenderModel.removeCasualties(killed);
        } else {
            this.m_attackerModel.removeCasualties(killed);
        }
    }

    public void deadUnitNotification(PlayerID player, Collection<Unit> killed, Map<Unit, Collection<Unit>> dependents) {
        this.m_casualties.setNoticationShort(player, killed, dependents);
        this.m_actionLayout.show(this.m_actionPanel, CASUALTIES_KEY);
        killed.addAll(this.updateKilledUnits(killed, player));
        if (player.equals(this.m_defender)) {
            this.m_defenderModel.removeCasualties(killed);
        } else {
            this.m_attackerModel.removeCasualties(killed);
        }
    }

    public void changedUnitsNotification(PlayerID player, Collection<Unit> removedUnits, Collection<Unit> addedUnits, Map<Unit, Collection<Unit>> dependents) {
        if (player.equals(this.m_defender)) {
            if (removedUnits != null) {
                this.m_defenderModel.removeCasualties(removedUnits);
            }
            if (addedUnits != null) {
                this.m_defenderModel.addUnits(addedUnits);
            }
        } else {
            if (removedUnits != null) {
                this.m_attackerModel.removeCasualties(removedUnits);
            }
            if (addedUnits != null) {
                this.m_attackerModel.addUnits(addedUnits);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForConfirmation(final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This cant be in dispatch thread");
        }
        final CountDownLatch continueLatch = new CountDownLatch(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BattleDisplay.this.m_actionButton.setAction(new AbstractAction(message){
                    private static final long serialVersionUID = 4489826259192394858L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        continueLatch.countDown();
                    }
                });
            }
        });
        this.m_mapPanel.getUIContext().addShutdownLatch(continueLatch);
        try {
            continueLatch.await();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.m_mapPanel.getUIContext().removeShutdownLatch(continueLatch);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BattleDisplay.this.m_actionButton.setAction(BattleDisplay.this.m_nullAction);
            }
        });
    }

    public void endBattle(String message, final Window enclosingFrame) {
        this.m_steps.walkToLastStep();
        final AbstractAction close = new AbstractAction(message + " : (Press Space to close)"){
            private static final long serialVersionUID = 4219274012228245826L;

            @Override
            public void actionPerformed(ActionEvent e) {
                enclosingFrame.setVisible(false);
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BattleDisplay.this.m_actionButton.setAction(close);
            }
        });
    }

    public void notifyRetreat(Collection<Unit> retreating) {
        this.m_defenderModel.notifyRetreat(retreating);
        this.m_attackerModel.notifyRetreat(retreating);
    }

    public Territory getRetreat(String message, Collection<Territory> possible, boolean submerge) {
        if (!submerge || possible.size() > 1) {
            return this.getRetreatInternal(message, possible);
        }
        return this.getSubmerge(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Territory getSubmerge(final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Should not be called from dispatch thread");
        }
        final Territory[] retreatTo = new Territory[1];
        final CountDownLatch latch = new CountDownLatch(1);
        final AbstractAction action = new AbstractAction("Submerge Subs?"){
            private static final long serialVersionUID = -1962843804675586562L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String ok = "Submerge";
                String cancel = "Remain";
                String wait = "Ask Me Later";
                Object[] options = new String[]{"Submerge", "Remain", "Ask Me Later"};
                int choice = JOptionPane.showOptionDialog(BattleDisplay.this, message, "Submerge Subs?", 2, -1, null, options, "Remain");
                if (choice == -1) {
                    return;
                }
                if (choice == 2) {
                    return;
                }
                if (choice == 1) {
                    latch.countDown();
                    return;
                }
                retreatTo[0] = BattleDisplay.this.m_location;
                latch.countDown();
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BattleDisplay.this.m_actionButton.setAction(action);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                action.actionPerformed(null);
            }
        });
        this.m_mapPanel.getUIContext().addShutdownLatch(latch);
        try {
            latch.await();
        }
        catch (InterruptedException e1) {
        }
        finally {
            this.m_mapPanel.getUIContext().removeShutdownLatch(latch);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BattleDisplay.this.m_actionButton.setAction(BattleDisplay.this.m_nullAction);
            }
        });
        return retreatTo[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Territory getRetreatInternal(final String message, final Collection<Territory> possible) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Should not be called from dispatch thread");
        }
        final Territory[] retreatTo = new Territory[1];
        final CountDownLatch latch = new CountDownLatch(1);
        final AbstractAction action = new AbstractAction("Retreat?"){
            private static final long serialVersionUID = -1276337628464642219L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String yes = "Retreat";
                String no = "Remain";
                String cancel = "Ask Me Later";
                Object[] options = new String[]{"Retreat", "Remain", "Ask Me Later"};
                int choice = JOptionPane.showOptionDialog(BattleDisplay.this, message, "Retreat?", 1, -1, null, options, "Remain");
                if (choice == -1) {
                    return;
                }
                if (choice == 2) {
                    return;
                }
                if (choice == 1) {
                    latch.countDown();
                    return;
                }
                RetreatComponent comp = new RetreatComponent(possible);
                int option = JOptionPane.showConfirmDialog(BattleDisplay.this, comp, message, 2, -1, null);
                if (option == 0 && comp.getSelection() != null) {
                    retreatTo[0] = comp.getSelection();
                    latch.countDown();
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BattleDisplay.this.m_actionButton.setAction(action);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                action.actionPerformed(null);
            }
        });
        this.m_mapPanel.getUIContext().addShutdownLatch(latch);
        try {
            latch.await();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        finally {
            this.m_mapPanel.getUIContext().removeShutdownLatch(latch);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BattleDisplay.this.m_actionButton.setAction(BattleDisplay.this.m_nullAction);
            }
        });
        return retreatTo[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CasualtyDetails getCasualties(final Collection<Unit> selectFrom, final Map<Unit, Collection<Unit>> dependents, final int count, final String message, final DiceRoll dice, final PlayerID hit, final CasualtyList defaultCasualties, final boolean allowMultipleHitsPerUnit) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method should not be run in the event dispatch thread");
        }
        final AtomicReference casualtyDetails = new AtomicReference();
        final CountDownLatch continueLatch = new CountDownLatch(1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean isEditMode;
                boolean bl = isEditMode = dice == null;
                if (!isEditMode) {
                    BattleDisplay.this.m_actionLayout.show(BattleDisplay.this.m_actionPanel, BattleDisplay.DICE_KEY);
                    BattleDisplay.this.m_dicePanel.setDiceRoll(dice);
                }
                boolean plural = isEditMode || count > 1;
                String countStr = isEditMode ? "" : "" + count;
                final String btnText = hit.getName() + ", press space to select " + countStr + (plural ? " casualties" : " casualty");
                BattleDisplay.this.m_actionButton.setAction(new AbstractAction(btnText){
                    private static final long serialVersionUID = -2156028313292233568L;
                    private UnitChooser chooser;
                    private JScrollPane chooserScrollPane;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String messageText = message + " " + btnText + ".";
                        if (this.chooser == null || this.chooserScrollPane == null) {
                            this.chooser = new UnitChooser((Collection<Unit>)selectFrom, defaultCasualties, (Map<Unit, Collection<Unit>>)dependents, BattleDisplay.this.m_data, allowMultipleHitsPerUnit, BattleDisplay.this.m_mapPanel.getUIContext());
                            this.chooser.setTitle(messageText);
                            if (isEditMode) {
                                this.chooser.setMax(selectFrom.size());
                            } else {
                                this.chooser.setMax(count);
                            }
                            this.chooserScrollPane = new JScrollPane(this.chooser);
                            Dimension screenResolution = Toolkit.getDefaultToolkit().getScreenSize();
                            int availHeight = screenResolution.height - 80;
                            int availWidth = screenResolution.width - 30;
                            this.chooserScrollPane.setPreferredSize(new Dimension(this.chooserScrollPane.getPreferredSize().width > availWidth ? availWidth : (this.chooserScrollPane.getPreferredSize().height > (availHeight -= 50) ? this.chooserScrollPane.getPreferredSize().width + 22 : this.chooserScrollPane.getPreferredSize().width), this.chooserScrollPane.getPreferredSize().height > availHeight ? availHeight : this.chooserScrollPane.getPreferredSize().height));
                            this.chooserScrollPane.setBorder(new LineBorder(this.chooserScrollPane.getBackground()));
                        }
                        Object[] options = new String[]{"Ok", "Cancel"};
                        String focus = BattleDisplay.getFocusOnOwnCasualtiesNotification() ? options[0] : null;
                        int option = JOptionPane.showOptionDialog(BattleDisplay.this, this.chooserScrollPane, hit.getName() + " select casualties", 0, -1, null, options, focus);
                        if (option != 0) {
                            return;
                        }
                        List<Unit> killed = this.chooser.getSelected(false);
                        List<Unit> damaged = this.chooser.getSelectedDamagedMultipleHitPointUnits();
                        if (!isEditMode && killed.size() + damaged.size() != count) {
                            JOptionPane.showMessageDialog(BattleDisplay.this, "Wrong number of casualties selected", hit.getName() + " select casualties", 0);
                            return;
                        }
                        CasualtyDetails response = new CasualtyDetails(killed, damaged, false);
                        casualtyDetails.set(response);
                        BattleDisplay.this.m_dicePanel.clear();
                        BattleDisplay.this.m_actionButton.setEnabled(false);
                        BattleDisplay.this.m_actionButton.setAction(BattleDisplay.this.m_nullAction);
                        continueLatch.countDown();
                    }
                });
            }
        });
        this.m_mapPanel.getUIContext().addShutdownLatch(continueLatch);
        try {
            continueLatch.await();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        finally {
            this.m_mapPanel.getUIContext().removeShutdownLatch(continueLatch);
        }
        return (CasualtyDetails)casualtyDetails.get();
    }

    private void initLayout() {
        JPanel attackerUnits = new JPanel();
        attackerUnits.setLayout(new BoxLayout(attackerUnits, 1));
        attackerUnits.add(this.getPlayerComponent(this.m_attacker));
        attackerUnits.add(Box.createGlue());
        BattleTable attackerTable = new BattleTable(this.m_attackerModel);
        attackerUnits.add(attackerTable);
        attackerUnits.add(attackerTable.getTableHeader());
        JPanel defenderUnits = new JPanel();
        defenderUnits.setLayout(new BoxLayout(defenderUnits, 1));
        defenderUnits.add(this.getPlayerComponent(this.m_defender));
        defenderUnits.add(Box.createGlue());
        BattleTable defenderTable = new BattleTable(this.m_defenderModel);
        defenderUnits.add(defenderTable);
        defenderUnits.add(defenderTable.getTableHeader());
        JPanel north = new JPanel();
        north.setLayout(new BoxLayout(north, 0));
        north.add(attackerUnits);
        north.add(this.getTerritoryComponent());
        north.add(defenderUnits);
        this.m_messagePanel.setLayout(new BorderLayout());
        this.m_messagePanel.add((Component)this.m_messageLabel, "Center");
        this.m_steps = new BattleStepsPanel();
        this.m_mapPanel.getUIContext().addActive(this.m_steps);
        this.m_steps.setBorder(new EtchedBorder(1));
        this.m_dicePanel = new DicePanel(this.m_mapPanel.getUIContext(), this.m_data);
        this.m_actionPanel = new JPanel();
        this.m_actionPanel.setLayout(this.m_actionLayout);
        this.m_actionPanel.add((Component)this.m_dicePanel, DICE_KEY);
        this.m_actionPanel.add((Component)this.m_casualties, CASUALTIES_KEY);
        this.m_actionPanel.add((Component)this.m_messagePanel, MESSAGE_KEY);
        JPanel diceAndSteps = new JPanel();
        diceAndSteps.setLayout(new BorderLayout());
        diceAndSteps.add((Component)this.m_steps, "West");
        diceAndSteps.add((Component)this.m_actionPanel, "Center");
        this.m_casualtiesInstantPanelAttacker.setLayout(new FlowLayout(0, 2, 2));
        this.m_casualtiesInstantPanelAttacker.setBorder(new EtchedBorder(1));
        this.m_casualtiesInstantPanelAttacker.add(this.LABEL_NONE_ATTACKER);
        this.m_casualtiesInstantPanelDefender.setLayout(new FlowLayout(0, 2, 2));
        this.m_casualtiesInstantPanelDefender.setBorder(new EtchedBorder(1));
        this.m_casualtiesInstantPanelDefender.add(this.LABEL_NONE_DEFENDER);
        JPanel lInstantCasualtiesPanel = new JPanel();
        lInstantCasualtiesPanel.setBorder(new EtchedBorder(1));
        lInstantCasualtiesPanel.setLayout(new GridBagLayout());
        JLabel lCausalities = new JLabel("Casualties", 0);
        lCausalities.setFont(this.getPlayerComponent(this.m_attacker).getFont().deriveFont(1, 14.0f));
        lInstantCasualtiesPanel.add((Component)lCausalities, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        lInstantCasualtiesPanel.add((Component)this.m_casualtiesInstantPanelAttacker, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        lInstantCasualtiesPanel.add((Component)this.m_casualtiesInstantPanelDefender, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        diceAndSteps.add((Component)lInstantCasualtiesPanel, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)north, "North");
        this.add((Component)diceAndSteps, "Center");
        this.add((Component)this.m_actionButton, "South");
        this.m_actionButton.setEnabled(false);
        if (!GameRunner.isMac()) {
            this.m_actionButton.setBackground(Color.lightGray.darker());
            this.m_actionButton.setForeground(Color.white);
        }
        this.setDefaultWidths(defenderTable);
        this.setDefaultWidths(attackerTable);
        AbstractAction continueAction = new AbstractAction(){
            private static final long serialVersionUID = -7893664767396697489L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Action a = BattleDisplay.this.m_actionButton.getAction();
                if (a != null) {
                    a.actionPerformed(null);
                }
            }
        };
        String key = "battle.display.press.space.to.continue";
        this.getActionMap().put("battle.display.press.space.to.continue", continueAction);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(32, 0), "battle.display.press.space.to.continue");
    }

    private void setDefaultWidths(JTable table) {
        for (int column = 0; column < table.getColumnCount(); ++column) {
            boolean hasData = false;
            for (int row = 0; row < table.getRowCount(); ++row) {
                hasData |= table.getValueAt(row, column) != TableData.NULL;
            }
            if (hasData) continue;
            table.getColumnModel().getColumn(column).setPreferredWidth(8);
        }
    }

    public void setStep(String step) {
        this.m_steps.setStep(step);
    }

    public void battleInfo(String messageShort, DiceRoll message, String step) {
        this.setStep(step);
        this.m_dicePanel.setDiceRoll(message);
        this.m_actionLayout.show(this.m_actionPanel, DICE_KEY);
    }

    public void battleInfo(String messageShort, String message, String step) {
        this.m_messageLabel.setText(message);
        this.setStep(step);
        this.m_actionLayout.show(this.m_actionPanel, MESSAGE_KEY);
    }

    public void listBattle(List<String> steps) {
        this.m_steps.listBattle(steps);
    }

    private JComponent getPlayerComponent(PlayerID id) {
        JLabel player = new JLabel(id.getName());
        player.setBorder(new EmptyBorder(5, 5, 5, 5));
        player.setFont(player.getFont().deriveFont(14.0f));
        return player;
    }

    private JComponent getTerritoryComponent() {
        BufferedImage finalImage = Util.createImage(100, 100, true);
        Image territory = this.m_mapPanel.getTerritoryImage(this.m_location);
        Graphics g = ((Image)finalImage).getGraphics();
        g.drawImage(territory, 0, 0, 100, 100, this);
        g.dispose();
        return new JLabel(new ImageIcon(finalImage));
    }

    private class RetreatComponent
    extends JPanel {
        private static final long serialVersionUID = 3855054934860687832L;
        private final JList m_list;
        private final JLabel m_retreatTerritory = new JLabel("");

        RetreatComponent(Collection<Territory> possible) {
            this.setLayout(new BorderLayout());
            JLabel label = new JLabel("Retreat to...");
            label.setBorder(new EmptyBorder(0, 0, 10, 0));
            this.add((Component)label, "North");
            JPanel imagePanel = new JPanel();
            imagePanel.setLayout(new FlowLayout(1));
            imagePanel.add(this.m_retreatTerritory);
            imagePanel.setBorder(new EmptyBorder(10, 10, 10, 0));
            this.add((Component)imagePanel, "East");
            Vector<Territory> listElements = new Vector<Territory>(possible);
            this.m_list = new JList<Territory>(listElements);
            this.m_list.setSelectionMode(0);
            if (listElements.size() >= 1) {
                this.m_list.setSelectedIndex(0);
            }
            JScrollPane scroll = new JScrollPane(this.m_list);
            this.add((Component)scroll, "Center");
            scroll.setBorder(new EmptyBorder(10, 0, 10, 0));
            this.updateImage();
            this.m_list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    RetreatComponent.this.updateImage();
                }
            });
        }

        private void updateImage() {
            int width = 250;
            int height = 250;
            Image img = BattleDisplay.this.m_mapPanel.getTerritoryImage((Territory)this.m_list.getSelectedValue(), BattleDisplay.this.m_location);
            BufferedImage finalImage = Util.createImage(250, 250, true);
            Graphics g = ((Image)finalImage).getGraphics();
            g.drawImage(img, 0, 0, 250, 250, this);
            g.dispose();
            this.m_retreatTerritory.setIcon(new ImageIcon(finalImage));
        }

        public Territory getSelection() {
            return (Territory)this.m_list.getSelectedValue();
        }
    }
}

