/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitOwner;
import games.strategy.ui.ScrollableTextField;
import games.strategy.ui.ScrollableTextFieldListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ChooserEntry {
    private final UnitCategory m_category;
    private final ScrollableTextFieldListener m_hitTextFieldListener;
    private final GameData m_data;
    private final boolean m_hasMultipleHits;
    private final List<Integer> m_defaultHits;
    private final List<ScrollableTextField> m_hitTexts;
    private final List<JLabel> m_hitLabel = new ArrayList<JLabel>();
    private int m_leftToSelect = 0;
    private static Insets nullInsets = new Insets(0, 0, 0, 0);
    private final IUIContext m_uiContext;

    ChooserEntry(UnitCategory category, int leftToSelect, ScrollableTextFieldListener listener, GameData data, boolean allowTwoHit, int defaultValue, IUIContext uiContext) {
        this.m_hitTextFieldListener = listener;
        this.m_data = data;
        this.m_category = category;
        this.m_leftToSelect = leftToSelect < 0 ? category.getUnits().size() : leftToSelect;
        this.m_hasMultipleHits = allowTwoHit && category.getHitPoints() > 1 && category.getDamaged() < category.getHitPoints() - 1;
        this.m_hitTexts = new ArrayList<ScrollableTextField>(Math.max(1, category.getHitPoints() - category.getDamaged()));
        this.m_defaultHits = new ArrayList<Integer>(Math.max(1, category.getHitPoints() - category.getDamaged()));
        int numUnits = category.getUnits().size();
        int hitsUsedSoFar = 0;
        for (int i = 0; i < Math.max(1, category.getHitPoints() - category.getDamaged()); ++i) {
            int hitsToUse = Math.min(numUnits, defaultValue - hitsUsedSoFar);
            hitsUsedSoFar += hitsToUse;
            this.m_defaultHits.add(hitsToUse);
        }
        this.m_uiContext = uiContext;
    }

    public void createComponents(JPanel panel, int yIndex) {
        int gridx = 0;
        for (int i = 0; i < (this.m_hasMultipleHits ? Math.max(1, this.m_category.getHitPoints() - this.m_category.getDamaged()) : 1); ++i) {
            ScrollableTextField scroll = new ScrollableTextField(0, this.m_category.getUnits().size());
            this.m_hitTexts.add(scroll);
            scroll.setValue(this.m_defaultHits.get(i));
            scroll.addChangeListener(this.m_hitTextFieldListener);
            JLabel label = new JLabel("x" + this.m_category.getUnits().size());
            this.m_hitLabel.add(label);
            panel.add((Component)new UnitChooserEntryIcon(i > 0, this.m_uiContext), new GridBagConstraints(gridx++, yIndex, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, i == 0 ? 0 : 8, 0, 0), 0, 0));
            if (i == 0) {
                if (this.m_category.getMovement() != -1) {
                    panel.add((Component)new JLabel("mvt " + this.m_category.getMovement()), new GridBagConstraints(gridx, yIndex, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 0, 4), 0, 0));
                }
                if (this.m_category.getTransportCost() != -1) {
                    panel.add((Component)new JLabel("cst " + this.m_category.getTransportCost()), new GridBagConstraints(gridx, yIndex, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 0, 4), 0, 0));
                }
            }
            int n = ++gridx;
            panel.add((Component)label, new GridBagConstraints(n, yIndex, 1, 1, 0.0, 0.0, 17, 2, nullInsets, 0, 0));
            int n2 = ++gridx;
            ++gridx;
            panel.add((Component)scroll, new GridBagConstraints(n2, yIndex, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 4, 0, 0), 0, 0));
            scroll.addChangeListener(new ScrollableTextFieldListener(){

                @Override
                public void changedValue(ScrollableTextField field) {
                    ChooserEntry.this.updateLeftToSelect();
                }
            });
        }
        this.updateLeftToSelect();
    }

    public int getMax() {
        return this.m_hitTexts.get(0).getMax();
    }

    public void set(int value) {
        this.m_hitTexts.get(0).setValue(value);
    }

    public UnitCategory getCategory() {
        return this.m_category;
    }

    public void selectAll() {
        this.m_hitTexts.get(0).setValue(this.m_hitTexts.get(0).getMax());
    }

    public void selectAllMultipleHitPoints() {
        for (ScrollableTextField t : this.m_hitTexts) {
            t.setValue(t.getMax());
        }
    }

    public void selectNone() {
        this.m_hitTexts.get(0).setValue(0);
    }

    public void setLeftToSelect(int leftToSelect) {
        this.m_leftToSelect = leftToSelect < 0 ? this.m_category.getUnits().size() : leftToSelect;
        this.updateLeftToSelect();
    }

    private void updateLeftToSelect() {
        int previousMax = this.m_category.getUnits().size();
        for (int i = 0; i < this.m_hitTexts.size(); ++i) {
            int newMax = this.m_leftToSelect + this.getHits(i);
            ScrollableTextField text = this.m_hitTexts.get(i);
            if (i > 0 && !this.m_hasMultipleHits) {
                text.setMax(0);
            } else {
                text.setMax(Math.min(newMax, previousMax));
            }
            if (text.getValue() < 0 || text.getValue() > text.getMax()) {
                text.setValue(Math.max(0, Math.min(text.getMax(), text.getValue())));
            }
            this.m_hitLabel.get(i).setText("x" + (i == 0 ? this.m_category.getUnits().size() : text.getMax()));
            previousMax = text.getValue();
        }
    }

    public int getTotalHits() {
        int hits = 0;
        for (int i = 0; i < this.m_hitTexts.size(); ++i) {
            hits += this.getHits(i);
        }
        return hits;
    }

    public int getHits(int zeroBasedHitsPosition) {
        if (zeroBasedHitsPosition < 0 || zeroBasedHitsPosition > this.m_hitTexts.size() - 1) {
            throw new IllegalArgumentException("Index out of range");
        }
        if (!this.m_hasMultipleHits && zeroBasedHitsPosition > 0) {
            return 0;
        }
        return this.m_hitTexts.get(zeroBasedHitsPosition).getValue();
    }

    public int getFinalHit() {
        return this.getHits(this.m_hitTexts.size() - 1);
    }

    public int getAllButFinalHit() {
        int hits = 0;
        for (int i = 0; i < this.m_hitTexts.size() - 1; ++i) {
            hits += this.getHits(i);
        }
        return hits;
    }

    public int size() {
        return this.m_hitTexts.size();
    }

    public boolean hasMultipleHitPoints() {
        return this.m_hasMultipleHits;
    }

    class UnitChooserEntryIcon
    extends JComponent {
        private static final long serialVersionUID = 591598594559651745L;
        private final boolean m_forceDamaged;
        private final IUIContext m_uiContext;

        UnitChooserEntryIcon(boolean forceDamaged, IUIContext uiContext) {
            this.m_forceDamaged = forceDamaged;
            this.m_uiContext = uiContext;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            g.drawImage(this.m_uiContext.getUnitImageFactory().getImage(ChooserEntry.this.m_category.getType(), ChooserEntry.this.m_category.getOwner(), ChooserEntry.this.m_data, this.m_forceDamaged || ChooserEntry.this.m_category.hasDamageOrBombingUnitDamage(), ChooserEntry.this.m_category.getDisabled()), 0, 0, this);
            Iterator<UnitOwner> iter = ChooserEntry.this.m_category.getDependents().iterator();
            int index = 1;
            while (iter.hasNext()) {
                UnitOwner holder = iter.next();
                int x = this.m_uiContext.getUnitImageFactory().getUnitImageWidth() * index;
                Image unitImg = this.m_uiContext.getUnitImageFactory().getImage(holder.getType(), holder.getOwner(), ChooserEntry.this.m_data, false, false);
                g.drawImage(unitImg, x, 0, this);
                ++index;
            }
        }

        @Override
        public int getWidth() {
            return this.m_uiContext.getUnitImageFactory().getUnitImageWidth() * (1 + ChooserEntry.this.m_category.getDependents().size());
        }

        @Override
        public int getHeight() {
            return this.m_uiContext.getUnitImageFactory().getUnitImageHeight();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getDimension();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getDimension();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getDimension();
        }

        public Dimension getDimension() {
            return new Dimension(this.getWidth(), this.getHeight());
        }
    }
}

