/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.history.Event;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.Round;
import games.strategy.engine.history.Step;
import games.strategy.triplea.delegate.remote.IEditDelegate;
import games.strategy.triplea.ui.TripleAFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.tree.TreeNode;

public class CommentPanel
extends JPanel {
    private static final long serialVersionUID = -9122162393288045888L;
    private JTextPane m_text;
    private JScrollPane m_scrollPane;
    private JTextField m_nextMessage;
    private JButton m_save;
    private final GameData m_data;
    private final TripleAFrame m_frame;
    private Map<PlayerID, Icon> m_iconMap;
    private final SimpleAttributeSet bold = new SimpleAttributeSet();
    private final SimpleAttributeSet italic = new SimpleAttributeSet();
    private final SimpleAttributeSet normal = new SimpleAttributeSet();
    private final Action m_saveAction = new AbstractAction("Add Comment"){
        private static final long serialVersionUID = -5771971912942033713L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (CommentPanel.this.m_nextMessage.getText().trim().length() == 0) {
                return;
            }
            CommentPanel.this.addMessage(CommentPanel.this.m_nextMessage.getText());
            CommentPanel.this.m_nextMessage.setText("");
        }
    };

    public CommentPanel(TripleAFrame frame, GameData data) {
        this.m_frame = frame;
        this.m_data = data;
        this.init();
    }

    private void init() {
        this.createComponents();
        this.layoutComponents();
        this.setupKeyMap();
        StyleConstants.setBold(this.bold, true);
        StyleConstants.setItalic(this.italic, true);
        this.setSize(300, 200);
        this.loadHistory();
        this.setupListeners();
    }

    private void layoutComponents() {
        CommentPanel content = this;
        content.setLayout(new BorderLayout());
        this.m_scrollPane = new JScrollPane(this.m_text);
        content.add((Component)this.m_scrollPane, "Center");
        content.add((Component)this.m_scrollPane, "Center");
        JPanel savePanel = new JPanel();
        savePanel.setLayout(new BorderLayout());
        savePanel.add((Component)this.m_nextMessage, "Center");
        savePanel.add((Component)this.m_save, "West");
        content.add((Component)savePanel, "South");
    }

    private void createComponents() {
        this.m_text = new JTextPane();
        this.m_text.setEditable(false);
        this.m_text.setFocusable(false);
        this.m_nextMessage = new JTextField(10);
        Insets inset = new Insets(3, 3, 3, 3);
        this.m_save = new JButton(this.m_saveAction);
        this.m_save.setMargin(inset);
        this.m_save.setFocusable(false);
        this.m_iconMap = new HashMap<PlayerID, Icon>();
        for (PlayerID playerId : this.m_data.getPlayerList().getPlayers()) {
            this.m_iconMap.put(playerId, new ImageIcon(this.m_frame.getUIContext().getFlagImageFactory().getSmallFlag(playerId)));
        }
    }

    private void setupListeners() {
        this.m_data.getHistory().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                CommentPanel.this.readHistoryTreeEvent(e);
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                CommentPanel.this.readHistoryTreeEvent(e);
            }
        });
    }

    private void readHistoryTreeEvent(TreeModelEvent e) {
        final TreeModelEvent tme = e;
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CommentPanel.this.m_data.acquireReadLock();
                try {
                    TreeNode child;
                    Document doc = CommentPanel.this.m_text.getDocument();
                    HistoryNode node = (HistoryNode)tme.getTreePath().getLastPathComponent();
                    TreeNode treeNode = node == null ? null : (child = node.getChildCount() > 0 ? node.getLastChild() : null);
                    String title = child != null ? (child instanceof Event ? ((Event)child).getDescription() : child.toString()) : (node != null ? node.getTitle() : "");
                    Pattern p = Pattern.compile("^COMMENT: (.*)");
                    Matcher m = p.matcher(title);
                    if (m.matches()) {
                        PlayerID playerId = CommentPanel.this.m_data.getSequence().getStep().getPlayerID();
                        int round = CommentPanel.this.m_data.getSequence().getRound();
                        String player = playerId.getName();
                        Icon icon = (Icon)CommentPanel.this.m_iconMap.get(playerId);
                        try {
                            String prefix = " " + player + "(" + round + ") : ";
                            CommentPanel.this.m_text.insertIcon(icon);
                            doc.insertString(doc.getLength(), prefix, CommentPanel.this.bold);
                            doc.insertString(doc.getLength(), m.group(1) + "\n", CommentPanel.this.normal);
                        }
                        catch (BadLocationException ble) {
                            ble.printStackTrace();
                        }
                    }
                }
                finally {
                    CommentPanel.this.m_data.releaseReadLock();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    private void setupKeyMap() {
        InputMap nextMessageKeymap = this.m_nextMessage.getInputMap();
        nextMessageKeymap.put(KeyStroke.getKeyStroke('\n'), this.m_saveAction);
    }

    private void cleanupKeyMap() {
        InputMap nextMessageKeymap = this.m_nextMessage.getInputMap();
        nextMessageKeymap.remove(KeyStroke.getKeyStroke('\n'));
    }

    private void loadHistory() {
        Document doc = this.m_text.getDocument();
        HistoryNode rootNode = (HistoryNode)this.m_data.getHistory().getRoot();
        Enumeration<TreeNode> nodeEnum = rootNode.preorderEnumeration();
        Pattern p = Pattern.compile("^COMMENT: (.*)");
        String player = "";
        int round = 0;
        Icon icon = null;
        while (nodeEnum.hasMoreElements()) {
            HistoryNode node = (HistoryNode)nodeEnum.nextElement();
            if (node instanceof Round) {
                ++round;
                continue;
            }
            if (node instanceof Step) {
                PlayerID playerId = ((Step)node).getPlayerID();
                if (playerId == null) continue;
                player = playerId.getName();
                icon = this.m_iconMap.get(playerId);
                continue;
            }
            String title = node.getTitle();
            Matcher m = p.matcher(title);
            if (!m.matches()) continue;
            try {
                String prefix = " " + player + "(" + round + ") : ";
                this.m_text.insertIcon(icon);
                doc.insertString(doc.getLength(), prefix, this.bold);
                doc.insertString(doc.getLength(), m.group(1) + "\n", this.normal);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
    }

    public void addMessage(final String message) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    Document doc = CommentPanel.this.m_text.getDocument();
                    IEditDelegate delegate = CommentPanel.this.m_frame.getEditDelegate();
                    String error = delegate == null ? "You can only add comments during your turn" : delegate.addComment(message);
                    if (error != null) {
                        doc.insertString(doc.getLength(), error + "\n", CommentPanel.this.italic);
                    }
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                BoundedRangeModel scrollModel = CommentPanel.this.m_scrollPane.getVerticalScrollBar().getModel();
                scrollModel.setValue(scrollModel.getMaximum());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    public static void trimLines(Document doc, int lineCount) {
        if (doc.getLength() < lineCount) {
            return;
        }
        try {
            String text = doc.getText(0, doc.getLength());
            int returnsFound = 0;
            for (int i = text.length() - 1; i >= 0; --i) {
                if (text.charAt(i) == '\n') {
                    ++returnsFound;
                }
                if (returnsFound != lineCount) continue;
                doc.remove(0, i);
                return;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void cleanUp() {
        this.cleanupKeyMap();
    }
}

