/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.image.UnitImageFactory;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.ui.ProductionPanel;
import games.strategy.util.IntegerMap;
import java.awt.Image;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JFrame;

public class EditProductionPanel
extends ProductionPanel {
    private static final long serialVersionUID = 5826523459539469173L;

    public static IntegerMap<ProductionRule> getProduction(PlayerID id, JFrame parent, GameData data, IUIContext uiContext) {
        return new EditProductionPanel(uiContext).show(id, parent, data, false, new IntegerMap<ProductionRule>());
    }

    private EditProductionPanel(IUIContext uiContext) {
        super(uiContext);
    }

    protected void setLeft(int left) {
    }

    @Override
    protected void calculateLimits() {
        for (ProductionPanel.Rule current : this.getRules()) {
            current.setMax(99);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initRules(PlayerID player, GameData data, IntegerMap<ProductionRule> initialPurchase) {
        this.m_data.acquireReadLock();
        try {
            this.m_id = player;
            HashSet<UnitType> unitsAllowed = new HashSet<UnitType>();
            if (player.getProductionFrontier() != null) {
                for (ProductionRule productionRule : player.getProductionFrontier()) {
                    ProductionPanel.Rule rule = new ProductionPanel.Rule(this, productionRule, player);
                    for (Map.Entry<NamedAttachable, Integer> entry : productionRule.getResults().entrySet()) {
                        if (!UnitType.class.isAssignableFrom(entry.getKey().getClass())) continue;
                        unitsAllowed.add((UnitType)entry.getKey());
                    }
                    int initialQuantity = initialPurchase.getInt(productionRule);
                    rule.setQuantity(initialQuantity);
                    this.m_rules.add(rule);
                }
            }
            for (Territory t : data.getMap()) {
                for (Unit u : t.getUnits()) {
                    UnitType ut;
                    if (!u.getOwner().equals(player) || unitsAllowed.contains(ut = u.getType())) continue;
                    unitsAllowed.add(ut);
                    IntegerMap<NamedAttachable> result = new IntegerMap<NamedAttachable>();
                    result.add((NamedAttachable)ut, 1);
                    IntegerMap<Resource> cost = new IntegerMap<Resource>();
                    cost.add(data.getResourceList().getResource("PUs"), 1);
                    ProductionRule newRule = new ProductionRule(ut.getName(), data, result, cost);
                    ProductionPanel.Rule rule = new ProductionPanel.Rule(this, newRule, player);
                    rule.setQuantity(0);
                    this.m_rules.add(rule);
                }
            }
            for (UnitType ut : data.getUnitTypeList().getAllUnitTypes()) {
                if (unitsAllowed.contains(ut)) continue;
                try {
                    Image unitImage;
                    UnitImageFactory imageFactory = this.m_uiContext.getUnitImageFactory();
                    if (imageFactory == null || (unitImage = imageFactory.getImage(ut, player, data, false, false)) == null) continue;
                    unitsAllowed.add(ut);
                    IntegerMap<NamedAttachable> result = new IntegerMap<NamedAttachable>();
                    result.add((NamedAttachable)ut, 1);
                    IntegerMap<Resource> cost = new IntegerMap<Resource>();
                    cost.add(data.getResourceList().getResource("PUs"), 1);
                    ProductionRule newRule = new ProductionRule(ut.getName(), data, result, cost);
                    ProductionPanel.Rule rule = new ProductionPanel.Rule(this, newRule, player);
                    rule.setQuantity(0);
                    this.m_rules.add(rule);
                }
                catch (Exception e) {}
            }
        }
        finally {
            this.m_data.releaseReadLock();
        }
    }
}

