/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.ChangeAttachmentChange;
import games.strategy.engine.data.CompositeChange;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.events.GameDataChangeListener;
import games.strategy.engine.data.events.TerritoryListener;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.ui.Active;
import games.strategy.triplea.ui.BackgroundDrawer;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.ui.MapPanelSmallView;
import games.strategy.triplea.ui.MapRouteDrawer;
import games.strategy.triplea.ui.MapSelectionListener;
import games.strategy.triplea.ui.MouseDetails;
import games.strategy.triplea.ui.MouseOverUnitListener;
import games.strategy.triplea.ui.RouteDescription;
import games.strategy.triplea.ui.UnitSelectionListener;
import games.strategy.triplea.ui.screen.IDrawable;
import games.strategy.triplea.ui.screen.SmallMapImageManager;
import games.strategy.triplea.ui.screen.Tile;
import games.strategy.triplea.ui.screen.TileManager;
import games.strategy.triplea.ui.screen.UnitsDrawer;
import games.strategy.triplea.util.Stopwatch;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.ui.ImageScrollModel;
import games.strategy.ui.ImageScrollerLargeView;
import games.strategy.ui.ScrollListener;
import games.strategy.ui.Util;
import games.strategy.util.ListenerList;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class MapPanel
extends ImageScrollerLargeView {
    private static final long serialVersionUID = -3571551538356292556L;
    private static Logger s_logger = Logger.getLogger(MapPanel.class.getName());
    private final ListenerList<MapSelectionListener> m_mapSelectionListeners = new ListenerList();
    private final ListenerList<UnitSelectionListener> m_unitSelectionListeners = new ListenerList();
    private final ListenerList<MouseOverUnitListener> m_mouseOverUnitsListeners = new ListenerList();
    private GameData m_data;
    private Territory m_currentTerritory;
    private final MapPanelSmallView m_smallView;
    private Tuple<Territory, List<Unit>> m_currentUnits;
    private final SmallMapImageManager m_smallMapImageManager;
    private final List<Object> m_images = new ArrayList<Object>();
    private RouteDescription m_routeDescription;
    private final TileManager m_tileManager;
    private final BackgroundDrawer m_backgroundDrawer;
    private BufferedImage m_mouseShadowImage = null;
    private String m_movementLeftForCurrentUnits = "";
    private final IUIContext m_uiContext;
    private final LinkedBlockingQueue<Tile> m_undrawnTiles = new LinkedBlockingQueue();
    private Map<Territory, List<Unit>> m_highlightUnits;
    private Cursor m_hiddenCursor = null;
    private final MouseListener MOUSE_LISTENER = new MouseAdapter(){

        @Override
        public void mouseExited(MouseEvent e) {
            if (MapPanel.this.unitsChanged(null)) {
                MouseDetails md = MapPanel.this.convert(e);
                MapPanel.this.m_currentUnits = null;
                MapPanel.this.notifyMouseEnterUnit(Collections.emptyList(), MapPanel.this.getTerritory(e.getX(), e.getY()), md);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            double y;
            MouseDetails md = MapPanel.this.convert(e);
            double scaledMouseX = (double)e.getX() / MapPanel.this.m_scale;
            double scaledMouseY = (double)e.getY() / MapPanel.this.m_scale;
            double x = MapPanel.this.normalizeX(scaledMouseX + (double)MapPanel.this.getXOffset());
            Territory terr = MapPanel.this.getTerritory(x, y = MapPanel.this.normalizeY(scaledMouseY + (double)MapPanel.this.getYOffset()));
            if (terr != null) {
                MapPanel.this.notifyTerritorySelected(terr, md);
            }
            if (!MapPanel.this.m_unitSelectionListeners.isEmpty()) {
                Tuple<Territory, List<Unit>> tuple = MapPanel.this.m_tileManager.getUnitsAtPoint(x, y, MapPanel.this.m_data);
                if (tuple == null) {
                    tuple = new Tuple(MapPanel.this.getTerritory(x, y), new ArrayList(0));
                }
                MapPanel.this.notifyUnitSelected(tuple.getSecond(), tuple.getFirst(), md);
            }
        }
    };
    private final MouseMotionListener MOUSE_MOTION_LISTENER = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            double y;
            MouseDetails md = MapPanel.this.convert(e);
            double scaledMouseX = (double)e.getX() / MapPanel.this.m_scale;
            double scaledMouseY = (double)e.getY() / MapPanel.this.m_scale;
            double x = MapPanel.this.normalizeX(scaledMouseX + (double)MapPanel.this.getXOffset());
            Territory terr = MapPanel.this.getTerritory(x, y = MapPanel.this.normalizeY(scaledMouseY + (double)MapPanel.this.getYOffset()));
            if (terr != MapPanel.this.m_currentTerritory) {
                MapPanel.this.m_currentTerritory = terr;
                MapPanel.this.notifyMouseEntered(terr);
            }
            MapPanel.this.notifyMouseMoved(terr, md);
            Tuple<Territory, List<Unit>> tuple = MapPanel.this.m_tileManager.getUnitsAtPoint(x, y, MapPanel.this.m_data);
            if (MapPanel.this.unitsChanged(tuple)) {
                MapPanel.this.m_currentUnits = tuple;
                if (tuple == null) {
                    MapPanel.this.notifyMouseEnterUnit(Collections.emptyList(), MapPanel.this.getTerritory(x, y), md);
                } else {
                    MapPanel.this.notifyMouseEnterUnit(tuple.getSecond(), tuple.getFirst(), md);
                }
            }
        }
    };
    private final TerritoryListener TERRITORY_LISTENER = new TerritoryListener(){

        @Override
        public void unitsChanged(Territory territory) {
            MapPanel.this.updateCountries(Collections.singleton(territory));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapPanel.this.repaint();
                }
            });
        }

        @Override
        public void ownerChanged(Territory territory) {
            MapPanel.this.m_smallMapImageManager.updateTerritoryOwner(territory, MapPanel.this.m_data, MapPanel.this.m_uiContext.getMapData());
            MapPanel.this.updateCountries(Collections.singleton(territory));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapPanel.this.repaint();
                }
            });
        }

        @Override
        public void attachmentChanged(Territory territory) {
            MapPanel.this.updateCountries(Collections.singleton(territory));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapPanel.this.repaint();
                }
            });
        }
    };
    private final GameDataChangeListener TECH_UPDATE_LISTENER = new GameDataChangeListener(){

        @Override
        public void gameDataChanged(Change aChange) {
            HashSet<PlayerID> playersWithTechChange = new HashSet<PlayerID>();
            this.getPlayersWithTechChanges(aChange, playersWithTechChange);
            if (playersWithTechChange.isEmpty()) {
                return;
            }
            MapPanel.this.m_tileManager.resetTiles(MapPanel.this.m_data, MapPanel.this.m_uiContext.getMapData());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapPanel.this.repaint();
                }
            });
        }

        private void getPlayersWithTechChanges(Change aChange, Set<PlayerID> players) {
            ChangeAttachmentChange changeAttachment;
            if (aChange instanceof CompositeChange) {
                CompositeChange composite = (CompositeChange)aChange;
                for (Change item : composite.getChanges()) {
                    this.getPlayersWithTechChanges(item, players);
                }
            } else if (aChange instanceof ChangeAttachmentChange && (changeAttachment = (ChangeAttachmentChange)aChange).getAttachmentName().equals("techAttatchment")) {
                players.add((PlayerID)changeAttachment.getAttachedTo());
            }
        }
    };

    public MapPanel(GameData data, MapPanelSmallView smallView, IUIContext uiContext, ImageScrollModel model) throws IOException {
        super(uiContext.getMapData().getMapDimensions(), model);
        this.m_uiContext = uiContext;
        this.setCursor(this.m_uiContext.getCursor());
        this.m_scale = this.m_uiContext.getScale();
        this.m_backgroundDrawer = new BackgroundDrawer(this);
        this.m_tileManager = new TileManager(this.m_uiContext);
        Thread t = new Thread((Runnable)this.m_backgroundDrawer, "Map panel background drawer");
        t.setDaemon(true);
        t.start();
        this.setDoubleBuffered(false);
        this.m_smallView = smallView;
        this.m_smallMapImageManager = new SmallMapImageManager(smallView, this.m_uiContext.getMapImage().getSmallMapImage(), this.m_tileManager);
        this.setGameData(data);
        this.addMouseListener(this.MOUSE_LISTENER);
        this.addMouseMotionListener(this.MOUSE_MOTION_LISTENER);
        this.addScrollListener(new ScrollListener(){

            @Override
            public void scrolled(int x, int y) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MapPanel.this.repaint();
                    }
                });
            }
        });
        this.recreateTiles(data, this.m_uiContext);
        this.m_uiContext.addActive(new Active(){

            @Override
            public void deactivate() {
                MapPanel.this.deactivate();
                MapPanel.this.clearUndrawn();
                MapPanel.this.m_backgroundDrawer.stop();
            }
        });
    }

    LinkedBlockingQueue<Tile> getUndrawnTiles() {
        return this.m_undrawnTiles;
    }

    private void recreateTiles(GameData data, IUIContext uiContext) {
        this.m_tileManager.createTiles(new Rectangle(this.m_uiContext.getMapData().getMapDimensions()), data, this.m_uiContext.getMapData());
        this.m_tileManager.resetTiles(data, uiContext.getMapData());
    }

    GameData getData() {
        return this.m_data;
    }

    public void changeImage(Dimension newDimensions) {
        this.m_model.setMaxBounds((int)newDimensions.getWidth(), (int)newDimensions.getHeight());
        this.m_tileManager.createTiles(new Rectangle(newDimensions), this.m_data, this.m_uiContext.getMapData());
        this.m_tileManager.resetTiles(this.m_data, this.m_uiContext.getMapData());
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getImageDimensions();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(200, 200);
    }

    public boolean isShowing(Territory territory) {
        Point territoryCenter = this.m_uiContext.getMapData().getCenter(territory);
        Rectangle2D.Double screenBounds = new Rectangle2D.Double(super.getXOffset(), super.getYOffset(), super.getScaledWidth(), super.getScaledHeight());
        return screenBounds.contains(territoryCenter);
    }

    public void setUnitHighlight(Map<Territory, List<Unit>> units) {
        this.m_highlightUnits = units;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapPanel.this.repaint();
            }
        });
    }

    public void centerOn(Territory territory) {
        if (territory == null || this.m_uiContext.getLockMap()) {
            return;
        }
        Point p = this.m_uiContext.getMapData().getCenter(territory);
        super.setTopLeft((int)((double)p.x - this.getScaledWidth() / 2.0), (int)((double)p.y - this.getScaledHeight() / 2.0));
    }

    public void setRoute(Route route) {
        this.setRoute(route, null, null, null);
    }

    public void setRoute(Route route, Point start, Point end, Image cursorImage) {
        if (route == null) {
            this.m_routeDescription = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapPanel.this.repaint();
                }
            });
            return;
        }
        RouteDescription newVal = new RouteDescription(route, start, end, cursorImage);
        if (this.m_routeDescription != null && this.m_routeDescription.equals(newVal)) {
            return;
        }
        this.m_routeDescription = newVal;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapPanel.this.repaint();
            }
        });
    }

    public void addMapSelectionListener(MapSelectionListener listener) {
        this.m_mapSelectionListeners.add(listener);
    }

    public void removeMapSelectionListener(MapSelectionListener listener) {
        this.m_mapSelectionListeners.remove(listener);
    }

    public void addMouseOverUnitListener(MouseOverUnitListener listener) {
        this.m_mouseOverUnitsListeners.add(listener);
    }

    public void removeMouseOverUnitListener(MouseOverUnitListener listener) {
        this.m_mouseOverUnitsListeners.remove(listener);
    }

    private void notifyTerritorySelected(Territory t, MouseDetails me) {
        for (MapSelectionListener msl : this.m_mapSelectionListeners) {
            msl.territorySelected(t, me);
        }
    }

    private void notifyMouseMoved(Territory t, MouseDetails me) {
        for (MapSelectionListener msl : this.m_mapSelectionListeners) {
            msl.mouseMoved(t, me);
        }
    }

    private void notifyMouseEntered(Territory t) {
        for (MapSelectionListener msl : this.m_mapSelectionListeners) {
            msl.mouseEntered(t);
        }
    }

    public void addUnitSelectionListener(UnitSelectionListener listener) {
        this.m_unitSelectionListeners.add(listener);
    }

    public void removeUnitSelectionListener(UnitSelectionListener listener) {
        this.m_unitSelectionListeners.remove(listener);
    }

    private void notifyUnitSelected(List<Unit> units, Territory t, MouseDetails me) {
        for (UnitSelectionListener listener : this.m_unitSelectionListeners) {
            listener.unitsSelected(units, t, me);
        }
    }

    private void notifyMouseEnterUnit(List<Unit> units, Territory t, MouseDetails me) {
        for (MouseOverUnitListener listener : this.m_mouseOverUnitsListeners) {
            listener.mouseEnter(units, t, me);
        }
    }

    private Territory getTerritory(double x, double y) {
        String name = this.m_uiContext.getMapData().getTerritoryAt(this.normalizeX(x), this.normalizeY(y));
        if (name == null) {
            return null;
        }
        return this.m_data.getMap().getTerritory(name);
    }

    private double normalizeX(double x) {
        if (!this.m_uiContext.getMapData().scrollWrapX()) {
            return x;
        }
        int imageWidth = (int)this.getImageDimensions().getWidth();
        if (x < 0.0) {
            x += (double)imageWidth;
        } else if (x > (double)imageWidth) {
            x -= (double)imageWidth;
        }
        return x;
    }

    private double normalizeY(double y) {
        if (!this.m_uiContext.getMapData().scrollWrapY()) {
            return y;
        }
        int imageHeight = (int)this.getImageDimensions().getHeight();
        if (y < 0.0) {
            y += (double)imageHeight;
        } else if (y > (double)imageHeight) {
            y -= (double)imageHeight;
        }
        return y;
    }

    public void resetMap() {
        this.m_tileManager.resetTiles(this.m_data, this.m_uiContext.getMapData());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapPanel.this.repaint();
            }
        });
        this.initSmallMap();
    }

    private MouseDetails convert(MouseEvent me) {
        double scaledMouseX = (double)me.getX() / this.m_scale;
        double scaledMouseY = (double)me.getY() / this.m_scale;
        double x = this.normalizeX(scaledMouseX + (double)this.getXOffset());
        double y = this.normalizeY(scaledMouseY + (double)this.getYOffset());
        return new MouseDetails(me, x, y);
    }

    private boolean unitsChanged(Tuple<Territory, List<Unit>> newUnits) {
        if (newUnits == this.m_currentUnits) {
            return false;
        }
        if (newUnits == null || this.m_currentUnits == null) {
            return true;
        }
        if (!newUnits.getFirst().equals(this.m_currentUnits.getFirst())) {
            return true;
        }
        return !games.strategy.util.Util.equals((Collection)newUnits.getSecond(), (Collection)this.m_currentUnits.getSecond());
    }

    public void updateCountries(Collection<Territory> countries) {
        this.m_tileManager.updateTerritories(countries, this.m_data, this.m_uiContext.getMapData());
        this.m_smallMapImageManager.update(this.m_data, this.m_uiContext.getMapData());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapPanel.this.m_smallView.repaint();
                MapPanel.this.repaint();
            }
        });
    }

    public void setGameData(GameData data) {
        if (this.m_data != null) {
            this.m_data.removeTerritoryListener(this.TERRITORY_LISTENER);
            this.m_data.removeDataChangeListener(this.TECH_UPDATE_LISTENER);
        }
        this.m_data = data;
        this.m_data.addTerritoryListener(this.TERRITORY_LISTENER);
        this.m_data.addDataChangeListener(this.TECH_UPDATE_LISTENER);
        this.clearUndrawn();
        this.m_tileManager.resetTiles(this.m_data, this.m_uiContext.getMapData());
    }

    @Override
    public void setTopLeft(int x, int y) {
        super.setTopLeft(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        super.print(g2d);
        GameData gameData = this.m_data;
        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, this.getImageWidth(), this.getImageHeight());
        List<Tile> tileList = this.m_tileManager.getTiles(bounds);
        for (Tile tile : tileList) {
            Tile.S_TILE_LOCKUTIL.acquireLock(tile.getLock());
            try {
                Image img = tile.getImage(gameData, this.m_uiContext.getMapData());
                if (img == null) continue;
                AffineTransform t = new AffineTransform();
                t.translate(((double)tile.getBounds().x - bounds.getX()) * this.m_scale, ((double)tile.getBounds().y - bounds.getY()) * this.m_scale);
                g2d.drawImage(img, t, this);
            }
            finally {
                Tile.S_TILE_LOCKUTIL.releaseLock(tile.getLock());
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        boolean fitAxisY;
        Graphics2D g2d = (Graphics2D)g;
        super.paint(g2d);
        g2d.clip(new Rectangle2D.Double(0.0, 0.0, (double)this.getImageWidth() * this.m_scale, (double)this.getImageHeight() * this.m_scale));
        int x = this.m_model.getX();
        int y = this.m_model.getY();
        ArrayList<Tile> images = new ArrayList<Tile>();
        ArrayList<Tile> undrawnTiles = new ArrayList<Tile>();
        Stopwatch stopWatch = new Stopwatch(s_logger, Level.FINER, "Paint");
        GameData data = this.m_data;
        boolean fitAxisX = !this.mapWidthFitsOnScreen() && this.m_uiContext.getMapData().scrollWrapX();
        boolean bl = fitAxisY = !this.mapHeightFitsOnScreen() && this.m_uiContext.getMapData().scrollWrapY();
        if (fitAxisX || fitAxisY) {
            if (fitAxisX && x + (int)this.getScaledWidth() > this.m_model.getMaxWidth()) {
                x -= this.m_model.getMaxWidth();
            }
            if (fitAxisY && y + (int)this.getScaledHeight() > this.m_model.getMaxHeight()) {
                y -= this.m_model.getMaxHeight();
            }
            if (fitAxisX && x < 0) {
                if (fitAxisY && y < 0) {
                    Rectangle2D.Double leftUpperBounds = new Rectangle2D.Double(this.m_model.getMaxWidth() + x, this.m_model.getMaxHeight() + y, -x, -y);
                    this.drawTiles(g2d, images, data, leftUpperBounds, 0.0, 0.0, undrawnTiles);
                }
                Rectangle2D.Double leftBounds = new Rectangle2D.Double(this.m_model.getMaxWidth() + x, y, -x, this.getScaledHeight());
                this.drawTiles(g2d, images, data, leftBounds, 0.0, 0.0, undrawnTiles);
            }
            if (fitAxisY && y < 0) {
                Rectangle2D.Double upperBounds = new Rectangle2D.Double(x, this.m_model.getMaxHeight() + y, this.getScaledWidth(), -y);
                this.drawTiles(g2d, images, data, upperBounds, 0.0, 0.0, undrawnTiles);
            }
        }
        Rectangle2D.Double mainBounds = new Rectangle2D.Double(x, y, this.getScaledWidth(), this.getScaledHeight());
        this.drawTiles(g2d, images, data, mainBounds, 0.0, 0.0, undrawnTiles);
        if (this.m_routeDescription != null && this.m_mouseShadowImage != null && this.m_routeDescription.getEnd() != null) {
            AffineTransform t = new AffineTransform();
            t.translate(this.m_scale * this.normalizeX(this.m_routeDescription.getEnd().getX() - (double)this.getXOffset()), this.m_scale * this.normalizeY(this.m_routeDescription.getEnd().getY() - (double)this.getYOffset()));
            t.scale(this.m_scale, this.m_scale);
            g2d.drawImage(this.m_mouseShadowImage, t, this);
        }
        MapRouteDrawer.drawRoute(g2d, this.m_routeDescription, this, this.m_uiContext.getMapData(), this.m_movementLeftForCurrentUnits);
        this.m_images.clear();
        this.m_images.addAll(images);
        if (this.m_highlightUnits != null) {
            for (Map.Entry<Territory, List<Unit>> entry : this.m_highlightUnits.entrySet()) {
                Set<UnitCategory> categories = UnitSeperator.categorize((Collection<Unit>)entry.getValue());
                for (UnitCategory category : categories) {
                    Rectangle r;
                    List<Unit> territoryUnitsOfSameCategory = category.getUnits();
                    if (territoryUnitsOfSameCategory.isEmpty() || (r = this.m_tileManager.getUnitRect(territoryUnitsOfSameCategory, this.m_data)) == null) continue;
                    BufferedImage highlight = (BufferedImage)this.m_uiContext.getUnitImageFactory().getHighlightImage(category.getType(), category.getOwner(), this.m_data, category.hasDamageOrBombingUnitDamage(), category.getDisabled());
                    AffineTransform t = new AffineTransform();
                    t.translate(this.normalizeX(r.getX() - (double)this.getXOffset()) * this.m_scale, this.normalizeY(r.getY() - (double)this.getYOffset()) * this.m_scale);
                    t.scale(this.m_scale, this.m_scale);
                    g2d.drawImage(highlight, t, this);
                }
            }
        }
        this.updateUndrawnTiles(undrawnTiles, 30, true);
        this.updateUndrawnTiles(undrawnTiles, 257, true);
        this.updateUndrawnTiles(undrawnTiles, 513, false);
        this.updateUndrawnTiles(undrawnTiles, 767, false);
        this.clearUndrawn();
        this.m_undrawnTiles.addAll(undrawnTiles);
        stopWatch.done();
    }

    private void clearUndrawn() {
        for (int i = 0; i < 3; ++i) {
            try {
                this.m_undrawnTiles.clear();
                return;
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                continue;
            }
        }
    }

    boolean mapWidthFitsOnScreen() {
        return (double)this.m_model.getMaxWidth() < this.getScaledWidth();
    }

    boolean mapHeightFitsOnScreen() {
        return (double)this.m_model.getMaxHeight() < this.getScaledHeight();
    }

    private void updateUndrawnTiles(List<Tile> undrawnTiles, int preDrawMargin, boolean forceInMemory) {
        if (undrawnTiles.isEmpty()) {
            Rectangle2D.Double extendedBounds = new Rectangle2D.Double(Math.max(this.m_model.getX() - preDrawMargin, 0), Math.max(this.m_model.getY() - preDrawMargin, 0), this.getScaledWidth() + (double)(2 * preDrawMargin), this.getScaledHeight() + (double)(2 * preDrawMargin));
            List<Tile> tileList = this.m_tileManager.getTiles(extendedBounds);
            for (Tile tile : tileList) {
                if (tile.isDirty()) {
                    undrawnTiles.add(tile);
                    continue;
                }
                if (!forceInMemory) continue;
                this.m_images.add(tile.getRawImage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawTiles(Graphics2D g, List<Tile> images, GameData data, Rectangle2D.Double bounds, double overlapX, double overlapY, List<Tile> undrawn) {
        List<Tile> tileList = this.m_tileManager.getTiles(bounds);
        bounds = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getHeight(), bounds.getWidth());
        if (overlapX != 0.0) {
            bounds.x += overlapX - this.getScaledWidth();
        }
        if (overlapY != 0.0) {
            bounds.y += overlapY - this.getScaledHeight();
        }
        for (Tile tile : tileList) {
            Image img = null;
            Tile.S_TILE_LOCKUTIL.acquireLock(tile.getLock());
            try {
                if (tile.isDirty()) {
                    undrawn.add(tile);
                    img = tile.getRawImage();
                } else {
                    img = tile.getImage(data, this.m_uiContext.getMapData());
                    images.add(tile);
                }
                if (img == null) continue;
                AffineTransform t = new AffineTransform();
                t.translate(this.m_scale * ((double)tile.getBounds().x - bounds.getX()), this.m_scale * ((double)tile.getBounds().y - bounds.getY()));
                g.drawImage(img, t, this);
            }
            finally {
                Tile.S_TILE_LOCKUTIL.releaseLock(tile.getLock());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getTerritoryImage(Territory territory) {
        this.getData().acquireReadLock();
        try {
            Image image = this.m_tileManager.createTerritoryImage(territory, this.m_data, this.m_uiContext.getMapData());
            return image;
        }
        finally {
            this.getData().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getTerritoryImage(Territory territory, Territory focusOn) {
        this.getData().acquireReadLock();
        try {
            Image image = this.m_tileManager.createTerritoryImage(territory, focusOn, this.m_data, this.m_uiContext.getMapData());
            return image;
        }
        finally {
            this.getData().releaseReadLock();
        }
    }

    public double getScale() {
        return this.m_scale;
    }

    @Override
    public void setScale(double newScale) {
        super.setScale(newScale);
        double normalizedScale = this.m_scale;
        IDrawable.OptionalExtraBorderLevel drawBorderOption = this.m_uiContext.getDrawTerritoryBordersAgain();
        if (normalizedScale >= 1.0) {
            if (drawBorderOption != IDrawable.OptionalExtraBorderLevel.LOW) {
                this.m_uiContext.resetDrawTerritoryBordersAgain();
            }
        } else if (drawBorderOption == IDrawable.OptionalExtraBorderLevel.LOW) {
            this.m_uiContext.setDrawTerritoryBordersAgainToMedium();
        }
        this.m_uiContext.setScale(normalizedScale);
        this.recreateTiles(this.getData(), this.m_uiContext);
        this.repaint();
    }

    public void initSmallMap() {
        for (Territory territory : this.m_data.getMap().getTerritories()) {
            this.m_smallMapImageManager.updateTerritoryOwner(territory, this.m_data, this.m_uiContext.getMapData());
        }
        this.m_smallMapImageManager.update(this.m_data, this.m_uiContext.getMapData());
    }

    public void changeSmallMapOffscreenMap() {
        this.m_smallMapImageManager.updateOffscreenImage(this.m_uiContext.getMapImage().getSmallMapImage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMouseShadowUnits(Collection<Unit> units) {
        if (units == null || units.isEmpty()) {
            this.m_movementLeftForCurrentUnits = "";
            this.m_mouseShadowImage = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapPanel.this.repaint();
                }
            });
            return;
        }
        Tuple<Integer, Integer> movementLeft = TripleAUnit.getMinAndMaxMovementLeft(Match.getMatches(units, Matches.unitIsBeingTransported().invert()));
        this.m_movementLeftForCurrentUnits = movementLeft.getFirst() + (movementLeft.getSecond() > movementLeft.getFirst() ? "+" : "");
        Set<UnitCategory> categories = UnitSeperator.categorize(units);
        int icon_width = this.m_uiContext.getUnitImageFactory().getUnitImageWidth();
        int xSpace = 5;
        BufferedImage img = Util.createImage(categories.size() * (5 + icon_width), this.m_uiContext.getUnitImageFactory().getUnitImageHeight(), true);
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setComposite(AlphaComposite.getInstance(3, 0.6f));
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        this.getData().acquireReadLock();
        try {
            int i = 0;
            for (UnitCategory category : categories) {
                Point place = new Point(i * (icon_width + 5), 0);
                UnitsDrawer drawer = new UnitsDrawer(category.getUnits().size(), category.getType().getName(), category.getOwner().getName(), place, category.getDamaged(), category.getBombingDamage(), category.getDisabled(), false, "", this.m_uiContext);
                drawer.draw(bounds, this.m_data, g, this.m_uiContext.getMapData(), null, null);
                ++i;
            }
        }
        finally {
            this.getData().releaseReadLock();
        }
        this.m_mouseShadowImage = img;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MapPanel.this.repaint();
            }
        });
        g.dispose();
    }

    public void setTerritoryOverlay(Territory territory, Color color, int alpha) {
        this.m_tileManager.setTerritoryOverlay(territory, color, alpha, this.m_data, this.m_uiContext.getMapData());
    }

    public void setTerritoryOverlayForBorder(Territory territory, Color color) {
        this.m_tileManager.setTerritoryOverlayForBorder(territory, color, this.m_data, this.m_uiContext.getMapData());
    }

    public void clearTerritoryOverlay(Territory territory) {
        this.m_tileManager.clearTerritoryOverlay(territory, this.m_data, this.m_uiContext.getMapData());
    }

    public IUIContext getUIContext() {
        return this.m_uiContext;
    }

    public void hideMouseCursor() {
        if (this.m_hiddenCursor == null) {
            this.m_hiddenCursor = this.getToolkit().createCustomCursor(new BufferedImage(1, 1, 6), new Point(0, 0), "Hidden");
        }
        this.setCursor(this.m_hiddenCursor);
    }

    public void showMouseCursor() {
        this.setCursor(this.m_uiContext.getCursor());
    }

    public Image getErrorImage() {
        return this.m_uiContext.getMapData().getErrorImage();
    }

    public Image getWarningImage() {
        return this.m_uiContext.getMapData().getWarningImage();
    }

    public Image getInfoImage() {
        return this.m_uiContext.getMapData().getInfoImage();
    }

    public Image getHelpImage() {
        return this.m_uiContext.getMapData().getHelpImage();
    }
}

