/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.ui.MapData;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.RouteDescription;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class MapRouteDrawer {
    private MapRouteDrawer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRoute(Graphics2D graphics, RouteDescription routeDescription, MapPanel view, MapData mapData, String movementLeftForCurrentUnits) {
        AffineTransform original = graphics.getTransform();
        AffineTransform newTransform = new AffineTransform();
        newTransform.scale(view.getScale(), view.getScale());
        graphics.setTransform(newTransform);
        try {
            int i;
            if (routeDescription == null) {
                return;
            }
            Route route = routeDescription.getRoute();
            if (route == null) {
                return;
            }
            graphics.setStroke(new BasicStroke(3.5f, 1, 1));
            graphics.setPaint(Color.red);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            List<Territory> territories = route.getAllTerritories();
            int numTerritories = territories.size();
            Point[] points = new Point[numTerritories];
            for (i = 0; i < numTerritories; ++i) {
                points[i] = mapData.getCenter(territories.get(i));
            }
            if (routeDescription.getStart() != null) {
                points[0] = routeDescription.getStart();
            }
            if (routeDescription.getEnd() != null && numTerritories > 1) {
                points[numTerritories - 1] = new Point(routeDescription.getEnd());
            }
            for (i = 1; i < points.length; ++i) {
                if (Math.abs(points[i].x - points[i - 1].x) <= view.getImageWidth() / 2) continue;
                if (points[i].x < points[i - 1].x) {
                    points[i].x += view.getImageWidth();
                    continue;
                }
                points[i].x -= view.getImageWidth();
            }
            int yOffset = view.getYOffset();
            int xOffset = view.getXOffset();
            ArrayList<Shape> shapes = new ArrayList<Shape>();
            for (int i2 = 0; i2 < points.length; ++i2) {
                if (i2 == 0 || i2 + 1 != points.length) {
                    Ellipse2D.Double oval = new Ellipse2D.Double(points[i2].x - 3 - xOffset, points[i2].y - yOffset - 3, 6.0, 6.0);
                    shapes.add(oval);
                }
                if (i2 + 2 < points.length) {
                    MapRouteDrawer.drawCurvedLineWithNextPoint(graphics, points[i2].x - xOffset, points[i2].y - yOffset, points[i2 + 1].x - xOffset, points[i2 + 1].y - yOffset, points[i2 + 2].x - xOffset, points[i2 + 2].y - yOffset, shapes);
                    continue;
                }
                if (i2 + 1 >= points.length) continue;
                MapRouteDrawer.drawLineSegment(graphics, points[i2].x - xOffset, points[i2].y - yOffset, points[i2 + 1].x - xOffset, points[i2 + 1].y - yOffset, shapes);
            }
            boolean scrollWrapX = mapData.scrollWrapX();
            boolean scrollWrapY = mapData.scrollWrapY();
            double translateX = -view.getImageWidth();
            double translateY = -view.getImageHeight();
            for (int i3 = 0; i3 < shapes.size(); ++i3) {
                Shape shape = (Shape)shapes.get(i3);
                MapRouteDrawer.drawWithTranslate(graphics, shape, 0.0, 0.0);
                if (scrollWrapX) {
                    MapRouteDrawer.drawWithTranslate(graphics, shape, translateX, 0.0);
                    MapRouteDrawer.drawWithTranslate(graphics, shape, -translateX, 0.0);
                }
                if (scrollWrapY) {
                    MapRouteDrawer.drawWithTranslate(graphics, shape, 0.0, translateY);
                    MapRouteDrawer.drawWithTranslate(graphics, shape, 0.0, -translateY);
                }
                if (!scrollWrapX || !scrollWrapY) continue;
                MapRouteDrawer.drawWithTranslate(graphics, shape, translateX, translateY);
                MapRouteDrawer.drawWithTranslate(graphics, shape, -translateX, -translateY);
            }
            if (numTerritories > 1) {
                Image cursorImage;
                double cursorYOffset;
                double textyOffset;
                double cursorXOffset;
                double textXOffset;
                double xDir = points[numTerritories - 1].x - points[numTerritories - 2].x;
                if (xDir > 0.0) {
                    textXOffset = 6.0;
                    cursorXOffset = -10.0;
                } else if (xDir == 0.0) {
                    textXOffset = 0.0;
                    cursorXOffset = -5.0;
                } else {
                    textXOffset = -14.0;
                    cursorXOffset = 0.0;
                }
                double yDir = points[numTerritories - 1].y - points[numTerritories - 2].y;
                if (yDir > 0.0) {
                    textyOffset = 18.0;
                    cursorYOffset = -8.0;
                } else if (yDir == 0.0) {
                    textyOffset = -24.0;
                    cursorYOffset = -2.0;
                } else {
                    textyOffset = -24.0;
                    cursorYOffset = 0.0;
                }
                String textRouteMovement = String.valueOf(numTerritories - 1);
                String unitMovementLeft = movementLeftForCurrentUnits == null || movementLeftForCurrentUnits.trim().length() <= 0 ? "" : "    /" + movementLeftForCurrentUnits;
                BufferedImage movementImage = new BufferedImage(72, 24, 2);
                Graphics2D textG2D = movementImage.createGraphics();
                textG2D.setColor(Color.YELLOW);
                textG2D.setFont(new Font("Dialog", 1, 20));
                textG2D.drawString(textRouteMovement, 0, 20);
                textG2D.setColor(new Color(33, 0, 127));
                textG2D.setFont(new Font("Dialog", 1, 16));
                textG2D.drawString(unitMovementLeft, 0, 20);
                graphics.drawImage((Image)movementImage, (int)((double)points[numTerritories - 1].x + textXOffset - (double)xOffset), (int)((double)points[numTerritories - 1].y + textyOffset - (double)yOffset), null);
                if (scrollWrapX) {
                    graphics.drawImage((Image)movementImage, (int)((double)points[numTerritories - 1].x + textXOffset - (double)xOffset + translateX), (int)((double)points[numTerritories - 1].y + textyOffset - (double)yOffset), null);
                    graphics.drawImage((Image)movementImage, (int)((double)points[numTerritories - 1].x + textXOffset - (double)xOffset - translateX), (int)((double)points[numTerritories - 1].y + textyOffset - (double)yOffset), null);
                }
                if (scrollWrapY) {
                    graphics.drawImage((Image)movementImage, (int)((double)points[numTerritories - 1].x + textXOffset - (double)xOffset), (int)((double)points[numTerritories - 1].y + textyOffset - (double)yOffset + translateY), null);
                    graphics.drawImage((Image)movementImage, (int)((double)points[numTerritories - 1].x + textXOffset - (double)xOffset), (int)((double)points[numTerritories - 1].y + textyOffset - (double)yOffset - translateY), null);
                }
                if (scrollWrapX && scrollWrapY) {
                    graphics.drawImage((Image)movementImage, (int)((double)points[numTerritories - 1].x + textXOffset - (double)xOffset + translateX), (int)((double)points[numTerritories - 1].y + textyOffset - (double)yOffset + translateY), null);
                    graphics.drawImage((Image)movementImage, (int)((double)points[numTerritories - 1].x + textXOffset - (double)xOffset - translateX), (int)((double)points[numTerritories - 1].y + textyOffset - (double)yOffset - translateY), null);
                }
                if ((cursorImage = routeDescription.getCursorImage()) != null) {
                    graphics.drawImage(cursorImage, (int)((double)points[numTerritories - 1].x + cursorXOffset - (double)xOffset), (int)((double)points[numTerritories - 1].y + cursorYOffset - (double)yOffset), null);
                    if (scrollWrapX) {
                        graphics.drawImage(cursorImage, (int)((double)points[numTerritories - 1].x + cursorXOffset - (double)xOffset + translateX), (int)((double)points[numTerritories - 1].y + cursorYOffset - (double)yOffset), null);
                        graphics.drawImage(cursorImage, (int)((double)points[numTerritories - 1].x + cursorXOffset - (double)xOffset - translateX), (int)((double)points[numTerritories - 1].y + cursorYOffset - (double)yOffset), null);
                    }
                    if (scrollWrapY) {
                        graphics.drawImage(cursorImage, (int)((double)points[numTerritories - 1].x + cursorXOffset - (double)xOffset), (int)((double)points[numTerritories - 1].y + cursorYOffset - (double)yOffset + translateY), null);
                        graphics.drawImage(cursorImage, (int)((double)points[numTerritories - 1].x + cursorXOffset - (double)xOffset), (int)((double)points[numTerritories - 1].y + cursorYOffset - (double)yOffset - translateY), null);
                    }
                    if (scrollWrapX && scrollWrapY) {
                        graphics.drawImage(cursorImage, (int)((double)points[numTerritories - 1].x + cursorXOffset - (double)xOffset + translateX), (int)((double)points[numTerritories - 1].y + cursorXOffset - (double)yOffset + translateY), null);
                        graphics.drawImage(cursorImage, (int)((double)points[numTerritories - 1].x + cursorXOffset - (double)xOffset - translateX), (int)((double)points[numTerritories - 1].y + cursorXOffset - (double)yOffset - translateY), null);
                    }
                }
            }
        }
        finally {
            graphics.setTransform(original);
        }
    }

    private static void drawWithTranslate(Graphics2D graphics, Shape shape, double translateX, double translateY) {
        if (shape instanceof Ellipse2D.Double) {
            Ellipse2D.Double elipse = (Ellipse2D.Double)shape;
            elipse = new Ellipse2D.Double(elipse.x + translateX, elipse.y + translateY, elipse.width, elipse.height);
            graphics.draw(elipse);
        }
        if (shape instanceof Polygon) {
            ((Polygon)shape).translate((int)translateX, (int)translateY);
            graphics.fill(shape);
            ((Polygon)shape).translate((int)(-translateX), (int)(-translateY));
        }
        if (shape instanceof Line2D) {
            Line2D line = (Line2D)shape;
            Point2D.Double p1 = new Point2D.Double(line.getP1().getX() + translateX, line.getP1().getY() + translateY);
            Point2D.Double p2 = new Point2D.Double(line.getP2().getX() + translateX, line.getP2().getY() + translateY);
            graphics.draw(new Line2D.Double(p1, p2));
        }
        if (shape instanceof QuadCurve2D) {
            QuadCurve2D.Double curve = (QuadCurve2D.Double)shape;
            curve = new QuadCurve2D.Double(curve.x1 + translateX, curve.y1 + translateY, curve.ctrlx + translateX, curve.ctrly + translateY, curve.x2 + translateX, curve.y2 + translateY);
            graphics.draw(curve);
        }
    }

    private static void drawCurvedLineWithNextPoint(Graphics2D graphics, double x, double y, double xx, double yy, double xxx, double yyy, List<Shape> shapes) {
        int maxControlLength = 150;
        double controlDiffx = xx - xxx;
        double controlDiffy = yy - yyy;
        if (Math.abs(controlDiffx) > 150.0 || Math.abs(controlDiffy) > 150.0) {
            double ratio = 0.0;
            try {
                ratio = Math.abs(controlDiffx / controlDiffy);
            }
            catch (ArithmeticException ex) {
                ratio = 1000.0;
            }
            if (Math.abs(controlDiffx) > Math.abs(controlDiffy)) {
                controlDiffx = controlDiffx < 0.0 ? -150.0 : 150.0;
                controlDiffy = controlDiffy < 0.0 ? (double)((int)(-150.0 / ratio)) : (double)((int)(150.0 / ratio));
            } else {
                controlDiffy = controlDiffy < 0.0 ? -150.0 : 150.0;
                controlDiffx = controlDiffx < 0.0 ? (double)((int)(-150.0 * ratio)) : (double)((int)(150.0 * ratio));
            }
        }
        double controlx = xx + controlDiffx;
        double controly = yy + controlDiffy;
        QuadCurve2D.Double curve = new QuadCurve2D.Double(x, y, controlx, controly, xx, yy);
        shapes.add(curve);
    }

    private static void drawLineSegment(Graphics2D graphics, int x, int y, int xx, int yy, List<Shape> shapes) {
        double arrowWidth = 12.0;
        double theta = 0.7f;
        int[] xPoints = new int[3];
        int[] yPoints = new int[3];
        int[] vecLine = new int[2];
        int[] vecLeft = new int[2];
        xPoints[0] = xx;
        yPoints[0] = yy;
        vecLine[0] = xPoints[0] - x;
        vecLine[1] = yPoints[0] - y;
        vecLeft[0] = -vecLine[1];
        vecLeft[1] = vecLine[0];
        double fLength = Math.sqrt(vecLine[0] * vecLine[0] + vecLine[1] * vecLine[1]);
        double th = 12.0 / (2.0 * fLength);
        double ta = 12.0 / (2.0 * (Math.tan(0.7f) / 2.0) * fLength);
        double baseX = (double)xPoints[0] - ta * (double)vecLine[0];
        double baseY = (double)yPoints[0] - ta * (double)vecLine[1];
        xPoints[1] = (int)(baseX + th * (double)vecLeft[0]);
        yPoints[1] = (int)(baseY + th * (double)vecLeft[1]);
        xPoints[2] = (int)(baseX - th * (double)vecLeft[0]);
        yPoints[2] = (int)(baseY - th * (double)vecLeft[1]);
        Line2D.Double line = new Line2D.Double(x, y, (int)baseX, (int)baseY);
        shapes.add(line);
        Polygon poly = new Polygon(xPoints, yPoints, 3);
        shapes.add(poly);
    }
}

