/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.triplea.ui.Updater;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;

public class MemoryLabel
extends JLabel {
    private static final long serialVersionUID = -6011470050936617333L;

    public MemoryLabel() {
        this.update();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    MemoryLabel.this.gc(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    MemoryLabel.this.gc(e);
                }
            }
        });
        Thread t = new Thread((Runnable)new Updater(this), "Memory Label Updater");
        t.start();
    }

    protected void gc(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new AbstractAction("Garbage Collect"){
            private static final long serialVersionUID = -8067651392155651586L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                System.gc();
                System.runFinalization();
                System.gc();
                System.runFinalization();
                System.gc();
            }
        });
        menu.show(this, e.getX(), e.getY());
    }

    public void update() {
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        long used = total - free;
        DecimalFormat format = new DecimalFormat("###.##");
        this.setText(format.format((double)used / 1000000.0) + "/" + format.format((double)total / 1000000.0) + " MB");
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.add(new MemoryLabel());
        f.pack();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

