/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.util.SoftJEditorPane;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class NotesPanel
extends JPanel {
    private static final long serialVersionUID = 2746643868463714526L;
    protected final SoftJEditorPane m_gameNotesPane;
    protected final GameData m_data;
    final JButton m_refresh = new JButton("Refresh Notes");

    public NotesPanel(GameData data, SoftJEditorPane gameNotesPane) {
        this.m_data = data;
        this.m_gameNotesPane = gameNotesPane;
        this.initLayout();
    }

    protected void initLayout() {
        this.setLayout(new BoxLayout(this, 1));
        this.m_refresh.setAlignmentY(0.5f);
        this.m_refresh.addActionListener(new AbstractAction("Refresh Notes"){
            private static final long serialVersionUID = 8439704398303765832L;

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NotesPanel.this.layoutNotes();
                    }
                });
            }
        });
        this.removeNotes();
    }

    void removeNotes() {
        this.removeAll();
        this.add(new JLabel(" "));
        this.add(this.m_refresh);
        this.add(new JLabel(" "));
    }

    void layoutNotes() {
        if (this.m_gameNotesPane == null) {
            return;
        }
        this.removeAll();
        this.add(new JLabel(" "));
        this.add(this.m_refresh);
        this.add(new JLabel(" "));
        JEditorPane pane = this.m_gameNotesPane.getComponent();
        JScrollPane scroll = new JScrollPane(pane);
        scroll.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
        this.add(scroll);
    }

    public boolean isEmpty() {
        return this.m_gameNotesPane == null || this.m_gameNotesPane.getText() == null || this.m_gameNotesPane.getText().length() <= 0;
    }
}

