/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.ui.ActionPanel;
import games.strategy.triplea.ui.DefaultMapSelectionListener;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.MapSelectionListener;
import games.strategy.triplea.ui.MouseDetails;
import games.strategy.triplea.ui.TripleAFrame;
import games.strategy.triplea.ui.UnitChooser;
import games.strategy.util.CountDownLatchHandler;
import games.strategy.util.EventThreadJOptionPane;
import games.strategy.util.Match;
import games.strategy.util.Tuple;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class PickTerritoryAndUnitsPanel
extends ActionPanel {
    private static final long serialVersionUID = -2672163347536778594L;
    private final TripleAFrame m_parent;
    private final JLabel m_actionLabel = new JLabel();
    private JButton m_doneButton = null;
    private JButton m_selectTerritoryButton = null;
    private JButton m_selectUnitsButton = null;
    private Territory m_pickedTerritory = null;
    private Set<Unit> m_pickedUnits = new HashSet<Unit>();
    private List<Territory> m_territoryChoices = null;
    private List<Unit> m_unitChoices = null;
    private int m_unitsPerPick = 1;
    private Action m_currentAction = null;
    private Territory m_currentHighlightedTerritory = null;
    private final Action DoneAction = new AbstractAction("Done"){
        private static final long serialVersionUID = -2376988913511268803L;

        @Override
        public void actionPerformed(ActionEvent event) {
            PickTerritoryAndUnitsPanel.this.m_currentAction = PickTerritoryAndUnitsPanel.this.DoneAction;
            PickTerritoryAndUnitsPanel.this.setWidgetActivation();
            if (PickTerritoryAndUnitsPanel.this.m_pickedTerritory == null || !PickTerritoryAndUnitsPanel.this.m_territoryChoices.contains(PickTerritoryAndUnitsPanel.this.m_pickedTerritory)) {
                EventThreadJOptionPane.showMessageDialog(PickTerritoryAndUnitsPanel.this.m_parent, "Must Pick An Unowned Territory", "Must Pick An Unowned Territory", 2, new CountDownLatchHandler(true));
                PickTerritoryAndUnitsPanel.this.m_currentAction = null;
                if (PickTerritoryAndUnitsPanel.this.m_currentHighlightedTerritory != null) {
                    PickTerritoryAndUnitsPanel.this.getMap().clearTerritoryOverlay(PickTerritoryAndUnitsPanel.this.m_currentHighlightedTerritory);
                }
                PickTerritoryAndUnitsPanel.this.m_currentHighlightedTerritory = null;
                PickTerritoryAndUnitsPanel.this.m_pickedTerritory = null;
                PickTerritoryAndUnitsPanel.this.setWidgetActivation();
                return;
            }
            if (!PickTerritoryAndUnitsPanel.this.m_pickedUnits.isEmpty() && !PickTerritoryAndUnitsPanel.this.m_unitChoices.containsAll(PickTerritoryAndUnitsPanel.this.m_pickedUnits)) {
                EventThreadJOptionPane.showMessageDialog(PickTerritoryAndUnitsPanel.this.m_parent, "Invalid Units?!?", "Invalid Units?!?", 2, new CountDownLatchHandler(true));
                PickTerritoryAndUnitsPanel.this.m_currentAction = null;
                PickTerritoryAndUnitsPanel.this.m_pickedUnits.clear();
                PickTerritoryAndUnitsPanel.this.setWidgetActivation();
                return;
            }
            if (PickTerritoryAndUnitsPanel.this.m_pickedUnits.size() > Math.max(0, PickTerritoryAndUnitsPanel.this.m_unitsPerPick)) {
                EventThreadJOptionPane.showMessageDialog(PickTerritoryAndUnitsPanel.this.m_parent, "Too Many Units?!?", "Too Many Units?!?", 2, new CountDownLatchHandler(true));
                PickTerritoryAndUnitsPanel.this.m_currentAction = null;
                PickTerritoryAndUnitsPanel.this.m_pickedUnits.clear();
                PickTerritoryAndUnitsPanel.this.setWidgetActivation();
                return;
            }
            if (PickTerritoryAndUnitsPanel.this.m_pickedUnits.size() < PickTerritoryAndUnitsPanel.this.m_unitsPerPick) {
                if (PickTerritoryAndUnitsPanel.this.m_unitChoices.size() < PickTerritoryAndUnitsPanel.this.m_unitsPerPick) {
                    PickTerritoryAndUnitsPanel.this.m_pickedUnits.addAll(PickTerritoryAndUnitsPanel.this.m_unitChoices);
                } else if (Match.allMatch(PickTerritoryAndUnitsPanel.this.m_unitChoices, Matches.unitIsOfType(((Unit)PickTerritoryAndUnitsPanel.this.m_unitChoices.get(0)).getType()))) {
                    PickTerritoryAndUnitsPanel.this.m_pickedUnits.clear();
                    PickTerritoryAndUnitsPanel.this.m_pickedUnits.addAll(Match.getNMatches(PickTerritoryAndUnitsPanel.this.m_unitChoices, PickTerritoryAndUnitsPanel.this.m_unitsPerPick, Match.getAlwaysMatch()));
                } else {
                    EventThreadJOptionPane.showMessageDialog(PickTerritoryAndUnitsPanel.this.m_parent, "Must Choose Units For This Territory", "Must Choose Units For This Territory", 2, new CountDownLatchHandler(true));
                    PickTerritoryAndUnitsPanel.this.m_currentAction = null;
                    PickTerritoryAndUnitsPanel.this.setWidgetActivation();
                    return;
                }
            }
            PickTerritoryAndUnitsPanel.this.m_currentAction = null;
            if (PickTerritoryAndUnitsPanel.this.m_currentHighlightedTerritory != null) {
                PickTerritoryAndUnitsPanel.this.getMap().clearTerritoryOverlay(PickTerritoryAndUnitsPanel.this.m_currentHighlightedTerritory);
            }
            PickTerritoryAndUnitsPanel.this.m_currentHighlightedTerritory = null;
            PickTerritoryAndUnitsPanel.this.setWidgetActivation();
            PickTerritoryAndUnitsPanel.this.release();
        }
    };
    private final Action SelectUnitsAction = new AbstractAction("Select Units"){
        private static final long serialVersionUID = 4745335350716395600L;

        @Override
        public void actionPerformed(ActionEvent event) {
            PickTerritoryAndUnitsPanel.this.m_currentAction = PickTerritoryAndUnitsPanel.this.SelectUnitsAction;
            PickTerritoryAndUnitsPanel.this.setWidgetActivation();
            UnitChooser unitChooser = new UnitChooser(PickTerritoryAndUnitsPanel.this.m_unitChoices, Collections.<Unit, Collection<Unit>>emptyMap(), PickTerritoryAndUnitsPanel.this.getData(), false, PickTerritoryAndUnitsPanel.this.getMap().getUIContext());
            unitChooser.setMaxAndShowMaxButton(PickTerritoryAndUnitsPanel.this.m_unitsPerPick);
            if (0 == EventThreadJOptionPane.showConfirmDialog(PickTerritoryAndUnitsPanel.this.m_parent, unitChooser, "Select Units", 2, new CountDownLatchHandler(true))) {
                PickTerritoryAndUnitsPanel.this.m_pickedUnits.clear();
                PickTerritoryAndUnitsPanel.this.m_pickedUnits.addAll(unitChooser.getSelected());
            }
            PickTerritoryAndUnitsPanel.this.m_currentAction = null;
            PickTerritoryAndUnitsPanel.this.setWidgetActivation();
        }
    };
    private final Action SelectTerritoryAction = new AbstractAction("Select Territory"){
        private static final long serialVersionUID = -8003634505955439651L;

        @Override
        public void actionPerformed(ActionEvent event) {
            PickTerritoryAndUnitsPanel.this.m_currentAction = PickTerritoryAndUnitsPanel.this.SelectTerritoryAction;
            PickTerritoryAndUnitsPanel.this.setWidgetActivation();
            PickTerritoryAndUnitsPanel.this.getMap().addMapSelectionListener(PickTerritoryAndUnitsPanel.this.MAP_SELECTION_LISTENER);
        }
    };
    private final MapSelectionListener MAP_SELECTION_LISTENER = new DefaultMapSelectionListener(){

        @Override
        public void territorySelected(Territory territory, MouseDetails md) {
            if (territory == null) {
                return;
            }
            if (PickTerritoryAndUnitsPanel.this.m_currentAction == PickTerritoryAndUnitsPanel.this.SelectTerritoryAction) {
                if (territory == null || !PickTerritoryAndUnitsPanel.this.m_territoryChoices.contains(territory)) {
                    EventThreadJOptionPane.showMessageDialog(PickTerritoryAndUnitsPanel.this.m_parent, "Must Pick An Unowned Territory (will have a white highlight)", "Must Pick An Unowned Territory", 2, new CountDownLatchHandler(true));
                    return;
                }
                PickTerritoryAndUnitsPanel.this.m_pickedTerritory = territory;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PickTerritoryAndUnitsPanel.this.getMap().removeMapSelectionListener(PickTerritoryAndUnitsPanel.this.MAP_SELECTION_LISTENER);
                        PickTerritoryAndUnitsPanel.this.m_currentAction = null;
                        PickTerritoryAndUnitsPanel.this.setWidgetActivation();
                    }
                });
            } else {
                System.err.println("Should not be able to select a territory outside of the SelectTerritoryAction.");
            }
        }

        @Override
        public void mouseMoved(Territory territory, MouseDetails md) {
            if (!PickTerritoryAndUnitsPanel.this.getActive()) {
                System.err.println("Should not be able to select a territory when inactive.");
                return;
            }
            if (territory != null && PickTerritoryAndUnitsPanel.this.m_currentAction == PickTerritoryAndUnitsPanel.this.SelectTerritoryAction && PickTerritoryAndUnitsPanel.this.m_currentHighlightedTerritory != territory) {
                if (PickTerritoryAndUnitsPanel.this.m_currentHighlightedTerritory != null) {
                    PickTerritoryAndUnitsPanel.this.getMap().clearTerritoryOverlay(PickTerritoryAndUnitsPanel.this.m_currentHighlightedTerritory);
                }
                PickTerritoryAndUnitsPanel.this.m_currentHighlightedTerritory = territory;
                if (PickTerritoryAndUnitsPanel.this.m_territoryChoices.contains(PickTerritoryAndUnitsPanel.this.m_currentHighlightedTerritory)) {
                    PickTerritoryAndUnitsPanel.this.getMap().setTerritoryOverlay(PickTerritoryAndUnitsPanel.this.m_currentHighlightedTerritory, Color.WHITE, 200);
                } else {
                    PickTerritoryAndUnitsPanel.this.getMap().setTerritoryOverlay(PickTerritoryAndUnitsPanel.this.m_currentHighlightedTerritory, Color.RED, 200);
                }
                PickTerritoryAndUnitsPanel.this.getMap().repaint();
            }
        }
    };

    public PickTerritoryAndUnitsPanel(GameData data, MapPanel map, TripleAFrame parent) {
        super(data, map);
        this.m_parent = parent;
    }

    @Override
    public String toString() {
        return "Pick Territory and Units";
    }

    @Override
    public void display(final PlayerID id) {
        super.display(id);
        this.m_pickedTerritory = null;
        this.m_pickedUnits = new HashSet<Unit>();
        this.m_currentAction = null;
        this.m_currentHighlightedTerritory = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PickTerritoryAndUnitsPanel.this.removeAll();
                PickTerritoryAndUnitsPanel.this.m_actionLabel.setText(id.getName() + " Pick Territory and Units");
                PickTerritoryAndUnitsPanel.this.add(PickTerritoryAndUnitsPanel.this.m_actionLabel);
                PickTerritoryAndUnitsPanel.this.m_selectTerritoryButton = new JButton(PickTerritoryAndUnitsPanel.this.SelectTerritoryAction);
                PickTerritoryAndUnitsPanel.this.add(PickTerritoryAndUnitsPanel.this.m_selectTerritoryButton);
                PickTerritoryAndUnitsPanel.this.m_selectUnitsButton = new JButton(PickTerritoryAndUnitsPanel.this.SelectUnitsAction);
                PickTerritoryAndUnitsPanel.this.add(PickTerritoryAndUnitsPanel.this.m_selectUnitsButton);
                PickTerritoryAndUnitsPanel.this.m_doneButton = new JButton(PickTerritoryAndUnitsPanel.this.DoneAction);
                PickTerritoryAndUnitsPanel.this.add(PickTerritoryAndUnitsPanel.this.m_doneButton);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PickTerritoryAndUnitsPanel.this.m_selectTerritoryButton.requestFocusInWindow();
                    }
                });
            }
        });
    }

    public Tuple<Territory, Set<Unit>> waitForPickTerritoryAndUnits(final List<Territory> territoryChoices, final List<Unit> unitChoices, int unitsPerPick) {
        this.m_territoryChoices = territoryChoices;
        this.m_unitChoices = unitChoices;
        this.m_unitsPerPick = unitsPerPick;
        if (this.m_currentHighlightedTerritory != null) {
            this.getMap().clearTerritoryOverlay(this.m_currentHighlightedTerritory);
            this.m_currentHighlightedTerritory = null;
        }
        if (territoryChoices.size() == 1) {
            this.m_currentHighlightedTerritory = this.m_pickedTerritory = territoryChoices.get(0);
            this.getMap().setTerritoryOverlay(this.m_currentHighlightedTerritory, Color.WHITE, 200);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (territoryChoices.size() > 1) {
                    PickTerritoryAndUnitsPanel.this.SelectTerritoryAction.actionPerformed(null);
                } else if (unitChoices.size() > 1) {
                    PickTerritoryAndUnitsPanel.this.SelectUnitsAction.actionPerformed(null);
                }
            }
        });
        this.waitForRelease();
        return new Tuple<Territory, Set<Unit>>(this.m_pickedTerritory, this.m_pickedUnits);
    }

    private void setWidgetActivation() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!PickTerritoryAndUnitsPanel.this.getActive()) {
                    PickTerritoryAndUnitsPanel.this.DoneAction.setEnabled(false);
                    PickTerritoryAndUnitsPanel.this.SelectUnitsAction.setEnabled(false);
                    PickTerritoryAndUnitsPanel.this.SelectTerritoryAction.setEnabled(false);
                } else {
                    PickTerritoryAndUnitsPanel.this.DoneAction.setEnabled(PickTerritoryAndUnitsPanel.this.m_currentAction == null);
                    PickTerritoryAndUnitsPanel.this.SelectUnitsAction.setEnabled(PickTerritoryAndUnitsPanel.this.m_currentAction == null);
                    PickTerritoryAndUnitsPanel.this.SelectTerritoryAction.setEnabled(PickTerritoryAndUnitsPanel.this.m_currentAction == null);
                }
            }
        });
    }
}

