/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.PlayerList;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.ui.PlayerChooserRenderer;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.JOptionPane;

public class PlayerChooser
extends JOptionPane {
    private static final long serialVersionUID = -7272867474891641839L;
    private JList m_list;
    private final PlayerList m_players;
    private final PlayerID m_defaultPlayer;
    private final IUIContext m_uiContext;
    private final boolean m_allowNeutral;

    public PlayerChooser(PlayerList players, IUIContext uiContext, boolean allowNeutral) {
        this(players, null, uiContext, allowNeutral);
    }

    public PlayerChooser(PlayerList players, PlayerID defaultPlayer, IUIContext uiContext, boolean allowNeutral) {
        this.setMessageType(-1);
        this.setOptionType(2);
        this.setIcon(null);
        this.m_players = players;
        this.m_defaultPlayer = defaultPlayer;
        this.m_uiContext = uiContext;
        this.m_allowNeutral = allowNeutral;
        this.createComponents();
    }

    private void createComponents() {
        ArrayList<PlayerID> players = new ArrayList<PlayerID>(this.m_players.getPlayers());
        if (this.m_allowNeutral) {
            players.add(PlayerID.NULL_PLAYERID);
        }
        this.m_list = new JList<Object>(players.toArray());
        this.m_list.setSelectionMode(0);
        this.m_list.setSelectedValue(this.m_defaultPlayer, true);
        this.m_list.setFocusable(false);
        this.m_list.setCellRenderer(new PlayerChooserRenderer(this.m_players, this.m_uiContext));
        this.m_list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    PlayerChooser.this.setValue(0);
                }
            }
        });
        this.setMessage(this.m_list);
    }

    public PlayerID getSelected() {
        if (this.getValue() != null && this.getValue().equals(0)) {
            return (PlayerID)this.m_list.getSelectedValue();
        }
        return null;
    }
}

