/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.triplea.ui.ActionPanel;
import games.strategy.triplea.ui.MapPanel;
import games.strategy.triplea.ui.ProductionRepairPanel;
import games.strategy.triplea.ui.SimpleUnitPanel;
import games.strategy.util.IntegerMap;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class RepairPanel
extends ActionPanel {
    private static final long serialVersionUID = 3045997038627313714L;
    private final JLabel actionLabel = new JLabel();
    private HashMap<Unit, IntegerMap<RepairRule>> m_repair;
    private boolean m_bid;
    private Collection<PlayerID> m_allowedPlayersToRepair;
    private final SimpleUnitPanel m_unitsPanel;
    private final JLabel m_repairdSoFar = new JLabel();
    private final JButton m_buyButton;
    private final String BUY = "Repair...";
    private final String CHANGE = "Change...";
    private final AbstractAction PURCHASE_ACTION = new AbstractAction("Buy"){
        private static final long serialVersionUID = 5572043262815077402L;

        @Override
        public void actionPerformed(ActionEvent e) {
            PlayerID player = RepairPanel.this.getCurrentPlayer();
            GameData data = RepairPanel.this.getData();
            RepairPanel.this.m_repair = ProductionRepairPanel.getProduction(player, RepairPanel.this.m_allowedPlayersToRepair, (JFrame)RepairPanel.this.getTopLevelAncestor(), data, RepairPanel.this.m_bid, RepairPanel.this.m_repair, RepairPanel.this.getMap().getUIContext());
            RepairPanel.this.m_unitsPanel.setUnitsFromRepairRuleMap(RepairPanel.this.m_repair, player, data);
            int totalValues = RepairPanel.this.getTotalValues(RepairPanel.this.m_repair);
            if (totalValues == 0) {
                RepairPanel.this.m_repairdSoFar.setText("");
                RepairPanel.this.m_buyButton.setText("Repair...");
            } else {
                RepairPanel.this.m_buyButton.setText("Change...");
                RepairPanel.this.m_repairdSoFar.setText(totalValues + MyFormatter.pluralize(" unit", totalValues) + " to be repaired:");
            }
        }
    };
    private final Action DoneAction = new AbstractAction("Done"){
        private static final long serialVersionUID = -2002286381161651398L;

        @Override
        public void actionPerformed(ActionEvent event) {
            int rVal;
            boolean hasPurchased;
            boolean bl = hasPurchased = RepairPanel.this.getTotalValues(RepairPanel.this.m_repair) != 0;
            if (!hasPurchased && (rVal = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(RepairPanel.this), "Are you sure you dont want to repair anything?", "End Purchase", 0)) != 0) {
                return;
            }
            RepairPanel.this.release();
        }
    };

    public RepairPanel(GameData data, MapPanel map) {
        super(data, map);
        this.m_unitsPanel = new SimpleUnitPanel(map.getUIContext());
        this.m_buyButton = new JButton("Repair...");
        this.m_buyButton.addActionListener(this.PURCHASE_ACTION);
    }

    @Override
    public void display(final PlayerID id) {
        super.display(id);
        this.m_repair = new HashMap();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RepairPanel.this.removeAll();
                RepairPanel.this.actionLabel.setText(id.getName() + " repair");
                RepairPanel.this.m_buyButton.setText("Repair...");
                RepairPanel.this.add(RepairPanel.this.actionLabel);
                RepairPanel.this.add(RepairPanel.this.m_buyButton);
                RepairPanel.this.add(new JButton(RepairPanel.this.DoneAction));
                RepairPanel.this.m_repairdSoFar.setText("");
                RepairPanel.this.add(Box.createVerticalStrut(9));
                RepairPanel.this.add(RepairPanel.this.m_repairdSoFar);
                RepairPanel.this.add(Box.createVerticalStrut(4));
                RepairPanel.this.m_unitsPanel.setUnitsFromRepairRuleMap(new HashMap<Unit, IntegerMap<RepairRule>>(), id, RepairPanel.this.getData());
                RepairPanel.this.add(RepairPanel.this.m_unitsPanel);
                RepairPanel.this.add(Box.createVerticalGlue());
                SwingUtilities.invokeLater(RepairPanel.this.REFRESH);
            }
        });
    }

    private void refreshActionLabelText() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RepairPanel.this.actionLabel.setText(RepairPanel.this.getCurrentPlayer().getName() + " repair " + (RepairPanel.this.m_bid ? " for bid" : ""));
            }
        });
    }

    public HashMap<Unit, IntegerMap<RepairRule>> waitForRepair(boolean bid, Collection<PlayerID> allowedPlayersToRepair) {
        this.m_bid = bid;
        this.m_allowedPlayersToRepair = allowedPlayersToRepair;
        this.refreshActionLabelText();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RepairPanel.this.PURCHASE_ACTION.actionPerformed(null);
            }
        });
        this.waitForRelease();
        return this.m_repair;
    }

    private int getTotalValues(HashMap<Unit, IntegerMap<RepairRule>> m_repair) {
        Set<Unit> units = m_repair.keySet();
        Iterator iter = units.iterator();
        int totalValues = 0;
        while (iter.hasNext()) {
            Unit unit = (Unit)iter.next();
            totalValues += m_repair.get(unit).totalValues();
        }
        return totalValues;
    }

    @Override
    public String toString() {
        return "RepairPanel";
    }
}

