/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.RepairRule;
import games.strategy.engine.data.Resource;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.UnitTypeComparator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.util.IntegerMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SimpleUnitPanel
extends JPanel {
    private static final long serialVersionUID = -3768796793775300770L;
    private final IUIContext m_uiContext;
    Comparator<ProductionRule> productionRuleComparator = new Comparator<ProductionRule>(){
        UnitTypeComparator utc = new UnitTypeComparator();

        @Override
        public int compare(ProductionRule o1, ProductionRule o2) {
            if (o1.getResults().size() == 1 && o2.getResults().size() == 1) {
                NamedAttachable n1 = o1.getResults().keySet().iterator().next();
                NamedAttachable n2 = o2.getResults().keySet().iterator().next();
                if (n1 instanceof UnitType) {
                    UnitType u1 = (UnitType)n1;
                    if (n2 instanceof UnitType) {
                        UnitType u2 = (UnitType)n2;
                        return this.utc.compare(u1, u2);
                    }
                    if (n2 instanceof Resource) {
                        return -1;
                    }
                    return n1.getName().compareTo(n2.getName());
                }
                if (n1 instanceof Resource) {
                    Resource r1 = (Resource)n1;
                    if (n2 instanceof UnitType) {
                        return 1;
                    }
                    if (n2 instanceof Resource) {
                        Resource r2 = (Resource)n2;
                        return r1.getName().compareTo(r2.getName());
                    }
                    return n1.getName().compareTo(n2.getName());
                }
                return n1.getName().compareTo(n2.getName());
            }
            if (o1.getResults().size() > o2.getResults().size()) {
                return -1;
            }
            if (o1.getResults().size() < o2.getResults().size()) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    };
    Comparator<RepairRule> repairRuleComparator = new Comparator<RepairRule>(){
        UnitTypeComparator utc = new UnitTypeComparator();

        @Override
        public int compare(RepairRule o1, RepairRule o2) {
            if (o1.getResults().size() == 1 && o2.getResults().size() == 1) {
                NamedAttachable n1 = o1.getResults().keySet().iterator().next();
                NamedAttachable n2 = o2.getResults().keySet().iterator().next();
                if (n1 instanceof UnitType) {
                    UnitType u1 = (UnitType)n1;
                    if (n2 instanceof UnitType) {
                        UnitType u2 = (UnitType)n2;
                        return this.utc.compare(u1, u2);
                    }
                    if (n2 instanceof Resource) {
                        return -1;
                    }
                    return n1.getName().compareTo(n2.getName());
                }
                if (n1 instanceof Resource) {
                    Resource r1 = (Resource)n1;
                    if (n2 instanceof UnitType) {
                        return 1;
                    }
                    if (n2 instanceof Resource) {
                        Resource r2 = (Resource)n2;
                        return r1.getName().compareTo(r2.getName());
                    }
                    return n1.getName().compareTo(n2.getName());
                }
                return n1.getName().compareTo(n2.getName());
            }
            if (o1.getResults().size() > o2.getResults().size()) {
                return -1;
            }
            if (o1.getResults().size() < o2.getResults().size()) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    };

    public SimpleUnitPanel(IUIContext uiContext) {
        this.m_uiContext = uiContext;
        this.setLayout(new BoxLayout(this, 1));
    }

    public void setUnitsFromProductionRuleMap(IntegerMap<ProductionRule> units, PlayerID player, GameData data) {
        this.removeAll();
        TreeSet<ProductionRule> productionRules = new TreeSet<ProductionRule>(this.productionRuleComparator);
        productionRules.addAll(units.keySet());
        for (ProductionRule productionRule : productionRules) {
            int quantity = units.getInt(productionRule);
            for (NamedAttachable resourceOrUnit : productionRule.getResults().keySet()) {
                this.addUnits(player, data, quantity * productionRule.getResults().getInt(resourceOrUnit), resourceOrUnit, false, false);
            }
        }
    }

    public void setUnitsFromRepairRuleMap(HashMap<Unit, IntegerMap<RepairRule>> units, PlayerID player, GameData data) {
        this.removeAll();
        Set<Unit> entries = units.keySet();
        for (Unit unit : entries) {
            IntegerMap<RepairRule> rules = units.get(unit);
            TreeSet<RepairRule> repairRules = new TreeSet<RepairRule>(this.repairRuleComparator);
            repairRules.addAll(rules.keySet());
            for (RepairRule repairRule : repairRules) {
                int quantity = rules.getInt(repairRule);
                if (!Properties.getDamageFromBombingDoneToUnitsInsteadOfTerritories(data) || !unit.getType().equals(repairRule.getResults().keySet().iterator().next())) continue;
                this.addUnits(player, data, quantity, unit.getType(), Matches.UnitHasTakenSomeBombingUnitDamage.match(unit), Matches.UnitIsDisabled.match(unit));
            }
        }
    }

    public void setUnitsFromCategories(Collection<UnitCategory> categories, GameData data) {
        this.removeAll();
        for (UnitCategory category : categories) {
            this.addUnits(category.getOwner(), data, category.getUnits().size(), category.getType(), category.hasDamageOrBombingUnitDamage(), category.getDisabled());
        }
    }

    private void addUnits(PlayerID player, GameData data, int quantity, NamedAttachable unit, boolean damaged, boolean disabled) {
        JLabel label = new JLabel();
        label.setText(" x " + quantity);
        if (unit instanceof UnitType) {
            label.setIcon(this.m_uiContext.getUnitImageFactory().getIcon((UnitType)unit, player, data, damaged, disabled));
        } else if (unit instanceof Resource) {
            label.setIcon(this.m_uiContext.getResourceImageFactory().getIcon((Resource)unit, data, true));
        }
        this.add(label);
    }
}

