/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.ui.ScrollableTextField;
import games.strategy.ui.ScrollableTextFieldListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

class SingleUnitPanel
extends JPanel {
    private static final long serialVersionUID = 5034287842323633030L;
    private final Unit m_unit;
    private final IUIContext m_context;
    private final ScrollableTextField m_textField;
    private final GameData m_data;
    private static Insets nullInsets = new Insets(0, 0, 0, 0);
    private final ScrollableTextFieldListener m_countTextFieldListener;

    public SingleUnitPanel(Unit unit, GameData data, IUIContext uiContext, ScrollableTextFieldListener textFieldListener, int max, int min, boolean showMaxAndMin) {
        this(unit, data, uiContext, textFieldListener, max, min, 0, showMaxAndMin);
    }

    public SingleUnitPanel(Unit unit, GameData data, IUIContext context, ScrollableTextFieldListener textFieldListener, int max, int min, int currentValue, boolean showMaxAndMin) {
        this.m_unit = unit;
        this.m_data = data;
        this.m_context = context;
        this.m_countTextFieldListener = textFieldListener;
        this.m_textField = new ScrollableTextField(0, 512);
        if (max >= 0) {
            this.setMax(max);
        }
        this.setMin(min);
        this.m_textField.setShowMaxAndMin(showMaxAndMin);
        TripleAUnit taUnit = TripleAUnit.get(unit);
        Image img = this.m_context.getUnitImageFactory().getImage(this.m_unit.getType(), this.m_unit.getOwner(), this.m_data, taUnit.getUnitDamage() > 0 || taUnit.getHits() > 0, taUnit.getDisabled());
        this.setCount(currentValue);
        this.setLayout(new GridBagLayout());
        JLabel label = new JLabel(new ImageIcon(img));
        this.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.m_textField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public int getCount() {
        return this.m_textField.getValue();
    }

    public void setCount(int value) {
        this.m_textField.setValue(value);
    }

    public void selectAll() {
        this.m_textField.setValue(this.m_textField.getMax());
    }

    public void selectNone() {
        this.m_textField.setValue(0);
    }

    public void setMax(int value) {
        this.m_textField.setMax(value);
    }

    public int getMax() {
        return this.m_textField.getMax();
    }

    public void setMin(int value) {
        this.m_textField.setMin(value);
    }

    public Unit getUnit() {
        return this.m_unit;
    }

    public void createComponents(JPanel panel, int yIndex) {
        panel.add((Component)this, new GridBagConstraints(0, yIndex, 1, 1, 0.0, 0.0, 17, 2, nullInsets, 0, 0));
        this.m_textField.addChangeListener(this.m_countTextFieldListener);
    }
}

