/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.events.GameDataChangeListener;
import games.strategy.engine.stats.AbstractStat;
import games.strategy.engine.stats.IStat;
import games.strategy.triplea.Properties;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.BattleCalculator;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.triplea.ui.AbstractStatPanel;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class StatPanel
extends AbstractStatPanel {
    private static final long serialVersionUID = 4340684166664492498L;
    private final StatTableModel m_dataModel;
    private final TechTableModel m_techModel;
    protected IStat[] m_stats;
    private JTable m_statsTable;
    private JTable m_techTable;
    private Image m_statsImage = null;
    protected final Map<PlayerID, ImageIcon> m_mapPlayerImage = new HashMap<PlayerID, ImageIcon>();
    protected IUIContext m_uiContext;

    public StatPanel(GameData data, IUIContext uiContext2) {
        super(data);
        this.m_uiContext = uiContext2;
        this.m_dataModel = new StatTableModel();
        this.m_techModel = new TechTableModel();
        this.fillPlayerIcons();
        this.initLayout();
    }

    @Override
    protected void initLayout() {
        boolean hasTech = !TechAdvance.getTechAdvances(this.m_data, null).isEmpty();
        this.setLayout(new GridLayout(hasTech ? 2 : 1, 1));
        this.m_statsTable = new JTable(this.m_dataModel){
            private static final long serialVersionUID = -5516554955307630864L;

            @Override
            public void print(Graphics g) {
                if (StatPanel.this.m_statsImage != null) {
                    g.drawImage(StatPanel.this.m_statsImage, 0, 0, null, null);
                }
                super.print(g);
            }
        };
        this.m_statsTable.getTableHeader().setReorderingAllowed(false);
        this.m_statsTable.getColumnModel().getColumn(0).setPreferredWidth(175);
        JScrollPane scroll = new JScrollPane(this.m_statsTable);
        this.add(scroll);
        if (!hasTech) {
            return;
        }
        this.m_techTable = new JTable(this.m_techModel);
        this.m_techTable.getTableHeader().setReorderingAllowed(false);
        this.m_techTable.getColumnModel().getColumn(0).setPreferredWidth(500);
        JComponentTableCellRenderer componentRenderer = new JComponentTableCellRenderer();
        for (int i = 1; i < this.m_techTable.getColumnCount(); ++i) {
            TableColumn column = this.m_techTable.getColumnModel().getColumn(i);
            column.setHeaderRenderer(componentRenderer);
            String player = this.m_techTable.getColumnName(i);
            JLabel value = new JLabel("", this.getIcon(player), 0);
            value.setToolTipText(player);
            column.setHeaderValue(value);
        }
        scroll = new JScrollPane(this.m_techTable);
        this.add(scroll);
    }

    @Override
    public void setGameData(GameData data) {
        this.m_data = data;
        this.m_dataModel.setGameData(data);
        this.m_techModel.setGameData(data);
        this.m_dataModel.gameDataChanged(null);
        this.m_techModel.gameDataChanged(null);
    }

    public void setStatsBgImage(Image image) {
        this.m_statsImage = image;
    }

    public JTable getStatsTable() {
        return this.m_statsTable;
    }

    protected ImageIcon getIcon(PlayerID player) {
        ImageIcon icon = this.m_mapPlayerImage.get(player);
        if (icon == null && this.m_uiContext != null) {
            Image img = this.m_uiContext.getFlagImageFactory().getSmallFlag(player);
            icon = new ImageIcon(img);
            icon.setDescription(player.getName());
            this.m_mapPlayerImage.put(player, icon);
        }
        return icon;
    }

    protected ImageIcon getIcon(String playerName) {
        PlayerID player = this.m_data.getPlayerList().getPlayerID(playerName);
        if (player == null) {
            return null;
        }
        return this.getIcon(player);
    }

    protected void fillPlayerIcons() {
        for (PlayerID p : this.m_data.getPlayerList().getPlayers()) {
            this.getIcon(p);
        }
    }

    class VPStat
    extends AbstractStat {
        VPStat() {
        }

        @Override
        public String getName() {
            return "VPs";
        }

        @Override
        public double getValue(PlayerID player, GameData data) {
            PlayerAttachment pa = PlayerAttachment.get(player);
            if (pa != null) {
                return pa.getVps();
            }
            return 0.0;
        }
    }

    class VictoryCityStat
    extends AbstractStat {
        VictoryCityStat() {
        }

        @Override
        public String getName() {
            return "VC";
        }

        @Override
        public double getValue(PlayerID player, GameData data) {
            int rVal = 0;
            for (Territory place : data.getMap().getTerritories()) {
                TerritoryAttachment ta;
                if (!place.getOwner().equals(player) || (ta = TerritoryAttachment.get(place)) == null || ta.getVictoryCity() == 0) continue;
                rVal += ta.getVictoryCity();
            }
            return rVal;
        }
    }

    class TUVStat
    extends AbstractStat {
        TUVStat() {
        }

        @Override
        public String getName() {
            return "TUV";
        }

        @Override
        public double getValue(PlayerID player, GameData data) {
            IntegerMap<UnitType> costs = BattleCalculator.getCostsForTUV(player, data);
            Match<Unit> unitIsOwnedBy = Matches.unitIsOwnedBy(player);
            int rVal = 0;
            for (Territory place : data.getMap().getTerritories()) {
                List<Unit> owned = place.getUnits().getMatches(unitIsOwnedBy);
                rVal += BattleCalculator.getTUV(owned, costs);
            }
            return rVal;
        }
    }

    class UnitsStat
    extends AbstractStat {
        UnitsStat() {
        }

        @Override
        public String getName() {
            return "Units";
        }

        @Override
        public double getValue(PlayerID player, GameData data) {
            int rVal = 0;
            Match<Unit> ownedBy = Matches.unitIsOwnedBy(player);
            for (Territory place : data.getMap().getTerritories()) {
                rVal += place.getUnits().countMatches(ownedBy);
            }
            return rVal;
        }
    }

    class PUStat
    extends AbstractStatPanel.ResourceStat {
        public PUStat() {
            super(PUStat.getResourcePUs(StatPanel.this.m_data));
        }
    }

    class ProductionStat
    extends AbstractStat {
        ProductionStat() {
        }

        @Override
        public String getName() {
            return "Production";
        }

        @Override
        public double getValue(PlayerID player, GameData data) {
            int rVal = 0;
            for (Territory place : data.getMap().getTerritories()) {
                if (!place.getOwner().equals(player) || !Matches.territoryCanCollectIncomeFrom(player, data).match(place)) continue;
                rVal += TerritoryAttachment.getProduction(place);
            }
            return rVal *= Properties.getPU_Multiplier(data);
        }
    }

    class TechTableModel
    extends AbstractTableModel
    implements GameDataChangeListener {
        private static final long serialVersionUID = -4612476336419396081L;
        private boolean isDirty = true;
        private String[] colList;
        private String[][] data;
        private Map<String, Integer> colMap = null;
        private Map<String, Integer> rowMap = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TechTableModel() {
            StatPanel.this.m_data.addDataChangeListener(this);
            this.initColList();
            this.colMap = new HashMap<String, Integer>();
            for (int i = 0; i < this.colList.length; ++i) {
                this.colMap.put(this.colList[i], i + 1);
            }
            boolean useTech = false;
            try {
                StatPanel.this.m_data.acquireReadLock();
                if (StatPanel.this.m_data.getResourceList().getResource("techTokens") != null) {
                    useTech = true;
                    this.data = new String[TechAdvance.getTechAdvances(StatPanel.this.m_data).size() + 1][this.colList.length + 2];
                } else {
                    this.data = new String[TechAdvance.getTechAdvances(StatPanel.this.m_data).size()][this.colList.length + 1];
                }
            }
            finally {
                StatPanel.this.m_data.releaseReadLock();
            }
            this.rowMap = new HashMap<String, Integer>();
            Iterator<TechAdvance> iter = TechAdvance.getTechAdvances(StatPanel.this.m_data, null).iterator();
            int row = 0;
            if (useTech) {
                this.rowMap.put("Tokens", row);
                this.data[row][0] = "Tokens";
                ++row;
            }
            while (iter.hasNext()) {
                TechAdvance tech = iter.next();
                this.rowMap.put(tech.getName(), row);
                this.data[row][0] = tech.getName();
                ++row;
            }
            this.clearAdvances();
        }

        private void clearAdvances() {
            for (int i = 0; i < this.data.length; ++i) {
                for (int j = 1; j <= this.colList.length; ++j) {
                    this.data[i][j] = "";
                }
            }
        }

        private void initColList() {
            ArrayList<PlayerID> players = new ArrayList<PlayerID>(StatPanel.this.m_data.getPlayerList().getPlayers());
            this.colList = new String[players.size()];
            for (int i = 0; i < players.size(); ++i) {
                this.colList[i] = ((PlayerID)players.get(i)).getName();
            }
            Arrays.sort(this.colList, 0, players.size());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update() {
            this.clearAdvances();
            GameData gameData = StatPanel.this.m_data;
            gameData.acquireReadLock();
            try {
                for (PlayerID pid : gameData.getPlayerList().getPlayers()) {
                    if (this.colMap.get(pid.getName()) == null) {
                        throw new IllegalStateException("Unexpected player in GameData.getPlayerList()" + pid.getName());
                    }
                    int col = this.colMap.get(pid.getName());
                    int row = 0;
                    if (StatPanel.this.m_data.getResourceList().getResource("techTokens") != null) {
                        Integer tokens = pid.getResources().getQuantity("techTokens");
                        this.data[row][col] = tokens.toString();
                    }
                    Iterator<TechAdvance> advancesAll = TechAdvance.getTechAdvances(StatPanel.this.m_data).iterator();
                    List<TechAdvance> has = TechAdvance.getTechAdvances(StatPanel.this.m_data, pid);
                    while (advancesAll.hasNext()) {
                        TechAdvance advance = advancesAll.next();
                        if (has.contains(advance)) continue;
                        row = this.rowMap.get(advance.getName());
                        this.data[row][col] = "-";
                    }
                    for (TechAdvance advance : TechTracker.getCurrentTechAdvances(pid, StatPanel.this.m_data)) {
                        row = this.rowMap.get(advance.getName());
                        this.data[row][col] = "X";
                    }
                }
            }
            finally {
                gameData.releaseReadLock();
            }
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "Technology";
            }
            return this.colList[col - 1];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.isDirty) {
                this.update();
                this.isDirty = false;
            }
            return this.data[row][col];
        }

        @Override
        public int getColumnCount() {
            return this.colList.length + 1;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public void gameDataChanged(Change aChange) {
            this.isDirty = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatPanel.this.repaint();
                }
            });
        }

        public void setGameData(GameData data) {
            StatPanel.this.m_data.removeDataChangeListener(this);
            StatPanel.this.m_data = data;
            StatPanel.this.m_data.addDataChangeListener(this);
            this.isDirty = true;
        }
    }

    class StatTableModel
    extends AbstractTableModel
    implements GameDataChangeListener {
        private static final long serialVersionUID = -6156153062049822444L;
        private boolean m_isDirty = true;
        private String[][] m_collectedData;

        public StatTableModel() {
            this.setStatCollums();
            StatPanel.this.m_data.addDataChangeListener(this);
            this.m_isDirty = true;
        }

        public void setStatCollums() {
            ArrayList<IStat> stats;
            StatPanel.this.m_stats = new IStat[]{new PUStat(), new ProductionStat(), new UnitsStat(), new TUVStat()};
            if (Match.someMatch(StatPanel.this.m_data.getMap().getTerritories(), Matches.TerritoryIsVictoryCity)) {
                stats = new ArrayList<IStat>(Arrays.asList(StatPanel.this.m_stats));
                stats.add(new VictoryCityStat());
                StatPanel.this.m_stats = stats.toArray(new IStat[stats.size()]);
            }
            if (StatPanel.this.m_data.getProperties().get("Pacific Theater", false)) {
                stats = new ArrayList<IStat>(Arrays.asList(StatPanel.this.m_stats));
                stats.add(new VPStat());
                StatPanel.this.m_stats = stats.toArray(new IStat[stats.size()]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void loadData() {
            StatPanel.this.m_data.acquireReadLock();
            try {
                int i;
                List<PlayerID> players = StatPanel.this.getPlayers();
                Collection<String> alliances = StatPanel.this.getAlliances();
                this.m_collectedData = new String[players.size() + alliances.size()][StatPanel.this.m_stats.length + 1];
                int row = 0;
                for (PlayerID player : players) {
                    this.m_collectedData[row][0] = player.getName();
                    for (i = 0; i < StatPanel.this.m_stats.length; ++i) {
                        this.m_collectedData[row][i + 1] = StatPanel.this.m_stats[i].getFormatter().format(StatPanel.this.m_stats[i].getValue(player, StatPanel.this.m_data));
                    }
                    ++row;
                }
                Iterator<String> allianceIterator = alliances.iterator();
                while (allianceIterator.hasNext()) {
                    String alliance;
                    this.m_collectedData[row][0] = alliance = allianceIterator.next();
                    for (i = 0; i < StatPanel.this.m_stats.length; ++i) {
                        this.m_collectedData[row][i + 1] = StatPanel.this.m_stats[i].getFormatter().format(StatPanel.this.m_stats[i].getValue(alliance, StatPanel.this.m_data));
                    }
                    ++row;
                }
            }
            finally {
                StatPanel.this.m_data.releaseReadLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void gameDataChanged(Change aChange) {
            StatTableModel statTableModel = this;
            synchronized (statTableModel) {
                this.m_isDirty = true;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatPanel.this.repaint();
                }
            });
        }

        @Override
        public synchronized Object getValueAt(int row, int col) {
            if (this.m_isDirty) {
                this.loadData();
                this.m_isDirty = false;
            }
            return this.m_collectedData[row][col];
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "Player";
            }
            return StatPanel.this.m_stats[col - 1].getName();
        }

        @Override
        public int getColumnCount() {
            return StatPanel.this.m_stats.length + 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int getRowCount() {
            if (!this.m_isDirty) {
                return this.m_collectedData.length;
            }
            StatPanel.this.m_data.acquireReadLock();
            try {
                int n = StatPanel.this.m_data.getPlayerList().size() + StatPanel.this.getAlliances().size();
                return n;
            }
            finally {
                StatPanel.this.m_data.releaseReadLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setGameData(GameData data) {
            StatTableModel statTableModel = this;
            synchronized (statTableModel) {
                StatPanel.this.m_data.removeDataChangeListener(this);
                StatPanel.this.m_data = data;
                StatPanel.this.m_data.addDataChangeListener(this);
                this.m_isDirty = true;
            }
            StatPanel.this.repaint();
        }
    }

    class JComponentTableCellRenderer
    implements TableCellRenderer {
        JComponentTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (JComponent)value;
        }
    }
}

