/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.data.PlayerID;
import games.strategy.triplea.delegate.TechTracker;
import games.strategy.ui.ScrollableTextField;
import games.strategy.ui.ScrollableTextFieldListener;
import games.strategy.util.IntegerMap;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

class TechTokenPanel
extends JPanel {
    private static final long serialVersionUID = 332026624893335993L;
    int m_totalPUs;
    int m_playerPUs;
    final ScrollableTextField m_playerPUField;
    PlayerID m_player;
    JLabel m_left = new JLabel();
    JLabel m_right = new JLabel();
    JLabel m_totalCost = new JLabel();
    ScrollableTextField m_textField;
    HashMap<PlayerID, ScrollableTextField> m_whoPaysTextFields = null;
    private final ScrollableTextFieldListener m_listener = new ScrollableTextFieldListener(){

        @Override
        public void changedValue(ScrollableTextField stf) {
            TechTokenPanel.this.setLabel(TechTracker.getTechCost(TechTokenPanel.this.m_player) * TechTokenPanel.this.m_textField.getValue());
            TechTokenPanel.this.setWidgetActivation();
        }
    };

    TechTokenPanel(int PUs, int currTokens, PlayerID player, Collection<PlayerID> helpPay) {
        this.m_playerPUs = PUs;
        this.m_totalPUs = PUs;
        if (helpPay != null && !helpPay.isEmpty()) {
            helpPay.remove(player);
            for (PlayerID p : helpPay) {
                this.m_totalPUs += p.getResources().getQuantity("PUs");
            }
        }
        this.m_playerPUField = new ScrollableTextField(0, this.m_totalPUs);
        this.m_playerPUField.setEnabled(false);
        this.setLayout(new GridBagLayout());
        this.m_player = player;
        JLabel title = new JLabel("Select the number of tech tokens to purchase:");
        title.setBorder(new EmptyBorder(5, 5, 5, 5));
        int techCost = TechTracker.getTechCost(this.m_player);
        this.m_textField = new ScrollableTextField(0, this.m_totalPUs / techCost);
        this.m_textField.addChangeListener(this.m_listener);
        JLabel costLabel = new JLabel("x" + techCost + " cost per token");
        this.setLabel(0);
        this.setTokens(currTokens);
        boolean space = false;
        this.add((Component)title, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_textField, new GridBagConstraints(0, 1, 1, 1, 0.5, 1.0, 13, 0, new Insets(8, 10, 0, 0), 0, 0));
        this.add((Component)costLabel, new GridBagConstraints(1, 1, 1, 1, 0.5, 1.0, 17, 0, new Insets(8, 5, 0, 2), 0, 0));
        this.add((Component)this.m_left, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_right, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 0, new Insets(10, 130, 0, 0), 0, 0));
        this.add((Component)this.m_totalCost, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        if (helpPay != null && !helpPay.isEmpty()) {
            if (this.m_whoPaysTextFields == null) {
                this.m_whoPaysTextFields = new HashMap();
            }
            helpPay.remove(player);
            int row = 4;
            this.add((Component)new JLabel("Nations Paying How Much:"), new GridBagConstraints(0, row, 1, 1, 0.5, 1.0, 13, 0, new Insets(30, 6, 6, 6), 0, 0));
            this.add((Component)new JLabel(player.getName()), new GridBagConstraints(0, ++row, 1, 1, 0.5, 1.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
            this.add((Component)this.m_playerPUField, new GridBagConstraints(1, row, 1, 1, 0.5, 1.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
            this.add((Component)new JLabel("PUs"), new GridBagConstraints(2, row, 1, 1, 0.5, 1.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
            ++row;
            for (PlayerID p : helpPay) {
                int helperPUs = p.getResources().getQuantity("PUs");
                if (helperPUs <= 0) continue;
                ScrollableTextField whoPaysTextField = new ScrollableTextField(0, helperPUs);
                whoPaysTextField.addChangeListener(this.setWidgetAction());
                this.m_whoPaysTextFields.put(p, whoPaysTextField);
                this.add((Component)new JLabel(p.getName()), new GridBagConstraints(0, row, 1, 1, 0.5, 1.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
                this.add((Component)whoPaysTextField, new GridBagConstraints(1, row, 1, 1, 0.5, 1.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
                this.add((Component)new JLabel("PUs"), new GridBagConstraints(2, row, 1, 1, 0.5, 1.0, 10, 0, new Insets(6, 6, 6, 6), 0, 0));
                ++row;
            }
        }
    }

    private void setWidgetActivation() {
        if (this.m_whoPaysTextFields == null || this.m_whoPaysTextFields.isEmpty()) {
            return;
        }
        int cost = TechTracker.getTechCost(this.m_player) * this.m_textField.getValue();
        int totalPaidByOthers = 0;
        for (Map.Entry<PlayerID, ScrollableTextField> entry : this.m_whoPaysTextFields.entrySet()) {
            totalPaidByOthers += Math.max(0, entry.getValue().getValue());
        }
        int totalPaidByPlayer = Math.max(0, cost - totalPaidByOthers);
        int amountOver = -1 * (this.m_playerPUs - totalPaidByPlayer);
        Iterator<Map.Entry<PlayerID, ScrollableTextField>> otherPayers = this.m_whoPaysTextFields.entrySet().iterator();
        while (amountOver > 0 && otherPayers.hasNext()) {
            int max;
            Map.Entry<PlayerID, ScrollableTextField> entry = otherPayers.next();
            int current = entry.getValue().getValue();
            if (current >= (max = entry.getValue().getMax())) continue;
            int canAdd = Math.min(max - current, amountOver);
            amountOver -= canAdd;
            entry.getValue().setValue(current += canAdd);
        }
        totalPaidByOthers = 0;
        for (Map.Entry<PlayerID, ScrollableTextField> entry : this.m_whoPaysTextFields.entrySet()) {
            totalPaidByOthers += Math.max(0, entry.getValue().getValue());
        }
        int amountUnder = -1 * (cost - totalPaidByOthers);
        Iterator<Map.Entry<PlayerID, ScrollableTextField>> otherPayers2 = this.m_whoPaysTextFields.entrySet().iterator();
        while (amountUnder > 0 && otherPayers2.hasNext()) {
            Map.Entry<PlayerID, ScrollableTextField> entry = otherPayers2.next();
            int current = entry.getValue().getValue();
            if (current <= 0) continue;
            int canSubtract = Math.min(current, amountUnder);
            amountUnder -= canSubtract;
            entry.getValue().setValue(current -= canSubtract);
        }
        this.m_playerPUField.setValue(Math.max(0, Math.min(this.m_playerPUs, totalPaidByPlayer)));
    }

    private void setLabel(int cost) {
        this.m_left.setText("Left to Spend:  " + (this.m_totalPUs - cost));
        this.m_totalCost.setText("Total Cost:  " + cost);
    }

    private void setTokens(int tokens) {
        this.m_right.setText("Current token count:  " + tokens);
    }

    private final ScrollableTextFieldListener setWidgetAction() {
        return new ScrollableTextFieldListener(){

            @Override
            public void changedValue(ScrollableTextField stf) {
                TechTokenPanel.this.setWidgetActivation();
            }
        };
    }

    public int getValue() {
        return this.m_textField.getValue();
    }

    public IntegerMap<PlayerID> getWhoPaysHowMuch() {
        int techCost = TechTracker.getTechCost(this.m_player);
        int numberOfTechRolls = this.getValue();
        int totalCost = numberOfTechRolls * techCost;
        IntegerMap<PlayerID> whoPaysHowMuch = new IntegerMap<PlayerID>();
        if (this.m_whoPaysTextFields == null || this.m_whoPaysTextFields.isEmpty()) {
            whoPaysHowMuch.put(this.m_player, totalCost);
        } else {
            int runningTotal = 0;
            for (Map.Entry<PlayerID, ScrollableTextField> entry : this.m_whoPaysTextFields.entrySet()) {
                int value = entry.getValue().getValue();
                whoPaysHowMuch.put(entry.getKey(), value);
                runningTotal += value;
            }
            if (!this.m_whoPaysTextFields.containsKey(this.m_player)) {
                whoPaysHowMuch.put(this.m_player, Math.max(0, totalCost - runningTotal));
            }
        }
        return whoPaysHowMuch;
    }
}

