/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.triplea.ResourceLoader;
import games.strategy.triplea.ui.AbstractUIContext;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Properties;

public class UserActionText {
    private static final String PROPERTY_FILE = "actionstext.properties";
    private static UserActionText s_text = null;
    private static long s_timestamp = 0L;
    private final Properties m_properties = new Properties();
    private static final String BUTTON = "BUTTON";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String NOTIFICATION_SUCCESS = "NOTIFICATION_SUCCESS";
    private static final String OTHER_NOTIFICATION_SUCCESS = "OTHER_NOTIFICATION_SUCCESS";
    private static final String NOTIFICATION_FAILURE = "NOTIFICATION_FAILURE";
    private static final String OTHER_NOTIFICATION_FAILURE = "OTHER_NOTIFICATION_FAILURE";
    private static final String ACCEPT_QUESTION = "ACCEPT_QUESTION";

    protected UserActionText() {
        ResourceLoader loader = AbstractUIContext.getResourceLoader();
        URL url = loader.getResource(PROPERTY_FILE);
        if (url != null) {
            try {
                this.m_properties.load(url.openStream());
            }
            catch (IOException e) {
                System.out.println("Error reading actionstext.properties : " + e);
            }
        }
    }

    public static UserActionText getInstance() {
        if (s_text == null || Calendar.getInstance().getTimeInMillis() > s_timestamp + 10000L) {
            s_text = new UserActionText();
            s_timestamp = Calendar.getInstance().getTimeInMillis();
        }
        return s_text;
    }

    private String getString(String value) {
        return this.m_properties.getProperty(value, "NO: " + value + " set.");
    }

    private String getMessage(String actionKey, String messageKey) {
        return this.getString(actionKey + "." + messageKey);
    }

    public String getButtonText(String actionKey) {
        return this.getMessage(actionKey, BUTTON);
    }

    public String getDescription(String actionKey) {
        return this.getMessage(actionKey, DESCRIPTION);
    }

    public String getNotificationSucccess(String actionKey) {
        return this.getMessage(actionKey, NOTIFICATION_SUCCESS);
    }

    public String getNotificationSuccessOthers(String actionKey) {
        return this.getMessage(actionKey, OTHER_NOTIFICATION_SUCCESS);
    }

    public String getNotificationFailure(String actionKey) {
        return this.getMessage(actionKey, NOTIFICATION_FAILURE);
    }

    public String getNotificationFailureOthers(String actionKey) {
        return this.getMessage(actionKey, OTHER_NOTIFICATION_FAILURE);
    }

    public String getAcceptanceQuestion(String actionKey) {
        return this.getMessage(actionKey, ACCEPT_QUESTION);
    }
}

