/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui;

import games.strategy.engine.framework.VerifiedRandomNumbers;
import games.strategy.engine.random.RemoteRandom;
import games.strategy.triplea.formatter.MyFormatter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class VerifiedRandomNumbersDialog
extends JDialog {
    private static final long serialVersionUID = 439577498545812164L;

    public VerifiedRandomNumbersDialog(Component parent) {
        super(JOptionPane.getFrameForComponent(parent), "Verified Random Numbers", false);
        this.init();
        this.pack();
    }

    private void init() {
        List<VerifiedRandomNumbers> verified = RemoteRandom.getVerifiedRandomNumbers();
        Object[][] tableValues = this.getTableValues(verified);
        DefaultTableModel model = new DefaultTableModel(tableValues, new String[]{"Reason", "Dice Rolls"}){
            private static final long serialVersionUID = 8876974698508561554L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        JTable table = new JTable(model);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(table), "Center");
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttons, "South");
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VerifiedRandomNumbersDialog.this.setVisible(false);
            }
        });
        buttons.add(close);
    }

    private String[][] getTableValues(List<VerifiedRandomNumbers> verified) {
        if (verified.isEmpty()) {
            return new String[][]{{"", ""}};
        }
        String[][] tableValues = new String[verified.size()][2];
        for (int i = 0; i < verified.size(); ++i) {
            VerifiedRandomNumbers number = verified.get(i);
            tableValues[i][0] = number.getAnnotation();
            tableValues[i][1] = MyFormatter.asDice(number.getValues());
        }
        return tableValues;
    }
}

