/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.screen;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.ui.MapData;
import games.strategy.triplea.ui.screen.IDrawable;
import games.strategy.triplea.ui.screen.TerritoryDrawable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;

class LandTerritoryDrawable
extends TerritoryDrawable
implements IDrawable {
    private final String m_territoryName;

    public LandTerritoryDrawable(String territoryName) {
        this.m_territoryName = territoryName;
    }

    @Override
    public void draw(Rectangle bounds, GameData data, Graphics2D graphics, MapData mapData, AffineTransform unscaled, AffineTransform scaled) {
        Territory territory = data.getMap().getTerritory(this.m_territoryName);
        TerritoryAttachment ta = TerritoryAttachment.get(territory);
        Color territoryColor = ta != null && ta.getIsImpassible() ? mapData.impassibleColor() : mapData.getPlayerColor(territory.getOwner().getName());
        this.draw(bounds, graphics, mapData, unscaled, scaled, territory, territoryColor);
    }

    @Override
    public int getLevel() {
        return 2;
    }
}

