/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.screen;

import games.strategy.engine.data.GameData;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.ui.MapData;
import games.strategy.triplea.ui.screen.IDrawable;
import games.strategy.triplea.util.Stopwatch;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.logging.Level;

abstract class MapTileDrawable
implements IDrawable {
    protected boolean m_noImage = false;
    protected final int m_x;
    protected final int m_y;
    protected final IUIContext m_uiContext;
    protected boolean m_unscaled;

    public MapTileDrawable(int x, int y, IUIContext uiContext) {
        this.m_x = x;
        this.m_y = y;
        this.m_uiContext = uiContext;
        this.m_unscaled = false;
    }

    public abstract MapTileDrawable getUnscaledCopy();

    protected abstract Image getImage();

    @Override
    public void draw(Rectangle bounds, GameData data, Graphics2D graphics, MapData mapData, AffineTransform unscaled, AffineTransform scaled) {
        Image img = this.getImage();
        if (img == null) {
            return;
        }
        Object oldRenderingValue = graphics.getRenderingHint(RenderingHints.KEY_RENDERING);
        Object oldAlphaValue = graphics.getRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION);
        Object oldInterpolationValue = graphics.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        if (unscaled != null) {
            graphics.setTransform(unscaled);
        }
        Stopwatch drawStopWatch = new Stopwatch(s_logger, Level.FINEST, "drawing tile images");
        graphics.drawImage(img, this.m_x * 256 - bounds.x, this.m_y * 256 - bounds.y, null);
        drawStopWatch.done();
        if (unscaled != null) {
            graphics.setTransform(scaled);
        }
        if (oldAlphaValue == null) {
            graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, oldAlphaValue);
        }
        if (oldRenderingValue == null) {
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, oldRenderingValue);
        }
        if (oldInterpolationValue == null) {
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, oldInterpolationValue);
        }
    }
}

