/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.triplea.ui.screen;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.TerritoryEffectHelper;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.ui.MapData;
import games.strategy.triplea.ui.screen.BaseMapDrawable;
import games.strategy.triplea.ui.screen.BattleDrawable;
import games.strategy.triplea.ui.screen.BlockadeZoneDrawable;
import games.strategy.triplea.ui.screen.CapitolMarkerDrawable;
import games.strategy.triplea.ui.screen.ConvoyZoneDrawable;
import games.strategy.triplea.ui.screen.DecoratorDrawable;
import games.strategy.triplea.ui.screen.DrawableComparator;
import games.strategy.triplea.ui.screen.IDrawable;
import games.strategy.triplea.ui.screen.KamikazeZoneDrawable;
import games.strategy.triplea.ui.screen.LandTerritoryDrawable;
import games.strategy.triplea.ui.screen.MapTileDrawable;
import games.strategy.triplea.ui.screen.OptionalExtraTerritoryBordersDrawable;
import games.strategy.triplea.ui.screen.ReliefMapDrawable;
import games.strategy.triplea.ui.screen.SeaZoneOutlineDrawable;
import games.strategy.triplea.ui.screen.TerritoryEffectDrawable;
import games.strategy.triplea.ui.screen.TerritoryNameDrawable;
import games.strategy.triplea.ui.screen.TerritoryOverLayDrawable;
import games.strategy.triplea.ui.screen.Tile;
import games.strategy.triplea.ui.screen.UnitsDrawer;
import games.strategy.triplea.ui.screen.VCDrawable;
import games.strategy.triplea.util.UnitCategory;
import games.strategy.triplea.util.UnitSeperator;
import games.strategy.ui.Util;
import games.strategy.util.Tuple;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TileManager {
    private static final Logger s_logger = Logger.getLogger(TileManager.class.getName());
    public static final int TILE_SIZE = 256;
    private List<Tile> m_tiles = new ArrayList<Tile>();
    private final Lock m_lock = new ReentrantLock();
    private final Map<String, IDrawable> m_territoryOverlays = new HashMap<String, IDrawable>();
    private final Map<String, Set<IDrawable>> m_territoryDrawables = new HashMap<String, Set<IDrawable>>();
    private final Map<String, Set<Tile>> m_territoryTiles = new HashMap<String, Set<Tile>>();
    private final Collection<UnitsDrawer> m_allUnitDrawables = new ArrayList<UnitsDrawer>();
    private final IUIContext m_uiContext;

    public TileManager(IUIContext uiContext) {
        this.m_uiContext = uiContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tile> getTiles(Rectangle2D bounds) {
        MapData mapData = this.m_uiContext.getMapData();
        Dimension mapDimensions = mapData.getMapDimensions();
        boolean testXshift = mapData.scrollWrapX() && (bounds.getMaxX() > (double)mapDimensions.width || bounds.getMinX() < 0.0);
        boolean testYshift = mapData.scrollWrapY() && (bounds.getMaxY() > (double)mapDimensions.height || bounds.getMinY() < 0.0);
        Rectangle boundsXshift = null;
        if (testXshift) {
            boundsXshift = bounds.getMinX() < 0.0 ? new Rectangle((int)bounds.getMinX() + mapDimensions.width, (int)bounds.getMinY(), (int)bounds.getWidth(), (int)bounds.getHeight()) : new Rectangle((int)bounds.getMinX() - mapDimensions.width, (int)bounds.getMinY(), (int)bounds.getWidth(), (int)bounds.getHeight());
        }
        Rectangle boundsYshift = null;
        if (testYshift) {
            boundsYshift = bounds.getMinY() < 0.0 ? new Rectangle((int)bounds.getMinX(), (int)bounds.getMinY() + mapDimensions.height, (int)bounds.getWidth(), (int)bounds.getHeight()) : new Rectangle((int)bounds.getMinX(), (int)bounds.getMinY() - mapDimensions.height, (int)bounds.getWidth(), (int)bounds.getHeight());
        }
        Tile.S_TILE_LOCKUTIL.acquireLock(this.m_lock);
        try {
            Rectangle tileBounds;
            ArrayList<Tile> rVal = new ArrayList<Tile>();
            for (Tile tile : this.m_tiles) {
                tileBounds = tile.getBounds();
                if (!bounds.contains(tileBounds) && !tileBounds.intersects(bounds)) continue;
                rVal.add(tile);
            }
            if (boundsXshift != null) {
                for (Tile tile : this.m_tiles) {
                    tileBounds = tile.getBounds();
                    if (!boundsXshift.contains((Rectangle2D)tileBounds) && !tileBounds.intersects((Rectangle2D)boundsXshift)) continue;
                    rVal.add(tile);
                }
            }
            if (boundsYshift != null) {
                for (Tile tile : this.m_tiles) {
                    tileBounds = tile.getBounds();
                    if (!boundsYshift.contains((Rectangle2D)tileBounds) && !tileBounds.intersects((Rectangle2D)boundsYshift)) continue;
                    rVal.add(tile);
                }
            }
            ArrayList<Tile> arrayList = rVal;
            return arrayList;
        }
        finally {
            Tile.S_TILE_LOCKUTIL.releaseLock(this.m_lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UnitsDrawer> getUnitDrawables() {
        Tile.S_TILE_LOCKUTIL.acquireLock(this.m_lock);
        try {
            ArrayList<UnitsDrawer> arrayList = new ArrayList<UnitsDrawer>(this.m_allUnitDrawables);
            return arrayList;
        }
        finally {
            Tile.S_TILE_LOCKUTIL.releaseLock(this.m_lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTiles(Rectangle bounds, GameData data, MapData mapData) {
        Tile.S_TILE_LOCKUTIL.acquireLock(this.m_lock);
        try {
            this.m_tiles = new ArrayList<Tile>();
            int x = 0;
            while (x * 256 < bounds.width) {
                int y = 0;
                while (y * 256 < bounds.height) {
                    this.m_tiles.add(new Tile(new Rectangle(x * 256, y * 256, 256, 256), x, y, this.m_uiContext.getScale()));
                    ++y;
                }
                ++x;
            }
        }
        finally {
            Tile.S_TILE_LOCKUTIL.releaseLock(this.m_lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTiles(GameData data, MapData mapData) {
        data.acquireReadLock();
        try {
            Tile.S_TILE_LOCKUTIL.acquireLock(this.m_lock);
            try {
                for (Tile tile : this.m_tiles) {
                    tile.clear();
                    int x = tile.getBounds().x / 256;
                    int y = tile.getBounds().y / 256;
                    tile.addDrawable(new BaseMapDrawable(x, y, this.m_uiContext));
                    tile.addDrawable(new ReliefMapDrawable(x, y, this.m_uiContext));
                }
                for (Territory territory : data.getMap().getTerritories()) {
                    this.clearTerritory(territory);
                    this.drawTerritory(territory, data, mapData);
                }
                Map<Image, List<Point>> decorations = mapData.getDecorations();
                for (Image img : decorations.keySet()) {
                    for (Point p : decorations.get(img)) {
                        DecoratorDrawable drawable = new DecoratorDrawable(p, img);
                        Rectangle bounds = new Rectangle(p.x, p.y, img.getWidth(null), img.getHeight(null));
                        for (Tile t : this.getTiles(bounds)) {
                            t.addDrawable(drawable);
                        }
                    }
                }
            }
            finally {
                Tile.S_TILE_LOCKUTIL.releaseLock(this.m_lock);
            }
        }
        finally {
            data.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTerritories(Collection<Territory> territories, GameData data, MapData mapData) {
        data.acquireReadLock();
        try {
            Tile.S_TILE_LOCKUTIL.acquireLock(this.m_lock);
            try {
                if (territories == null) {
                    return;
                }
                for (Territory territory : territories) {
                    this.updateTerritory(territory, data, mapData);
                }
            }
            finally {
                Tile.S_TILE_LOCKUTIL.releaseLock(this.m_lock);
            }
        }
        finally {
            data.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTerritory(Territory territory, GameData data, MapData mapData) {
        data.acquireReadLock();
        try {
            Tile.S_TILE_LOCKUTIL.acquireLock(this.m_lock);
            try {
                s_logger.log(Level.FINER, "Updating " + territory.getName());
                this.clearTerritory(territory);
                this.drawTerritory(territory, data, mapData);
            }
            finally {
                Tile.S_TILE_LOCKUTIL.releaseLock(this.m_lock);
            }
        }
        finally {
            data.releaseReadLock();
        }
    }

    private void clearTerritory(Territory territory) {
        if (this.m_territoryTiles.get(territory.getName()) == null) {
            return;
        }
        Collection drawables = this.m_territoryDrawables.get(territory.getName());
        if (drawables == null || drawables.isEmpty()) {
            return;
        }
        for (Tile tile : this.m_territoryTiles.get(territory.getName())) {
            tile.removeDrawables(drawables);
        }
        this.m_allUnitDrawables.removeAll(drawables);
    }

    private void drawTerritory(Territory territory, GameData data, MapData mapData) {
        HashSet<Tile> drawnOn = new HashSet<Tile>();
        HashSet<IDrawable> drawing = new HashSet<IDrawable>();
        if (this.m_territoryOverlays.get(territory.getName()) != null) {
            drawing.add(this.m_territoryOverlays.get(territory.getName()));
        }
        if (this.m_uiContext.getShowTerritoryEffects()) {
            this.drawTerritoryEffects(territory, data, mapData, drawnOn, drawing);
        }
        if (this.m_uiContext.getShowUnits()) {
            this.drawUnits(territory, data, mapData, drawnOn, drawing);
        }
        drawing.add(new BattleDrawable(territory.getName()));
        TerritoryAttachment ta = TerritoryAttachment.get(territory);
        if (!territory.isWater()) {
            drawing.add(new LandTerritoryDrawable(territory.getName()));
        } else {
            if (ta != null) {
                if (ta.getKamikazeZone()) {
                    drawing.add(new KamikazeZoneDrawable(territory.getOwner(), territory, this.m_uiContext));
                }
                if (ta.getBlockadeZone()) {
                    drawing.add(new BlockadeZoneDrawable(territory, this.m_uiContext));
                }
                if (ta.getConvoyRoute()) {
                    drawing.add(new ConvoyZoneDrawable(territory.getOwner(), territory, this.m_uiContext));
                }
                if (ta.getProduction() > 0) {
                    drawing.add(new ConvoyZoneDrawable(territory.getOwner(), territory, this.m_uiContext));
                }
            }
            drawing.add(new SeaZoneOutlineDrawable(territory.getName()));
        }
        IDrawable.OptionalExtraBorderLevel optionalBorderLevel = this.m_uiContext.getDrawTerritoryBordersAgain();
        if (optionalBorderLevel != IDrawable.OptionalExtraBorderLevel.LOW) {
            drawing.add(new OptionalExtraTerritoryBordersDrawable(territory.getName(), optionalBorderLevel));
        }
        drawing.add(new TerritoryNameDrawable(territory.getName(), this.m_uiContext));
        if (ta != null && ta.isCapital() && mapData.drawCapitolMarkers()) {
            PlayerID capitalOf = data.getPlayerList().getPlayerID(ta.getCapital());
            drawing.add(new CapitolMarkerDrawable(capitalOf, territory, this.m_uiContext));
        }
        if (ta != null && ta.getVictoryCity() != 0) {
            drawing.add(new VCDrawable(territory));
        }
        for (Tile tile : this.getTiles(mapData.getBoundingRect(territory.getName()))) {
            drawnOn.add(tile);
            tile.addDrawables(drawing);
        }
        this.m_territoryDrawables.put(territory.getName(), drawing);
        this.m_territoryTiles.put(territory.getName(), drawnOn);
    }

    private void drawTerritoryEffects(Territory territory, GameData data, MapData mapData, Set<Tile> drawnOn, Set<IDrawable> drawing) {
        Iterator<Point> effectPoints = mapData.getTerritoryEffectPoints(territory).iterator();
        Point drawingPoint = effectPoints.next();
        for (TerritoryEffect te : TerritoryEffectHelper.getEffects(territory)) {
            drawing.add(new TerritoryEffectDrawable(te, drawingPoint));
            drawingPoint = effectPoints.hasNext() ? effectPoints.next() : drawingPoint;
        }
    }

    private void drawUnits(Territory territory, GameData data, MapData mapData, Set<Tile> drawnOn, Set<IDrawable> drawing) {
        Iterator<Point> placementPoints = mapData.getPlacementPoints(territory).iterator();
        if (placementPoints == null || !placementPoints.hasNext()) {
            throw new IllegalStateException("No where to place units:" + territory.getName());
        }
        Point lastPlace = null;
        for (UnitCategory category : UnitSeperator.categorize(territory.getUnits().getUnits())) {
            boolean overflow;
            if (placementPoints.hasNext()) {
                lastPlace = new Point(placementPoints.next());
                overflow = false;
            } else {
                lastPlace = new Point(lastPlace);
                lastPlace.x += this.m_uiContext.getUnitImageFactory().getUnitImageWidth();
                overflow = true;
            }
            UnitsDrawer drawable = new UnitsDrawer(category.getUnits().size(), category.getType().getName(), category.getOwner().getName(), lastPlace, category.getDamaged(), category.getBombingDamage(), category.getDisabled(), overflow, territory.getName(), this.m_uiContext);
            drawing.add(drawable);
            this.m_allUnitDrawables.add(drawable);
            for (Tile tile : this.getTiles(new Rectangle(lastPlace.x, lastPlace.y, this.m_uiContext.getUnitImageFactory().getUnitImageWidth(), this.m_uiContext.getUnitImageFactory().getUnitImageHeight()))) {
                tile.addDrawable(drawable);
                drawnOn.add(tile);
            }
        }
    }

    public Image createTerritoryImage(Territory t, GameData data, MapData mapData) {
        return this.createTerritoryImage(t, t, data, mapData, true);
    }

    public Image createTerritoryImage(Territory selected, Territory focusOn, GameData data, MapData mapData) {
        return this.createTerritoryImage(selected, focusOn, data, mapData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image createTerritoryImage(Territory selected, Territory focusOn, GameData data, MapData mapData, boolean drawOutline) {
        Tile.S_TILE_LOCKUTIL.acquireLock(this.m_lock);
        try {
            Rectangle bounds = mapData.getBoundingRect(focusOn);
            int square_length = Math.max(bounds.width, bounds.height);
            int grow = square_length / 4;
            bounds.x -= grow;
            bounds.y -= grow;
            int mapDataWidth = mapData.getMapDimensions().width;
            int mapDataHeight = mapData.getMapDimensions().height;
            if ((square_length += grow * 2) > mapDataWidth) {
                square_length = mapDataWidth;
            }
            if (square_length > mapDataHeight) {
                square_length = mapDataHeight;
            }
            bounds.width = square_length;
            bounds.height = square_length;
            if (!mapData.scrollWrapX()) {
                if (bounds.x < 0) {
                    bounds.x = 0;
                }
                if (bounds.width + bounds.x > mapDataWidth) {
                    bounds.x = mapDataWidth - bounds.width;
                }
            }
            if (!mapData.scrollWrapY()) {
                if (bounds.y < 0) {
                    bounds.y = 0;
                }
                if (bounds.height + bounds.y > mapDataHeight) {
                    bounds.y = mapDataHeight - bounds.height;
                }
            }
            BufferedImage rVal = Util.createImage(square_length, square_length, false);
            Graphics2D graphics = (Graphics2D)((Image)rVal).getGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            if (bounds.x < 0) {
                bounds.x += mapDataWidth;
                this.drawForCreate(selected, data, mapData, bounds, graphics, drawOutline);
                if (bounds.y < 0) {
                    bounds.y += mapDataHeight;
                    this.drawForCreate(selected, data, mapData, bounds, graphics, drawOutline);
                    bounds.y -= mapDataHeight;
                }
                bounds.x -= mapDataWidth;
            }
            if (bounds.y < 0) {
                bounds.y += mapDataHeight;
                this.drawForCreate(selected, data, mapData, bounds, graphics, drawOutline);
                bounds.y -= mapDataHeight;
            }
            this.drawForCreate(selected, data, mapData, bounds, graphics, drawOutline);
            if (bounds.x + bounds.height > mapDataWidth) {
                bounds.x -= mapDataWidth;
                this.drawForCreate(selected, data, mapData, bounds, graphics, drawOutline);
                if (bounds.y + bounds.width > mapDataHeight) {
                    bounds.y -= mapDataHeight;
                    this.drawForCreate(selected, data, mapData, bounds, graphics, drawOutline);
                    bounds.y += mapDataHeight;
                }
                bounds.x += mapDataWidth;
            }
            if (bounds.y + bounds.width > mapDataHeight) {
                bounds.y -= mapDataHeight;
                this.drawForCreate(selected, data, mapData, bounds, graphics, drawOutline);
                bounds.y += mapDataHeight;
            }
            graphics.dispose();
            BufferedImage bufferedImage = rVal;
            return bufferedImage;
        }
        finally {
            Tile.S_TILE_LOCKUTIL.releaseLock(this.m_lock);
        }
    }

    private void drawForCreate(Territory selected, GameData data, MapData mapData, Rectangle bounds, Graphics2D graphics, boolean drawOutline) {
        IDrawable drawer;
        HashSet<IDrawable> drawablesSet = new HashSet<IDrawable>();
        List<Tile> intersectingTiles = this.getTiles(bounds);
        for (Tile tile : intersectingTiles) {
            drawablesSet.addAll(tile.getDrawables());
        }
        if (this.m_uiContext.getScale() != 1.0) {
            ArrayList<MapTileDrawable> toAdd = new ArrayList<MapTileDrawable>();
            Iterator iter = drawablesSet.iterator();
            while (iter.hasNext()) {
                IDrawable drawable = (IDrawable)iter.next();
                if (!(drawable instanceof MapTileDrawable)) continue;
                iter.remove();
                toAdd.add(((MapTileDrawable)drawable).getUnscaledCopy());
            }
            drawablesSet.addAll(toAdd);
        }
        ArrayList orderedDrawables = new ArrayList(drawablesSet);
        Collections.sort(orderedDrawables, new DrawableComparator());
        Iterator<Object> i$ = orderedDrawables.iterator();
        while (i$.hasNext() && (drawer = (IDrawable)i$.next()).getLevel() < 15) {
            if (drawer.getLevel() == 13) continue;
            drawer.draw(bounds, data, graphics, mapData, null, null);
        }
        if (!drawOutline) {
            Color c;
            if (selected.isWater()) {
                c = Color.RED;
            } else {
                c = mapData.getPlayerColor(selected.getOwner().getName());
                c = new Color(c.getRed() ^ c.getRed(), c.getGreen() ^ c.getGreen(), c.getRed() ^ c.getRed());
            }
            TerritoryOverLayDrawable told = new TerritoryOverLayDrawable(c, selected.getName(), 100, TerritoryOverLayDrawable.OP.FILL);
            told.draw(bounds, data, graphics, mapData, null, null);
        }
        graphics.setStroke(new BasicStroke(10.0f));
        graphics.setColor(Color.RED);
        for (Polygon poly : mapData.getPolygons(selected)) {
            poly = new Polygon(poly.xpoints, poly.ypoints, poly.npoints);
            poly.translate(-bounds.x, -bounds.y);
            graphics.drawPolygon(poly);
        }
    }

    /*
     * Exception decompiling
     */
    public Rectangle getUnitRect(List<Unit> units, GameData data) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Tuple<Territory, List<Unit>> getUnitsAtPoint(double x, double y, GameData gameData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerritoryOverlay(Territory territory, Color color, int alpha, GameData data, MapData mapData) {
        Tile.S_TILE_LOCKUTIL.acquireLock(this.m_lock);
        try {
            TerritoryOverLayDrawable drawable = new TerritoryOverLayDrawable(color, territory.getName(), alpha, TerritoryOverLayDrawable.OP.DRAW);
            this.m_territoryOverlays.put(territory.getName(), drawable);
        }
        finally {
            Tile.S_TILE_LOCKUTIL.releaseLock(this.m_lock);
        }
        this.updateTerritory(territory, data, mapData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerritoryOverlayForBorder(Territory territory, Color color, GameData data, MapData mapData) {
        Tile.S_TILE_LOCKUTIL.acquireLock(this.m_lock);
        try {
            TerritoryOverLayDrawable drawable = new TerritoryOverLayDrawable(color, territory.getName(), TerritoryOverLayDrawable.OP.DRAW);
            this.m_territoryOverlays.put(territory.getName(), drawable);
        }
        finally {
            Tile.S_TILE_LOCKUTIL.releaseLock(this.m_lock);
        }
        this.updateTerritory(territory, data, mapData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTerritoryOverlay(Territory territory, GameData data, MapData mapData) {
        Tile.S_TILE_LOCKUTIL.acquireLock(this.m_lock);
        try {
            this.m_territoryOverlays.remove(territory.getName());
        }
        finally {
            Tile.S_TILE_LOCKUTIL.releaseLock(this.m_lock);
        }
        this.updateTerritory(territory, data, mapData);
    }
}

