/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.ui;

import games.strategy.ui.DoubleTextFieldChangeListener;
import games.strategy.util.ListenerList;
import java.awt.FlowLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DoubleTextField
extends JTextField {
    private static final long serialVersionUID = -8698753345852617343L;
    private double m_max = Double.MAX_VALUE;
    private double m_min = Double.MIN_VALUE;
    private String m_terr = null;
    private final ListenerList<DoubleTextFieldChangeListener> m_listeners = new ListenerList();

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(new JLabel("no range"));
        frame.getContentPane().add(new DoubleTextField());
        frame.getContentPane().add(new JLabel("positive"));
        frame.getContentPane().add(new DoubleTextField(0.0));
        frame.getContentPane().add(new JLabel("0 to 5"));
        frame.getContentPane().add(new DoubleTextField(0.0, 5.1));
        frame.setSize(400, 60);
        frame.setVisible(true);
    }

    public DoubleTextField() {
        super(10);
        this.initTextField();
    }

    public DoubleTextField(double min) {
        this();
        this.setMin(min);
    }

    public DoubleTextField(double min, double max) {
        this();
        this.setMin(min);
        this.setMax(max);
    }

    private void initTextField() {
        this.setDocument(new DoubleDocument());
        this.setText(String.valueOf(this.m_min));
        this.addFocusListener(new LostFocus());
    }

    public double getValue() {
        return Double.parseDouble(this.getText());
    }

    private void checkValue() {
        if (this.getText().trim().equals("-")) {
            this.setText(String.valueOf(this.m_min));
        }
        try {
            Double.parseDouble(this.getText());
        }
        catch (NumberFormatException e) {
            this.setText(String.valueOf(this.m_min));
        }
        if (this.getValue() > this.m_max) {
            this.setText(String.valueOf(this.m_max));
        }
        if (this.getValue() < this.m_min) {
            this.setText(String.valueOf(this.m_min));
        }
    }

    public void setValue(double value) {
        if (this.isGood(value)) {
            this.setText(String.valueOf(value));
        }
    }

    public void setMax(double max) {
        if (max < this.m_min) {
            throw new IllegalArgumentException("Max cant be less than min. Current Min: " + this.m_min + ", Current Max: " + this.m_max + ", New Max: " + max);
        }
        this.m_max = max;
        if (this.getValue() > this.m_max) {
            this.setText(String.valueOf(max));
        }
    }

    public void setTerr(String terr) {
        this.m_terr = terr;
    }

    public void setMin(double min) {
        if (min > this.m_max) {
            throw new IllegalArgumentException("Min cant be greater than max. Current Max: " + this.m_max + ", Current Min: " + this.m_min + ", New Min: " + min);
        }
        this.m_min = min;
        if (this.getValue() < this.m_min) {
            this.setText(String.valueOf(min));
        }
    }

    public double getMax() {
        return this.m_max;
    }

    public String getTerr() {
        return this.m_terr;
    }

    public double getMin() {
        return this.m_min;
    }

    private final boolean isGood(double value) {
        return value <= this.m_max && value >= this.m_min;
    }

    public void addChangeListener(DoubleTextFieldChangeListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeChangeListener(DoubleTextFieldChangeListener listener) {
        this.m_listeners.remove(listener);
    }

    private void notifyListeners() {
        for (DoubleTextFieldChangeListener listener : this.m_listeners) {
            listener.changedValue(this);
        }
    }

    private class LostFocus
    extends FocusAdapter {
        private LostFocus() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            DoubleTextField.this.checkValue();
        }
    }

    private class DoubleDocument
    extends PlainDocument {
        private static final long serialVersionUID = 64683753745223443L;

        private DoubleDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            block2: {
                String currentText = this.getText(0, this.getLength());
                String beforeOffset = currentText.substring(0, offs);
                String afterOffset = currentText.substring(offs, currentText.length());
                String proposedResult = beforeOffset + str + afterOffset;
                try {
                    Double.parseDouble(proposedResult);
                    super.insertString(offs, str, a);
                    DoubleTextField.this.checkValue();
                    DoubleTextField.this.notifyListeners();
                }
                catch (NumberFormatException e) {
                    if (offs != 0 || !(DoubleTextField.this.m_min < 0.0) || !str.equals("-")) break block2;
                    super.insertString(offs, str, a);
                }
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
            try {
                Double.parseDouble(DoubleTextField.this.getText());
                DoubleTextField.this.notifyListeners();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

