/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.ui;

import games.strategy.ui.IntTextFieldChangeListener;
import games.strategy.util.ListenerList;
import java.awt.FlowLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntTextField
extends JTextField {
    private static final long serialVersionUID = -7993942326354823887L;
    private int m_max = Integer.MAX_VALUE;
    private int m_min = Integer.MIN_VALUE;
    private String m_terr = null;
    private final ListenerList<IntTextFieldChangeListener> m_listeners = new ListenerList();

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(new JLabel("no range"));
        frame.getContentPane().add(new IntTextField());
        frame.getContentPane().add(new JLabel("positive"));
        frame.getContentPane().add(new IntTextField(0));
        frame.getContentPane().add(new JLabel("0 to 5"));
        frame.getContentPane().add(new IntTextField(0, 5));
        frame.setSize(400, 60);
        frame.setVisible(true);
    }

    public IntTextField() {
        super(3);
        this.initTextField();
    }

    public IntTextField(int min) {
        this();
        this.setMin(min);
    }

    public IntTextField(int min, int max) {
        this();
        this.setMin(min);
        this.setMax(max);
    }

    public IntTextField(int min, int max, int current) {
        this();
        this.setMin(min);
        this.setMax(max);
        this.setValue(current);
    }

    public IntTextField(int min, int max, int current, int columns) {
        super(columns);
        this.initTextField();
        this.setMin(min);
        this.setMax(max);
        this.setValue(current);
    }

    private void initTextField() {
        this.setDocument(new IntegerDocument());
        this.setText(String.valueOf(this.m_min));
        this.addFocusListener(new LostFocus());
    }

    public int getValue() {
        return Integer.parseInt(this.getText());
    }

    private void checkValue() {
        if (this.getText().trim().equals("-")) {
            this.setText(String.valueOf(this.m_min));
        }
        try {
            Integer.parseInt(this.getText());
        }
        catch (NumberFormatException e) {
            this.setText(String.valueOf(this.m_min));
        }
        if (this.getValue() > this.m_max) {
            this.setText(String.valueOf(this.m_max));
        }
        if (this.getValue() < this.m_min) {
            this.setText(String.valueOf(this.m_min));
        }
    }

    public void setValue(int value) {
        if (this.isGood(value)) {
            this.setText(String.valueOf(value));
        }
    }

    public void setMax(int max) {
        if (max < this.m_min) {
            throw new IllegalArgumentException("Max cant be less than min. Current Min: " + this.m_min + ", Current Max: " + this.m_max + ", New Max: " + max);
        }
        this.m_max = max;
        if (this.getValue() > this.m_max) {
            this.setText(String.valueOf(max));
        }
    }

    public void setTerr(String terr) {
        this.m_terr = terr;
    }

    public void setMin(int min) {
        if (min > this.m_max) {
            throw new IllegalArgumentException("Min cant be greater than max. Current Max: " + this.m_max + ", Current Min: " + this.m_min + ", New Min: " + min);
        }
        this.m_min = min;
        if (this.getValue() < this.m_min) {
            this.setText(String.valueOf(min));
        }
    }

    public int getMax() {
        return this.m_max;
    }

    public String getTerr() {
        return this.m_terr;
    }

    public int getMin() {
        return this.m_min;
    }

    private final boolean isGood(int value) {
        return value <= this.m_max && value >= this.m_min;
    }

    public void addChangeListener(IntTextFieldChangeListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeChangeListener(IntTextFieldChangeListener listener) {
        this.m_listeners.remove(listener);
    }

    private void notifyListeners() {
        for (IntTextFieldChangeListener listener : this.m_listeners) {
            listener.changedValue(this);
        }
    }

    private class LostFocus
    extends FocusAdapter {
        private LostFocus() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            IntTextField.this.checkValue();
        }
    }

    private class IntegerDocument
    extends PlainDocument {
        private static final long serialVersionUID = 135871239193051281L;

        private IntegerDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            block2: {
                String currentText = this.getText(0, this.getLength());
                String beforeOffset = currentText.substring(0, offs);
                String afterOffset = currentText.substring(offs, currentText.length());
                String proposedResult = beforeOffset + str + afterOffset;
                try {
                    Integer.parseInt(proposedResult);
                    super.insertString(offs, str, a);
                    IntTextField.this.checkValue();
                    IntTextField.this.notifyListeners();
                }
                catch (NumberFormatException e) {
                    if (offs != 0 || IntTextField.this.m_min >= 0 || !str.equals("-")) break block2;
                    super.insertString(offs, str, a);
                }
            }
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
            try {
                Integer.parseInt(IntTextField.this.getText());
                IntTextField.this.notifyListeners();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

