/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import javax.swing.JComponent;

class ZoomableImage
extends JComponent {
    private static final long serialVersionUID = 3324558973854619020L;
    private double m_zoom = 1.0;
    private final Image m_original;
    private Image m_current;

    public ZoomableImage(Image anImage) {
        this.ensureImageLoaded(anImage);
        this.m_original = anImage;
        this.m_current = anImage;
        Dimension dim = new Dimension(this.m_current.getWidth(this), this.m_current.getHeight(this));
        this.setPreferredSize(dim);
    }

    private void ensureImageLoaded(Image anImage) {
        if (anImage.getWidth(this) != -1) {
            return;
        }
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(anImage, 1);
        try {
            tracker.waitForAll(1L);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            System.err.println("<<<<<<<<<<<<<<<<<<<<<<>trying again to load Image");
            this.ensureImageLoaded(anImage);
        }
    }

    public double getZoom() {
        return this.m_zoom;
    }

    public void setZoom(double newZoom) {
        if (newZoom <= 1.0) {
            throw new IllegalArgumentException("Zoom must be > 1.  Got:" + newZoom);
        }
        this.m_zoom = newZoom;
        this.stretchImage();
        Dimension dim = new Dimension(this.m_current.getWidth(this), this.m_current.getHeight(this));
        this.setPreferredSize(dim);
        this.invalidate();
    }

    private void stretchImage() {
        int width = (int)((double)this.m_original.getWidth(this) * this.m_zoom);
        int height = (int)((double)this.m_original.getHeight(this) * this.m_zoom);
        this.m_current = this.m_original.getScaledInstance(width, height, 2);
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.m_current, 0, 0, this);
        Rectangle rect = g.getClipBounds();
        if (rect.getWidth() > (double)this.m_current.getWidth(this) || rect.getHeight() > (double)this.m_current.getHeight(this)) {
            // empty if block
        }
    }

    public void addComponent(Component comp) {
        throw new IllegalStateException("Cannot add componenets to an image panel");
    }
}

