/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class CountDownLatchHandler {
    private final List<CountDownLatch> m_latchesToCloseOnShutdown = new ArrayList<CountDownLatch>();
    private volatile boolean m_isShutDown = false;
    private final boolean m_releaseLatchOnInterrupt;

    public CountDownLatchHandler(boolean releaseLatchOnInterrupt) {
        this.m_releaseLatchOnInterrupt = releaseLatchOnInterrupt;
    }

    public void interruptAll() {
        if (this.m_releaseLatchOnInterrupt) {
            for (CountDownLatch latch : this.m_latchesToCloseOnShutdown) {
                this.removeShutdownLatch(latch);
            }
        }
    }

    public void interruptLatch(CountDownLatch latch) {
        if (this.m_releaseLatchOnInterrupt) {
            this.removeShutdownLatch(latch);
        }
    }

    public boolean isShutDown() {
        return this.m_isShutDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        CountDownLatchHandler countDownLatchHandler = this;
        synchronized (countDownLatchHandler) {
            if (this.m_isShutDown) {
                return;
            }
            this.m_isShutDown = true;
        }
        for (CountDownLatch latch : this.m_latchesToCloseOnShutdown) {
            CountDownLatchHandler.releaseLatch(latch);
        }
        this.m_latchesToCloseOnShutdown.clear();
    }

    public static void releaseLatch(CountDownLatch latch) {
        if (latch == null) {
            return;
        }
        while (latch.getCount() > 0L) {
            latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownLatch(CountDownLatch latch) {
        CountDownLatchHandler countDownLatchHandler = this;
        synchronized (countDownLatchHandler) {
            if (this.m_isShutDown) {
                CountDownLatchHandler.releaseLatch(latch);
                return;
            }
            this.m_latchesToCloseOnShutdown.add(latch);
        }
    }

    public void removeShutdownLatch(CountDownLatch latch) {
        this.removeShutdownLatch(latch, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShutdownLatch(CountDownLatch latch, boolean doNotRelease) {
        CountDownLatchHandler countDownLatchHandler = this;
        synchronized (countDownLatchHandler) {
            if (!doNotRelease) {
                CountDownLatchHandler.releaseLatch(latch);
            }
            this.m_latchesToCloseOnShutdown.remove(latch);
        }
    }
}

