/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.util;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CountUpAndDownLatch
implements Serializable {
    private static final long serialVersionUID = -1656388212821764097L;
    private final Sync sync;
    private final int originalCount;

    public CountUpAndDownLatch() {
        this.sync = new Sync();
        this.originalCount = 0;
    }

    public CountUpAndDownLatch(int initialCount) {
        if (initialCount < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        this.sync = new Sync(initialCount);
        this.originalCount = initialCount;
    }

    public void increment() {
        this.sync.releaseShared(1);
    }

    public void countDown() {
        this.sync.releaseShared(-1);
    }

    public void applyDelta(int delta) {
        this.sync.releaseShared(delta);
    }

    public void releaseAll() {
        this.applyDelta(Integer.MIN_VALUE);
    }

    public void resetCount() {
        if (this.originalCount == 0) {
            this.releaseAll();
        } else {
            int diff = this.originalCount - this.sync.getCount();
            this.applyDelta(diff);
        }
    }

    public int getCount() {
        return this.sync.getCount();
    }

    public int getOriginalCount() {
        return this.originalCount;
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    public String toString() {
        return super.toString() + "[Count = " + this.sync.getCount() + "]";
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = -7639904478060101736L;

        private Sync() {
        }

        private Sync(int initialState) {
            this.setState(initialState);
        }

        int getCount() {
            return this.getState();
        }

        @Override
        protected int tryAcquireShared(int acquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int delta) {
            int nextc;
            int c;
            if (delta == 0) {
                return false;
            }
            do {
                c = this.getState();
                nextc = c + delta;
                if (c <= 0 && nextc <= 0) {
                    return false;
                }
                if (nextc >= 0) continue;
                nextc = 0;
            } while (!this.compareAndSetState(c, nextc));
            return nextc == 0;
        }
    }
}

