/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class JTextAreaOptionPane {
    private final JTextArea m_editor = new JTextArea();
    private final JFrame m_windowFrame = new JFrame();
    private final JButton m_okButton = new JButton();
    private final JLabel m_label = new JLabel();
    private final boolean m_logToSystemOut;
    private final WeakReference<Window> m_parentComponentReference;
    private int m_counter;
    private final CountDownLatch m_countDownLatch;

    public JTextAreaOptionPane(JFrame parentComponent, String initialEditorText, String labelText, String title, Image icon, int editorSizeX, int editorSizeY, boolean logToSystemOut, int latchCount, CountDownLatch countDownLatch) {
        this.m_logToSystemOut = logToSystemOut;
        this.m_countDownLatch = countDownLatch;
        this.m_counter = latchCount;
        this.m_parentComponentReference = new WeakReference<JFrame>(parentComponent);
        this.m_windowFrame.setDefaultCloseOperation(0);
        if (icon != null) {
            this.m_windowFrame.setIconImage(icon);
        } else if (parentComponent != null && parentComponent.getIconImage() != null) {
            this.m_windowFrame.setIconImage(parentComponent.getIconImage());
        }
        BorderLayout layout = new BorderLayout();
        layout.setHgap(30);
        layout.setVgap(30);
        this.m_windowFrame.setLayout(layout);
        this.m_windowFrame.setTitle(title);
        this.m_label.setText(labelText);
        this.m_okButton.setText("OK");
        this.m_okButton.setEnabled(false);
        this.m_editor.setEditable(false);
        this.m_editor.setText(initialEditorText);
        if (this.m_logToSystemOut) {
            System.out.println(initialEditorText);
        }
        this.m_editor.setCaretPosition(0);
        this.m_windowFrame.setPreferredSize(new Dimension(editorSizeX, editorSizeY));
        this.m_windowFrame.getContentPane().add((Component)this.m_label, "North");
        this.m_windowFrame.getContentPane().add((Component)new JScrollPane(this.m_editor), "Center");
        this.m_windowFrame.getContentPane().add((Component)this.m_okButton, "South");
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JTextAreaOptionPane.this.m_countDownLatch != null) {
                    JTextAreaOptionPane.this.m_countDownLatch.countDown();
                }
                JTextAreaOptionPane.this.dispose();
            }
        });
    }

    private void setWidgetActivation() {
        if (this.m_counter <= 0) {
            this.m_okButton.setEnabled(true);
        }
    }

    public void show() {
        this.m_windowFrame.pack();
        this.m_windowFrame.setLocationRelativeTo((Component)this.m_parentComponentReference.get());
        this.m_windowFrame.setVisible(true);
    }

    public void dispose() {
        this.m_windowFrame.setVisible(false);
        this.m_windowFrame.dispose();
    }

    public void countDown() {
        --this.m_counter;
        this.setWidgetActivation();
    }

    public void append(String text) {
        if (this.m_logToSystemOut) {
            System.out.print(text);
        }
        this.m_editor.append(text);
        this.m_editor.setCaretPosition(this.m_editor.getText().length());
    }

    public void appendNewLine(String text) {
        this.append(text + "\r\n");
    }
}

