/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.util;

import games.strategy.triplea.ResourceLoader;
import games.strategy.triplea.ui.AbstractUIContext;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LocalizeHTML {
    public static final String ASSET_IMAGE_FOLDER = "doc/images/";
    public static final String ASSET_IMAGE_NOT_FOUND = "notFound.png";
    public static final String PATTERN_HTML_A_TAG = "(?i)<a([^>]+)>(.*?)</a>";
    public static final String PATTERN_HTML_A_HREF_TAG = "\\s*(?i)href\\s*=\\s*(\"([^\"]*\")|'[^']*'|([^'\">\\s]+))";
    public static final String PATTERN_HTML_IMG_TAG = "(?i)<img([^>]+)/>";
    public static final String PATTERN_HTML_IMG_SRC_TAG = "\\s*(?i)src\\s*=\\s*(\"([^\"]*\")|'[^']*'|([^'\">\\s]+))";

    public static List<String> getAllAhrefLinksFromHTML(String htmlText) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern patternTag = Pattern.compile(PATTERN_HTML_A_TAG);
        Pattern patternLink = Pattern.compile(PATTERN_HTML_A_HREF_TAG);
        Matcher matcherTag = patternTag.matcher(htmlText);
        while (matcherTag.find()) {
            String href = matcherTag.group(1);
            Matcher matcherLink = patternLink.matcher(href);
            while (matcherLink.find()) {
                String link = matcherLink.group(1);
                result.add(link);
            }
        }
        return result;
    }

    public static List<String> getAllImgSrcLinksFromHTML(String htmlText) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern patternTag = Pattern.compile(PATTERN_HTML_IMG_TAG);
        Pattern patternLink = Pattern.compile(PATTERN_HTML_IMG_SRC_TAG);
        Matcher matcherTag = patternTag.matcher(htmlText);
        while (matcherTag.find()) {
            String href = matcherTag.group(1);
            Matcher matcherLink = patternLink.matcher(href);
            while (matcherLink.find()) {
                String link = matcherLink.group(1);
                result.add(link);
            }
        }
        return result;
    }

    public static String localizeImgLinksInHTML(String htmlText) {
        return LocalizeHTML.localizeImgLinksInHTML(htmlText, AbstractUIContext.getResourceLoader(), null);
    }

    public static String localizeImgLinksInHTML(String htmlText, ResourceLoader resourceLoader, String mapNameDir) {
        if (htmlText == null || resourceLoader == null && (mapNameDir == null || mapNameDir.trim().length() == 0)) {
            return htmlText;
        }
        ResourceLoader ourResourceLoader = resourceLoader;
        String rVal = htmlText;
        Pattern patternTag = Pattern.compile(PATTERN_HTML_IMG_TAG);
        Pattern patternLink = Pattern.compile(PATTERN_HTML_IMG_SRC_TAG);
        Matcher matcherTag = patternTag.matcher(htmlText);
        while (matcherTag.find()) {
            String href = matcherTag.group(1);
            if (href == null) continue;
            Matcher matcherLink = patternLink.matcher(href);
            while (matcherLink.find()) {
                String fullLink = matcherLink.group(1);
                if (fullLink == null || fullLink.length() <= 2) continue;
                if (ourResourceLoader == null) {
                    ourResourceLoader = ResourceLoader.getMapResourceLoader(mapNameDir, false);
                }
                String link = fullLink.substring(1, fullLink.length() - 1);
                String imageFileName = link.substring(Math.max(link.lastIndexOf("/") + 1, 0));
                URL replacementURL = ourResourceLoader.getResource(ASSET_IMAGE_FOLDER + imageFileName);
                if (replacementURL == null || replacementURL.toString().length() == 0) {
                    System.out.println("Could not find: <map>/doc/images/" + imageFileName);
                    replacementURL = ourResourceLoader.getResource("doc/images/notFound.png");
                }
                if (replacementURL == null || replacementURL.toString().length() == 0) {
                    System.err.println("Could not find: doc/images/notFound.png");
                    continue;
                }
                rVal = rVal.replaceAll(link, replacementURL.toString());
            }
        }
        return rVal;
    }

    public static void main(String[] args) {
        String htmlText = "<br><img src=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview0.png\" alt=\"blah, blah\"/>\n<br /><img src=\"\" alt=\"<em>formatted, alt text for a no source image</em>\"/>\n<br/><img src=\"http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/somePicture.gif\"/>\n<br><img src=\"http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/some Picture%20WithSpaces.JPEG\" alt=\"<em>formatted, alt text</em>\"/>\n<br><img src='http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/some Picture%20WithSpaces2.JPEG' alt='formatted, alt text for single quote img tag'/>\n<br/><IMG ALT=\"reverse order alt and src tags and capitalized\" SRC=\"http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/somePicture2.gif\"/>\n<br /><br><img src=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview1.png\" alt=\"technically legal to have separate end tag on img\"></img>\n<br>And here is a normal link in plain text: http://tripleamaps.sourceforge.net/images/tww/TechOverview1.png\n<br />And <SPAN>some regular old html <b>text that</b> might <i>have other</i> formatting in it</SPAN> and stuff.\n<br />And now for some normal links as links:\n<br /><a href=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview2.png\">picture</a>\n<br /><a href=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview3.png\"/>\n<br /><A HREF=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview4.png\"><em><SPAN>formatted, alt text, with capitalization</SPAN></em></A>\n<br /><a href=\"\"><em>formatted, alt text for a no href link</em></a>\n<br /><a target='_blank' href='http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/some Picture%20WithSpaces3.JPEG'><b>reverse order with single quotes and formatted text</b></a>";
        System.out.println("<br><img src=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview0.png\" alt=\"blah, blah\"/>\n<br /><img src=\"\" alt=\"<em>formatted, alt text for a no source image</em>\"/>\n<br/><img src=\"http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/somePicture.gif\"/>\n<br><img src=\"http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/some Picture%20WithSpaces.JPEG\" alt=\"<em>formatted, alt text</em>\"/>\n<br><img src='http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/some Picture%20WithSpaces2.JPEG' alt='formatted, alt text for single quote img tag'/>\n<br/><IMG ALT=\"reverse order alt and src tags and capitalized\" SRC=\"http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/somePicture2.gif\"/>\n<br /><br><img src=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview1.png\" alt=\"technically legal to have separate end tag on img\"></img>\n<br>And here is a normal link in plain text: http://tripleamaps.sourceforge.net/images/tww/TechOverview1.png\n<br />And <SPAN>some regular old html <b>text that</b> might <i>have other</i> formatting in it</SPAN> and stuff.\n<br />And now for some normal links as links:\n<br /><a href=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview2.png\">picture</a>\n<br /><a href=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview3.png\"/>\n<br /><A HREF=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview4.png\"><em><SPAN>formatted, alt text, with capitalization</SPAN></em></A>\n<br /><a href=\"\"><em>formatted, alt text for a no href link</em></a>\n<br /><a target='_blank' href='http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/some Picture%20WithSpaces3.JPEG'><b>reverse order with single quotes and formatted text</b></a>");
        System.out.println("\n\n\n");
        List<String> links1 = LocalizeHTML.getAllAhrefLinksFromHTML("<br><img src=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview0.png\" alt=\"blah, blah\"/>\n<br /><img src=\"\" alt=\"<em>formatted, alt text for a no source image</em>\"/>\n<br/><img src=\"http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/somePicture.gif\"/>\n<br><img src=\"http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/some Picture%20WithSpaces.JPEG\" alt=\"<em>formatted, alt text</em>\"/>\n<br><img src='http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/some Picture%20WithSpaces2.JPEG' alt='formatted, alt text for single quote img tag'/>\n<br/><IMG ALT=\"reverse order alt and src tags and capitalized\" SRC=\"http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/somePicture2.gif\"/>\n<br /><br><img src=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview1.png\" alt=\"technically legal to have separate end tag on img\"></img>\n<br>And here is a normal link in plain text: http://tripleamaps.sourceforge.net/images/tww/TechOverview1.png\n<br />And <SPAN>some regular old html <b>text that</b> might <i>have other</i> formatting in it</SPAN> and stuff.\n<br />And now for some normal links as links:\n<br /><a href=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview2.png\">picture</a>\n<br /><a href=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview3.png\"/>\n<br /><A HREF=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview4.png\"><em><SPAN>formatted, alt text, with capitalization</SPAN></em></A>\n<br /><a href=\"\"><em>formatted, alt text for a no href link</em></a>\n<br /><a target='_blank' href='http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/some Picture%20WithSpaces3.JPEG'><b>reverse order with single quotes and formatted text</b></a>");
        System.out.println(links1.toString());
        System.out.println("\n\n\n");
        List<String> links2 = LocalizeHTML.getAllImgSrcLinksFromHTML("<br><img src=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview0.png\" alt=\"blah, blah\"/>\n<br /><img src=\"\" alt=\"<em>formatted, alt text for a no source image</em>\"/>\n<br/><img src=\"http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/somePicture.gif\"/>\n<br><img src=\"http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/some Picture%20WithSpaces.JPEG\" alt=\"<em>formatted, alt text</em>\"/>\n<br><img src='http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/some Picture%20WithSpaces2.JPEG' alt='formatted, alt text for single quote img tag'/>\n<br/><IMG ALT=\"reverse order alt and src tags and capitalized\" SRC=\"http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/somePicture2.gif\"/>\n<br /><br><img src=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview1.png\" alt=\"technically legal to have separate end tag on img\"></img>\n<br>And here is a normal link in plain text: http://tripleamaps.sourceforge.net/images/tww/TechOverview1.png\n<br />And <SPAN>some regular old html <b>text that</b> might <i>have other</i> formatting in it</SPAN> and stuff.\n<br />And now for some normal links as links:\n<br /><a href=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview2.png\">picture</a>\n<br /><a href=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview3.png\"/>\n<br /><A HREF=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview4.png\"><em><SPAN>formatted, alt text, with capitalization</SPAN></em></A>\n<br /><a href=\"\"><em>formatted, alt text for a no href link</em></a>\n<br /><a target='_blank' href='http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/some Picture%20WithSpaces3.JPEG'><b>reverse order with single quotes and formatted text</b></a>");
        System.out.println(links2.toString());
        System.out.println("\n\n\n");
        String newHTMLstring = LocalizeHTML.localizeImgLinksInHTML("<br><img src=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview0.png\" alt=\"blah, blah\"/>\n<br /><img src=\"\" alt=\"<em>formatted, alt text for a no source image</em>\"/>\n<br/><img src=\"http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/somePicture.gif\"/>\n<br><img src=\"http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/some Picture%20WithSpaces.JPEG\" alt=\"<em>formatted, alt text</em>\"/>\n<br><img src='http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/some Picture%20WithSpaces2.JPEG' alt='formatted, alt text for single quote img tag'/>\n<br/><IMG ALT=\"reverse order alt and src tags and capitalized\" SRC=\"http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/somePicture2.gif\"/>\n<br /><br><img src=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview1.png\" alt=\"technically legal to have separate end tag on img\"></img>\n<br>And here is a normal link in plain text: http://tripleamaps.sourceforge.net/images/tww/TechOverview1.png\n<br />And <SPAN>some regular old html <b>text that</b> might <i>have other</i> formatting in it</SPAN> and stuff.\n<br />And now for some normal links as links:\n<br /><a href=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview2.png\">picture</a>\n<br /><a href=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview3.png\"/>\n<br /><A HREF=\"http://tripleamaps.sourceforge.net/images/tww/TechOverview4.png\"><em><SPAN>formatted, alt text, with capitalization</SPAN></em></A>\n<br /><a href=\"\"><em>formatted, alt text for a no href link</em></a>\n<br /><a target='_blank' href='http://www.someWebsite.com/some%20Folder/someOtherFolder Which May Contain Spaces/some Picture%20WithSpaces3.JPEG'><b>reverse order with single quotes and formatted text</b></a>");
        System.out.println("\n" + newHTMLstring);
    }
}

