/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.util;

import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class TimerClock<T>
extends Observable {
    public static void startTask(Runnable task, int interruptAfterSecondsIfNotFinished, int delaySeconds, Collection<Class<? extends RuntimeException>> exceptionsToIgnoreOnInterrupt, Observer observer) {
        new TimerClock<Object>().start(task, null, interruptAfterSecondsIfNotFinished, delaySeconds, exceptionsToIgnoreOnInterrupt, observer);
    }

    public T start(final Runnable task, T defaultReturnValue, final int interruptAfterSecondsIfNotFinished, int delaySeconds, Collection<Class<? extends RuntimeException>> exceptionsToIgnoreOnInterrupt, Observer observer) {
        if (observer != null) {
            this.addObserver(observer);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean runnableFinishedSuccessfully = new AtomicBoolean(false);
        final AtomicBoolean runnableHadRuntimeException = new AtomicBoolean(false);
        final AtomicReference exception = new AtomicReference();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        task.run();
                        runnableFinishedSuccessfully.set(true);
                        if (latch != null) {
                            latch.countDown();
                        }
                    }
                    catch (RuntimeException e) {
                        exception.set(e);
                        runnableHadRuntimeException.set(true);
                        if (latch == null) break block3;
                        latch.countDown();
                    }
                }
            }
        });
        t.start();
        long delay = delaySeconds * 1000;
        long period = 1000L;
        final Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){
            int seconds;
            {
                this.seconds = interruptAfterSecondsIfNotFinished;
            }

            @Override
            public void run() {
                TimerClock.this.setChanged();
                TimerClock.this.notifyObservers(new TimerClockNotification(this.seconds, false));
                if (this.seconds-- <= 0) {
                    timer.cancel();
                    if (latch != null) {
                        latch.countDown();
                    }
                }
            }
        }, delay, 1000L);
        if (latch != null) {
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        boolean interrupted = false;
        timer.cancel();
        if (!runnableFinishedSuccessfully.get() && !runnableHadRuntimeException.get()) {
            this.setChanged();
            this.notifyObservers(new TimerClockNotification(0, true));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            interrupted = true;
            t.interrupt();
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.deleteObservers();
        if (!(exception.get() == null || interrupted && exceptionsToIgnoreOnInterrupt.contains(((RuntimeException)exception.get()).getClass()))) {
            throw (RuntimeException)exception.get();
        }
        return defaultReturnValue;
    }

    public class TimerClockNotification
    implements ITimerClockNotification {
        public final int m_secondsLeft;
        public final boolean m_areWeInterrupting;

        public TimerClockNotification(int secondsLeft, boolean areWeInterrupting) {
            this.m_secondsLeft = secondsLeft;
            this.m_areWeInterrupting = areWeInterrupting;
        }

        @Override
        public int getSecondsLeft() {
            return this.m_secondsLeft;
        }

        @Override
        public boolean areWeInterrupting() {
            return this.m_areWeInterrupting;
        }

        public String toString() {
            return "Seconds left: " + this.getSecondsLeft() + "   Interrupting: " + this.areWeInterrupting();
        }
    }

    public static interface ITimerClockNotification {
        public int getSecondsLeft();

        public boolean areWeInterrupting();
    }
}

