/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.util;

import games.strategy.util.IntegerMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Util {
    public static <T> List<T> intersection(Collection<T> c1, Collection<T> c2) {
        if (c1 == null || c2 == null) {
            return new ArrayList();
        }
        if (c1.size() == 0 || c2.size() == 0) {
            return new ArrayList();
        }
        ArrayList<T> intersection = new ArrayList<T>();
        for (T current : c1) {
            if (!c2.contains(current)) continue;
            intersection.add(current);
        }
        return intersection;
    }

    public static <T> boolean someIntersect(Collection<T> c1, Collection<T> c2) {
        if (c1.isEmpty()) {
            return false;
        }
        if (c2.isEmpty()) {
            return false;
        }
        Iterator<T> iter = c1.iterator();
        while (iter.hasNext()) {
            if (!c2.contains(iter.next())) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> difference(Collection<T> c1, Collection<T> c2) {
        if (c1 == null || c1.size() == 0) {
            return new ArrayList(0);
        }
        if (c2 == null || c2.size() == 0) {
            return new ArrayList<T>(c1);
        }
        ArrayList<T> difference = new ArrayList<T>();
        for (T current : c1) {
            if (c2.contains(current)) continue;
            difference.add(current);
        }
        return difference;
    }

    public static <T> boolean equals(Collection<T> c1, Collection<T> c2) {
        if (c1 == null || c2 == null) {
            return c1 == c2;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        if (c1 == c2) {
            return true;
        }
        if (!c1.containsAll(c2)) {
            return false;
        }
        return c2.containsAll(c1);
    }

    public static <T> List<T> shiftElementsToEnd(List<T> source, int count) {
        int i;
        ArrayList<T> rVal = new ArrayList<T>(source.size());
        for (i = count; i < source.size(); ++i) {
            rVal.add(source.get(i));
        }
        for (i = 0; i < count; ++i) {
            rVal.add(source.get(i));
        }
        if (source.size() != rVal.size()) {
            throw new IllegalStateException("Didnt work for: " + count + " " + source + " : " + rVal);
        }
        return rVal;
    }

    private Util() {
    }

    public static boolean isMailValid(String emailAddress) {
        String QUOTEDSTRING = "\"(?:[^\"\\\\]|\\\\\\p{ASCII})*\"";
        String ATOM = "[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+";
        String WORD = "(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\"(?:[^\"\\\\]|\\\\\\p{ASCII})*\")";
        String SUBDOMAIN = "(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\\[(?:[^\\[\\]\\\\]|\\\\\\p{ASCII})*\\])";
        String DOMAIN = "(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\\[(?:[^\\[\\]\\\\]|\\\\\\p{ASCII})*\\])(?:\\.(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\\[(?:[^\\[\\]\\\\]|\\\\\\p{ASCII})*\\]))*";
        String LOCALPART = "(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\"(?:[^\"\\\\]|\\\\\\p{ASCII})*\")(?:\\.(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\"(?:[^\"\\\\]|\\\\\\p{ASCII})*\"))*";
        String EMAIL = "(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\"(?:[^\"\\\\]|\\\\\\p{ASCII})*\")(?:\\.(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\"(?:[^\"\\\\]|\\\\\\p{ASCII})*\"))*@(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\\[(?:[^\\[\\]\\\\]|\\\\\\p{ASCII})*\\])(?:\\.(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\\[(?:[^\\[\\]\\\\]|\\\\\\p{ASCII})*\\]))*";
        String regex = "(\\s*(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\"(?:[^\"\\\\]|\\\\\\p{ASCII})*\")(?:\\.(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\"(?:[^\"\\\\]|\\\\\\p{ASCII})*\"))*@(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\\[(?:[^\\[\\]\\\\]|\\\\\\p{ASCII})*\\])(?:\\.(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\\[(?:[^\\[\\]\\\\]|\\\\\\p{ASCII})*\\]))*\\s*)*";
        return emailAddress.matches("(\\s*(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\"(?:[^\"\\\\]|\\\\\\p{ASCII})*\")(?:\\.(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\"(?:[^\"\\\\]|\\\\\\p{ASCII})*\"))*@(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\\[(?:[^\\[\\]\\\\]|\\\\\\p{ASCII})*\\])(?:\\.(?:[^()<>@,;:\\\\\".\\[\\] \\x28\\p{Cntrl}]+|\\[(?:[^\\[\\]\\\\]|\\\\\\p{ASCII})*\\]))*\\s*)*");
    }

    public static String createUniqueTimeStamp() {
        long time = System.currentTimeMillis();
        while (time == System.currentTimeMillis()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return "" + System.currentTimeMillis();
    }

    public static <T> void reorder(List<T> reorder, List<T> order) {
        final IntegerMap<T> map = new IntegerMap<T>();
        for (T o : order) {
            map.put(o, order.indexOf(o));
        }
        Collections.sort(reorder, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int v2;
                int v1 = map.getInt(o1);
                if (v1 > (v2 = map.getInt(o2))) {
                    return 1;
                }
                if (v1 == v2) {
                    return 0;
                }
                return -1;
            }
        });
    }
}

