/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.util;

import java.io.Serializable;
import java.util.Comparator;
import java.util.StringTokenizer;

public class Version
implements Serializable,
Comparable {
    static final long serialVersionUID = -4770210855326775333L;
    private final int m_major;
    private final int m_minor;
    private final int m_point;
    private final int m_micro;

    public Version(int major, int minor) {
        this(major, minor, 0);
    }

    public Version(int major, int minor, int point) {
        this(major, minor, point, 0);
    }

    public Version(int major, int minor, int point, int micro) {
        this.m_major = major;
        this.m_minor = minor;
        this.m_point = point;
        this.m_micro = micro;
    }

    public Version(String version) {
        this(version, ".");
    }

    public Version(String version, String delimiter) {
        StringTokenizer tokens = new StringTokenizer(version, delimiter, false);
        if (tokens.countTokens() < 1) {
            throw new IllegalArgumentException("invalid version string:" + version);
        }
        try {
            this.m_major = Integer.parseInt(tokens.nextToken());
            this.m_minor = tokens.hasMoreTokens() ? Integer.parseInt(tokens.nextToken()) : 0;
            this.m_point = tokens.hasMoreTokens() ? Integer.parseInt(tokens.nextToken()) : 0;
            this.m_micro = tokens.hasMoreTokens() ? Integer.parseInt(tokens.nextToken()) : 0;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("invalid version string:" + version);
        }
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public boolean equals(Object o, boolean ignoreMicro) {
        return this.compareTo(o, ignoreMicro) == 0;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int compareTo(Object o) {
        return this.compareTo(o, false);
    }

    public int compareTo(Version other) {
        return this.compareTo(other, false);
    }

    public int compareTo(Object o, boolean ignoreMicro) {
        if (o == null) {
            return -1;
        }
        if (!(o instanceof Version)) {
            return -1;
        }
        Version other = (Version)o;
        return this.compareTo(other, ignoreMicro);
    }

    public int compareTo(Version other, boolean ignoreMicro) {
        if (other == null) {
            return -1;
        }
        if (other.m_major > this.m_major) {
            return 1;
        }
        if (other.m_major < this.m_major) {
            return -1;
        }
        if (other.m_minor > this.m_minor) {
            return 1;
        }
        if (other.m_minor < this.m_minor) {
            return -1;
        }
        if (other.m_point > this.m_point) {
            return 1;
        }
        if (other.m_point < this.m_point) {
            return -1;
        }
        if (!ignoreMicro) {
            if (other.m_micro > this.m_micro) {
                return 1;
            }
            if (other.m_micro < this.m_micro) {
                return -1;
            }
        }
        return 0;
    }

    public boolean isGreaterThan(Version other, boolean ignoreMicro) {
        return this.compareTo(other, ignoreMicro) < 0;
    }

    public boolean isLessThan(Version other, boolean ignoreMicro) {
        return this.compareTo(other, ignoreMicro) > 0;
    }

    public static Comparator<Version> getHighestToLowestComparator(final boolean ignoreMicro) {
        return new Comparator<Version>(){

            @Override
            public int compare(Version v1, Version v2) {
                if (v1 == null && v2 == null) {
                    return 0;
                }
                if (v1 == null) {
                    return 1;
                }
                if (v2 == null) {
                    return -1;
                }
                if (v1.equals(v2, ignoreMicro)) {
                    return 0;
                }
                if (v1.isGreaterThan(v2, ignoreMicro)) {
                    return -1;
                }
                return 1;
            }
        };
    }

    public String toStringFull(String seperator) {
        return this.toStringFull(seperator, false);
    }

    public String toStringFull(String seperator, boolean noMicro) {
        return this.m_major + seperator + this.m_minor + seperator + this.m_point + (noMicro ? "" : seperator + this.m_micro);
    }

    public String toString() {
        return this.m_major + "." + this.m_minor + (this.m_point != 0 || this.m_micro != 0 ? "." + this.m_point : "") + (this.m_micro != 0 ? "." + this.m_micro : "");
    }
}

