/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.ribbon.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonContextualTaskGroup;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonRootPane;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonTaskToggleButton;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.flamingo.ribbon.ui.RibbonBorderShaper;
import org.pushingpixels.substance.flamingo.ribbon.ui.SubstanceRibbonBandUI;
import org.pushingpixels.substance.flamingo.ribbon.ui.SubstanceRibbonRootPaneUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.DecorationPainterUtils;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceRibbonUI
extends BasicRibbonUI {
    protected Set lafWidgets;
    protected JComponent tabPanelHeaderBackground;

    @Override
    protected void installComponents() {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults() {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__installListeners() {
        super.installListeners();
    }

    @Override
    protected void installListeners() {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__uninstallListeners() {
        super.uninstallListeners();
    }

    @Override
    protected void uninstallListeners() {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    @Override
    protected void uninstallComponents() {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    public void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void uninstallDefaults() {
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceRibbonUI();
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__installDefaults() {
        super.installDefaults();
        SubstanceLookAndFeel.setDecorationType(this.ribbon, DecorationAreaType.HEADER);
        Color backgr = this.ribbon.getBackground();
        if (backgr == null || backgr instanceof UIResource) {
            Color toSet = SubstanceColorSchemeUtilities.getColorScheme(this.ribbon, ComponentState.ENABLED).getBackgroundFillColor();
            this.ribbon.setBackground(new ColorUIResource(toSet));
        }
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__uninstallDefaults() {
        DecorationPainterUtils.clearDecorationType(this.ribbon);
        super.uninstallDefaults();
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__installComponents() {
        super.installComponents();
        this.tabPanelHeaderBackground = new JPanel();
        this.ribbon.add(this.tabPanelHeaderBackground);
        SubstanceLookAndFeel.setDecorationType(this.tabPanelHeaderBackground, DecorationAreaType.HEADER);
        SubstanceLookAndFeel.setDecorationType(this.taskBarPanel, DecorationAreaType.PRIMARY_TITLE_PANE);
        SubstanceLookAndFeel.setDecorationType(this.ribbon, DecorationAreaType.HEADER);
        SubstanceLookAndFeel.setDecorationType(this.bandScrollablePanel, DecorationAreaType.GENERAL);
    }

    protected void __org__pushingpixels__substance__flamingo__ribbon__ui__SubstanceRibbonUI__uninstallComponents() {
        this.ribbon.remove(this.tabPanelHeaderBackground);
        DecorationPainterUtils.clearDecorationType(this.taskBarPanel);
        super.uninstallComponents();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new SubstanceRibbonLayout();
    }

    @Override
    protected BasicRibbonUI.TaskToggleButtonsHostPanel createTaskToggleButtonsHostPanel() {
        return new SubstanceTaskToggleButtonsHostPanel();
    }

    @Override
    protected BasicRibbonUI.BandHostPanel createBandHostPanel() {
        return new SubstanceBandHostPanel();
    }

    @Override
    protected void paintBackground(Graphics g) {
        BackgroundPaintingUtils.update(g, this.ribbon, false);
    }

    @Override
    protected void paintTaskArea(Graphics g, int x, int y, int width, int height) {
        if (this.ribbon.getTaskCount() == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        RibbonTask selectedTask = this.ribbon.getSelectedTask();
        JRibbonTaskToggleButton selectedTaskButton = (JRibbonTaskToggleButton)this.taskToggleButtons.get(selectedTask);
        Rectangle selectedTaskButtonBounds = selectedTaskButton.getBounds();
        Point converted = SwingUtilities.convertPoint(selectedTaskButton.getParent(), selectedTaskButtonBounds.getLocation(), this.ribbon);
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(this.ribbon));
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.ribbon)) / 2.0);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(this.ribbon);
        int borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.ribbon));
        AbstractRibbonBand<?> band = selectedTask.getBandCount() == 0 ? null : selectedTask.getBand(0);
        SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(band, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        Rectangle taskToggleButtonsViewportBounds = ((BasicRibbonUI.TaskToggleButtonsHostPanel)this.taskToggleButtonsScrollablePanel.getView()).getParent().getBounds();
        taskToggleButtonsViewportBounds.setLocation(SwingUtilities.convertPoint(this.taskToggleButtonsScrollablePanel, taskToggleButtonsViewportBounds.getLocation(), this.ribbon));
        int startSelectedX = Math.max(converted.x + 1, (int)taskToggleButtonsViewportBounds.getMinX());
        startSelectedX = Math.min(startSelectedX, (int)taskToggleButtonsViewportBounds.getMaxX());
        int endSelectedX = Math.min(converted.x + selectedTaskButtonBounds.width - 1, (int)taskToggleButtonsViewportBounds.getMaxX());
        endSelectedX = Math.max(endSelectedX, (int)taskToggleButtonsViewportBounds.getMinX());
        GeneralPath outerContour = RibbonBorderShaper.getRibbonBorderOutline(this.ribbon, x + borderDelta, x + width - 2 * borderDelta - 1, startSelectedX + borderDelta, endSelectedX - 2 * borderDelta, converted.y + borderDelta, y + borderDelta, y + height - 2 * borderDelta, radius);
        GeneralPath innerContour = RibbonBorderShaper.getRibbonBorderOutline(this.ribbon, x + borderDelta + borderThickness, x + width - 2 * (borderDelta + borderThickness) - 1, startSelectedX + borderDelta + borderThickness, endSelectedX - 2 * (borderDelta + borderThickness), converted.y + borderDelta + borderThickness, y + borderDelta + borderThickness, y + height - 2 * (borderDelta + borderThickness) + 1, radius);
        g2d.setColor(SubstanceColorSchemeUtilities.getColorScheme(band, ComponentState.ENABLED).getBackgroundFillColor());
        g2d.clipRect(x, y, width, height + 2);
        g2d.fill(outerContour);
        borderPainter.paintBorder(g2d, this.ribbon, width, height + selectedTaskButtonBounds.height + 1, outerContour, innerContour, borderScheme);
        RibbonTask selected = selectedTask;
        RibbonContextualTaskGroup contextualGroup = selected.getContextualGroup();
        if (contextualGroup != null) {
            Insets ins = this.ribbon.getInsets();
            int topY = ins.top + this.getTaskbarHeight();
            int bottomY = topY + 5;
            Color hueColor = contextualGroup.getHueColor();
            GradientPaint paint = new GradientPaint(0.0f, topY, FlamingoUtilities.getAlphaColor(hueColor, 63), 0.0f, bottomY, FlamingoUtilities.getAlphaColor(hueColor, 0));
            g2d.setPaint(paint);
            g2d.clip(outerContour);
            g2d.fillRect(0, topY, width, bottomY - topY + 1);
        }
        g2d.dispose();
    }

    @Override
    protected int getTabButtonGap() {
        return SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(this.ribbon), super.getTabButtonGap(), 3, 1, false);
    }

    @Override
    protected void syncApplicationMenuTips() {
        JRibbonRootPane ribbonRootPane = (JRibbonRootPane)SwingUtilities.getRootPane(this.ribbon);
        if (ribbonRootPane == null) {
            return;
        }
        SubstanceRibbonRootPaneUI ribbonRootPaneUI = (SubstanceRibbonRootPaneUI)ribbonRootPane.getUI();
        ribbonRootPaneUI.syncApplicationMenuTips();
    }

    @Override
    protected void paintMinimizedRibbonSeparator(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate(0, this.ribbon.getHeight() - 1);
        SeparatorPainterUtils.paintSeparator(this.ribbon, g2d, this.ribbon.getWidth(), 0, 0, false, 0);
        g2d.dispose();
    }

    protected class SubstanceRibbonLayout
    extends BasicRibbonUI.RibbonLayout {
        protected SubstanceRibbonLayout() {
        }

        @Override
        public void layoutContainer(Container c) {
            super.layoutContainer(c);
            SubstanceRibbonUI.this.tabPanelHeaderBackground.setBounds(0, SubstanceRibbonUI.this.taskToggleButtonsScrollablePanel.getY(), SubstanceRibbonUI.this.ribbon.getWidth(), SubstanceRibbonUI.this.taskToggleButtonsScrollablePanel.getHeight());
            SubstanceRibbonUI.this.ribbon.setComponentZOrder(SubstanceRibbonUI.this.tabPanelHeaderBackground, SubstanceRibbonUI.this.ribbon.getComponentCount() - 1);
        }
    }

    protected class SubstanceBandHostPanel
    extends BasicRibbonUI.BandHostPanel {
        protected SubstanceBandHostPanel() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            int dy = 0;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component child = this.getComponent(i);
                if (!(child instanceof AbstractRibbonBand)) continue;
                dy = child.getBounds().y;
                break;
            }
            SubstanceRibbonBandUI.paintRibbonBandBackground(g, this, 0.0f, dy);
        }
    }

    protected class SubstanceTaskToggleButtonsHostPanel
    extends BasicRibbonUI.TaskToggleButtonsHostPanel {
        protected SubstanceTaskToggleButtonsHostPanel() {
        }

        @Override
        protected void paintContextualTaskGroupOutlines(Graphics g, RibbonContextualTaskGroup group, Rectangle groupBounds) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(groupBounds.x, 0);
            SeparatorPainterUtils.paintSeparator(SubstanceRibbonUI.this.ribbon, g2d, 2, groupBounds.height * 3 / 4, 1, false, 0, groupBounds.height / 3, true);
            g2d.translate(groupBounds.width - 1, 0);
            SeparatorPainterUtils.paintSeparator(SubstanceRibbonUI.this.ribbon, g2d, 2, groupBounds.height * 3 / 4, 1, false, 0, groupBounds.height / 3, true);
            g2d.dispose();
        }

        @Override
        protected void paintTaskOutlines(Graphics g) {
            int i;
            Graphics2D g2d = (Graphics2D)g.create();
            SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(SubstanceRibbonUI.this.ribbon, ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
            HashSet<RibbonTask> tasksWithTrailingSeparators = new HashSet<RibbonTask>();
            for (i = 0; i < SubstanceRibbonUI.this.ribbon.getTaskCount() - 1; ++i) {
                RibbonTask task = SubstanceRibbonUI.this.ribbon.getTask(i);
                tasksWithTrailingSeparators.add(task);
            }
            for (i = 0; i < SubstanceRibbonUI.this.ribbon.getContextualTaskGroupCount(); ++i) {
                RibbonContextualTaskGroup group = SubstanceRibbonUI.this.ribbon.getContextualTaskGroup(i);
                if (!SubstanceRibbonUI.this.ribbon.isVisible(group)) continue;
                for (int j = 0; j < group.getTaskCount() - 1; ++j) {
                    RibbonTask task = group.getTask(j);
                    tasksWithTrailingSeparators.add(task);
                }
            }
            for (RibbonTask taskWithTrailingSeparator : tasksWithTrailingSeparators) {
                JRibbonTaskToggleButton taskToggleButton = (JRibbonTaskToggleButton)SubstanceRibbonUI.this.taskToggleButtons.get(taskWithTrailingSeparator);
                Rectangle bounds = taskToggleButton.getBounds();
                int x = bounds.x + bounds.width + SubstanceRibbonUI.this.getTabButtonGap() / 2 - 1;
                g2d.translate(x, 0);
                SeparatorPainterUtils.paintSeparator(SubstanceRibbonUI.this.ribbon, g2d, scheme, 2, this.getHeight(), 1, false, this.getHeight() / 3, 0, true);
                g2d.translate(-x, 0);
            }
            g2d.dispose();
        }
    }
}

