/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.plaf.MonthViewUI;
import org.jdesktop.swingx.plaf.basic.BasicDatePickerUI;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceDropDownButton;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceTextComponentBorder;
import org.pushingpixels.substance.swingx.SubstanceMonthViewUI;

public class SubstanceDatePickerUI
extends BasicDatePickerUI {
    protected Set lafWidgets;
    protected PropertyChangeListener substancePropertyChangeListener;
    protected JButton substancePopupButton;
    private Insets layoutInsets;

    protected void __org__pushingpixels__substance__swingx__SubstanceDatePickerUI__installComponents() {
        super.installComponents();
    }

    @Override
    protected void installComponents() {
        this.__org__pushingpixels__substance__swingx__SubstanceDatePickerUI__installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__swingx__SubstanceDatePickerUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults() {
        this.__org__pushingpixels__substance__swingx__SubstanceDatePickerUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installListeners() {
        this.__org__pushingpixels__substance__swingx__SubstanceDatePickerUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.__org__pushingpixels__substance__swingx__SubstanceDatePickerUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceDatePickerUI__uninstallComponents() {
        super.uninstallComponents();
    }

    @Override
    protected void uninstallComponents() {
        this.__org__pushingpixels__substance__swingx__SubstanceDatePickerUI__uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__swingx__SubstanceDatePickerUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceDatePickerUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        this.__org__pushingpixels__substance__swingx__SubstanceDatePickerUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__pushingpixels__substance__swingx__SubstanceDatePickerUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__pushingpixels__substance__swingx__SubstanceDatePickerUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceDatePickerUI();
    }

    public void __org__pushingpixels__substance__swingx__SubstanceDatePickerUI__installUI(JComponent c) {
        super.installUI(c);
        c.putClientProperty("substancelaf.internal.textComponentAware", new SubstanceCoreUtilities.TextComponentAware<JXDatePicker>(){

            @Override
            public JTextComponent getTextComponent(JXDatePicker t) {
                return t.getEditor();
            }
        });
    }

    public void __org__pushingpixels__substance__swingx__SubstanceDatePickerUI__uninstallUI(JComponent c) {
        c.putClientProperty("substancelaf.internal.textComponentAware", null);
        super.uninstallUI(c);
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceDatePickerUI__installListeners() {
        super.installListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("componentOrientation".equals(evt.getPropertyName())) {
                    SubstanceDatePickerUI.this.configurePopupButton();
                }
            }
        };
        this.datePicker.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceDatePickerUI__uninstallListeners() {
        this.datePicker.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    protected void __org__pushingpixels__substance__swingx__SubstanceDatePickerUI__installDefaults() {
        super.installDefaults();
        Border b = this.datePicker.getBorder();
        if (b == null || b instanceof UIResource) {
            int fontSize = SubstanceSizeUtils.getComponentFontSize(this.datePicker);
            Insets borderInsets = SubstanceSizeUtils.getComboBorderInsets(fontSize);
            this.datePicker.setBorder(new SubstanceTextComponentBorder(borderInsets));
            this.layoutInsets = SubstanceSizeUtils.getComboLayoutInsets(fontSize);
        }
        this.datePicker.setOpaque(false);
    }

    @Override
    protected JButton createPopupButton() {
        this.substancePopupButton = new SubstanceDropDownButton(this.datePicker);
        this.substancePopupButton.setFocusPainted(false);
        this.configurePopupButton();
        this.substancePopupButton.setIcon(SubstanceCoreUtilities.getArrowIcon(this.substancePopupButton, 5));
        return this.substancePopupButton;
    }

    private void configurePopupButton() {
        SubstanceConstants.Side side = this.datePicker.getComponentOrientation().isLeftToRight() ? SubstanceConstants.Side.LEFT : SubstanceConstants.Side.RIGHT;
        this.substancePopupButton.putClientProperty("substancelaf.buttonside", (Object)side);
        this.substancePopupButton.setRolloverEnabled(true);
    }

    @Override
    public void hidePopup() {
        super.hidePopup();
        JXMonthView popupMonthView = this.datePicker.getMonthView();
        MonthViewUI ui = popupMonthView.getUI();
        if (ui instanceof SubstanceMonthViewUI) {
            ((SubstanceMonthViewUI)ui).resetRolloverIndex();
        }
    }

    @Override
    protected JFormattedTextField createEditor() {
        JFormattedTextField result = super.createEditor();
        Insets ins = SubstanceSizeUtils.getComboTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(result));
        result.setBorder(new EmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
        result.setBackground(this.datePicker.getBackground());
        result.setOpaque(false);
        return result;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        int componentFontSize = SubstanceSizeUtils.getComponentFontSize(this.datePicker);
        int borderDelta = (int)Math.floor(SubstanceSizeUtils.getBorderStrokeWidth(componentFontSize));
        GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(this.datePicker.getWidth(), this.datePicker.getHeight(), Math.max(0.0f, 2.0f * SubstanceSizeUtils.getClassicButtonCornerRadius(componentFontSize) - (float)borderDelta), null, borderDelta);
        graphics.setColor(SubstanceTextUtilities.getTextBackgroundFillColor(this.datePicker));
        graphics.fill(contour);
        super.paint(g, c);
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new DatePickerLayoutManager();
    }

    private class DatePickerLayoutManager
    implements LayoutManager {
        private DatePickerLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            int popupButtonWidth = SubstanceDatePickerUI.this.substancePopupButton != null ? SubstanceDatePickerUI.this.substancePopupButton.getPreferredSize().width : 0;
            boolean ltr = SubstanceDatePickerUI.this.datePicker.getComponentOrientation().isLeftToRight();
            SubstanceDatePickerUI.this.datePicker.getEditor().setBounds(ltr ? ((SubstanceDatePickerUI)SubstanceDatePickerUI.this).layoutInsets.left : ((SubstanceDatePickerUI)SubstanceDatePickerUI.this).layoutInsets.left + popupButtonWidth, ((SubstanceDatePickerUI)SubstanceDatePickerUI.this).layoutInsets.top, SubstanceDatePickerUI.this.datePicker.getWidth() - popupButtonWidth - ((SubstanceDatePickerUI)SubstanceDatePickerUI.this).layoutInsets.left - ((SubstanceDatePickerUI)SubstanceDatePickerUI.this).layoutInsets.right, SubstanceDatePickerUI.this.datePicker.getHeight() - ((SubstanceDatePickerUI)SubstanceDatePickerUI.this).layoutInsets.top - ((SubstanceDatePickerUI)SubstanceDatePickerUI.this).layoutInsets.bottom);
            if (SubstanceDatePickerUI.this.substancePopupButton != null) {
                if (ltr) {
                    SubstanceDatePickerUI.this.substancePopupButton.setBounds(SubstanceDatePickerUI.this.datePicker.getWidth() - popupButtonWidth, 0, popupButtonWidth, SubstanceDatePickerUI.this.datePicker.getHeight());
                } else {
                    SubstanceDatePickerUI.this.substancePopupButton.setBounds(0, 0, popupButtonWidth, SubstanceDatePickerUI.this.datePicker.getHeight());
                }
            }
        }
    }
}

