/*
 * Decompiled with CFR 0.152.
 */
package tools.docrobot;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.fest.swing.core.BasicRobot;
import org.fest.swing.core.Robot;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.timing.Pause;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import test.check.SampleFrame;
import tools.docrobot.SkinRobot;

public abstract class BaseRobot {
    protected SubstanceSkin skin;
    protected String screenshotFilename;
    protected SampleFrame sf;

    public BaseRobot(SubstanceSkin skin, String screenshotFilename) {
        this.skin = skin;
        this.screenshotFilename = screenshotFilename;
    }

    public void run() {
        long start = System.currentTimeMillis();
        Robot robot = BasicRobot.robotWithNewAwtHierarchy();
        GuiActionRunner.execute((GuiTask)new GuiTask(){

            protected void executeInEDT() throws Throwable {
                SubstanceLookAndFeel.setSkin(BaseRobot.this.skin);
                JFrame.setDefaultLookAndFeelDecorated(true);
            }
        });
        robot.waitForIdle();
        GuiActionRunner.execute((GuiTask)new GuiTask(){

            protected void executeInEDT() throws Throwable {
                BaseRobot.this.sf = new SampleFrame();
                BaseRobot.this.sf.setIconImage((Image)SubstanceImageCreator.getColorSchemeImage(null, new ImageIcon(SkinRobot.class.getClassLoader().getResource("test/resource/image-x-generic.png")), SubstanceLookAndFeel.getCurrentSkin(BaseRobot.this.sf.getRootPane()).getActiveColorScheme(DecorationAreaType.PRIMARY_TITLE_PANE), 0.0f));
                BaseRobot.this.sf.setSize(338, 245);
                BaseRobot.this.sf.setLocationRelativeTo(null);
                BaseRobot.this.sf.setDefaultCloseOperation(3);
                BaseRobot.this.sf.setVisible(true);
            }
        });
        robot.waitForIdle();
        Pause.pause((long)1000L);
        GuiActionRunner.execute((GuiTask)new GuiTask(){

            protected void executeInEDT() throws Throwable {
                BaseRobot.this.makeScreenshot();
            }
        });
        robot.waitForIdle();
        GuiActionRunner.execute((GuiTask)new GuiTask(){

            protected void executeInEDT() throws Throwable {
                BaseRobot.this.sf.dispose();
            }
        });
        robot.waitForIdle();
        long end = System.currentTimeMillis();
        System.out.println(this.getClass().getSimpleName() + " : " + (end - start) + "ms");
    }

    public void makeScreenshot() {
        BufferedImage bi = new BufferedImage(this.sf.getWidth(), this.sf.getHeight(), 2);
        Graphics g = bi.getGraphics();
        this.sf.paint(g);
        try {
            File target = new File(this.screenshotFilename);
            target.getParentFile().mkdirs();
            ImageIO.write((RenderedImage)bi, "png", target);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

